package org.cocos2d.tests;

import org.cocos2d.CCDirector;
import org.cocos2d.cocoa.CCGeometry.CCSize;
import org.cocos2d.include.ccTypes.ccColor4B;
import org.cocos2d.layers_scenes_transitions_nodes.CCLayerColor;
import org.cocos2d.layers_scenes_transitions_nodes.CCLayer;
import org.cocos2d.layers_scenes_transitions_nodes.CCScene;
import org.cocos2d.lib.Cocos2dActivity;
import org.cocos2d.menu_nodes.CCMenu;
import org.cocos2d.menu_nodes.CCMenuItemFont;
import org.cocos2d.nodes.CCLabel;
import org.cocos2d.support.CCPointExtension;
import org.cocos2d.transitions.CCFlipXTransition;
import org.cocos2d.transitions.CCSlideInTTransition;
import org.cocos2d.transitions.CCTransitionScene;

import android.os.Bundle;
import android.view.MotionEvent;

public class SceneTest extends Cocos2dActivity {
	// private static final String TAG = SceneTest.class.getSimpleName();

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);

		// set landscape mode
		CCDirector.sharedDirector().setLandscape(false);

		// show Stats
		CCDirector.sharedDirector().setDisplayStats(true);

		// frames per second
		CCDirector.sharedDirector().setAnimationInterval(1.0f / 60.0f);

		CCScene scene = CCScene.create();
		scene.addChild(Layer1.create(), 0);

		// Make the Scene active
		CCDirector.sharedDirector().runWithScene(scene);
	}

	static class Layer1 extends CCLayer {
		public static Layer1 create() {
			Layer1 pRet = new Layer1();
			if((pRet != null) && pRet.init()) {
				return pRet;
			}
			pRet = null;
			return null;
		}

		public boolean init() {
			if(super.init()) {
				CCMenuItemFont item1 = CCMenuItemFont.create("Test pushScene", this, "onPushScene");
				CCMenuItemFont item2 = CCMenuItemFont.create("Test pushScene w/transition", this, "onPushSceneTran");
				CCMenuItemFont item3 = CCMenuItemFont.create("Quit", this, "onQuit");
	
				CCMenu menu = CCMenu.create(item1, item2, item3);
				menu.alignItemsVertically();
	
				addChild(menu);
			}
			return true;
		}

		public void onPushScene(Object sender) {
			CCScene scene = CCScene.create();
			scene.addChild(Layer2.create(), 0);
			CCDirector.sharedDirector().pushScene(scene);
		}

		public void onPushSceneTran(Object sender) {
			CCScene scene = CCScene.create();
			scene.addChild(Layer2.create(), 0);
			CCDirector.sharedDirector().pushScene(CCSlideInTTransition.transition(1, scene));
		}

		public void onQuit(Object sender) {
			CCDirector.sharedDirector().popScene();
		}
	}

	static class Layer2 extends CCLayer {

		float timeCounter;

		public static Layer2 create() {
			Layer2 pRet = new Layer2();
			if((pRet != null) && pRet.init()) {
				return pRet;
			}
			pRet = null;
			return null;
		}

		public boolean init() {
			if(super.init()) {
				timeCounter = 0;
	
				CCMenuItemFont item1 = CCMenuItemFont.create("Replace Scene", this, "onReplaceScene");
				CCMenuItemFont item2 = CCMenuItemFont.create("Replace Scene Transition", this, "onReplaceSceneTran");
				CCMenuItemFont item3 = CCMenuItemFont.create("Go Back", this, "onGoBack");
	
				CCMenu menu = CCMenu.create(item1, item2, item3);
				menu.alignItemsVertically();
	
				addChild(menu);
	
				this.schedule("testDealloc");
			}
			return true;
		}

		public void testDealloc(float dt) {
			timeCounter += dt;
			if(timeCounter > 10) {
				this.onReplaceScene(this);
			}
		}

		public void onGoBack(Object sender) {
			CCDirector.sharedDirector().popScene();
		}

		public void onReplaceScene(Object sender) {
			CCScene scene = CCScene.create();
			scene.addChild(Layer3.create(), 0);
			CCDirector.sharedDirector().replaceScene(scene);
		}

		public void onReplaceSceneTran(Object sender) {
			CCScene s = CCScene.create();
			s.addChild(Layer3.create(), 0);
			CCDirector.sharedDirector().replaceScene(CCFlipXTransition.transition(2, s, CCTransitionScene.tOrientation.kOrientationLeftOver));
		}
	}

	static class Layer3 extends CCLayerColor {
		public static Layer3 create() {
			Layer3 pRet = new Layer3();
			if((pRet != null) && (pRet.initWithColor(ccColor4B.ccc4(0, 0, 255, 255)))) {
				return pRet;
			}
			pRet = null;
			return null;
		}

		public boolean initWithColor(final ccColor4B color) {
			if(super.initWithColor(color)) {
				this.setTouchEnabled(true);
				CCLabel label =  CCLabel.makeLabel("Touch to popScene", "Droid Sans", 32);
				this.addChild(label);
				CCSize s = CCDirector.sharedDirector().getWinSize();
				label.setPosition(CCPointExtension.ccp(s.width/2, s.height/2));
			}
			return true;
		}

		public boolean ccTouchesEnded(MotionEvent event) {
			CCDirector.sharedDirector().popScene();
			return true;
		}
	}
}
