/****************************************************************************
Copyright (c) 2010-2011 cocos2d-x.org

http://www.cocos2d-x.org

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
 ****************************************************************************/
package org.cocos2d.lib;

import static javax.microedition.khronos.opengles.GL10.GL_DITHER;
import static javax.microedition.khronos.opengles.GL10.GL_FASTEST;
import static javax.microedition.khronos.opengles.GL10.GL_PERSPECTIVE_CORRECTION_HINT;

import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

import org.cocos2d.CCDirector;
import org.cocos2d.events.CCKeyDispatcher;
import org.cocos2d.events.CCTouchDispatcher;
import org.cocos2d.opengl.GLResourceHelper;
import org.cocos2d.platform.CCApplication;
import org.cocos2d.shaders.CCShaderCache;
import org.cocos2d.shaders.ccGLStateCache;
import org.cocos2d.textures.CCTextureCache;

import android.opengl.GLSurfaceView;

public class Cocos2dRenderer implements GLSurfaceView.Renderer {
	// ===========================================================
	// Constants
	// ===========================================================

	private final static long NANOSECONDSPERSECOND = 1000000000L;
	private final static long NANOSECONDSPERMICROSECOND = 1000000;

	private static long sAnimationInterval = (long) (1.0 / 60 * Cocos2dRenderer.NANOSECONDSPERSECOND);

	// ===========================================================
	// Fields
	// ===========================================================

	private long mLastTickInNanoSeconds;
	private int mScreenWidth;
	private int mScreenHeight;

	// ===========================================================
	// Constructors
	// ===========================================================

	// ===========================================================
	// Getter & Setter
	// ===========================================================

	public static void setAnimationInterval(final double pAnimationInterval) {
		Cocos2dRenderer.sAnimationInterval = (long) (pAnimationInterval * Cocos2dRenderer.NANOSECONDSPERSECOND);
	}

	public void setScreenWidthAndHeight(final int pSurfaceWidth, final int pSurfaceHeight) {
		this.mScreenWidth = pSurfaceWidth;
		this.mScreenHeight = pSurfaceHeight;
	}

	// ===========================================================
	// Methods for/from SuperClass/Interfaces
	// ===========================================================

	@Override
	public void onSurfaceCreated(final GL10 pGL10, final EGLConfig pEGLConfig) {
		CCDirector.gl = pGL10;

		// TODO legacy -->

		/*
		 * By default, OpenGL enables features that improve quality
		 * but reduce performance. One might want to tweak that
		 * especially on software renderer.
		 */
		pGL10.glDisable(GL_DITHER);

		/*
		 * Some one-time OpenGL initialization can be made here
		 * probably based on features of this particular context
		 */
		pGL10.glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_FASTEST);

//		setGLDefaultValues();

		// save thread id
		GLResourceHelper.sharedHelper().setGlThreadID( Thread.currentThread().getId() );

		// reload all GL resources here
		GLResourceHelper.sharedHelper().reloadResources();

		// TODO legacy <--

		Cocos2dRenderer.nativeInit(this.mScreenWidth, this.mScreenHeight);
		this.mLastTickInNanoSeconds = System.nanoTime();
	}

	@Override
	public void onSurfaceChanged(final GL10 pGL10, final int pWidth, final int pHeight) {
		// TODO legacy -->
		CCDirector.gl = pGL10;
//		surfaceSize_.setSize(pWidth, pHeight);
		pGL10.glViewport(0, 0, pWidth, pHeight);
//		setProjection(m_eProjection);
		// TODO legacy <--
	}

	@Override
	public void onDrawFrame(final GL10 gl) {
		// TODO legacy -->
		CCDirector.gl = gl;

		GLResourceHelper.sharedHelper().setInUpdate(true);

		CCTouchDispatcher.sharedDispatcher().update();
		//added by Ishaq 
		CCKeyDispatcher.sharedDispatcher().update();

		GLResourceHelper.sharedHelper().setInUpdate(false);
		// TODO legacy <--

		/*
		 * FPS controlling algorithm is not accurate, and it will slow down FPS
		 * on some devices. So comment FPS controlling code.
		 */
		
		/*
		final long nowInNanoSeconds = System.nanoTime();
		final long interval = nowInNanoSeconds - this.mLastTickInNanoSeconds;
		*/

		// should render a frame when onDrawFrame() is called or there is a
		// "ghost"
		Cocos2dRenderer.nativeRender();

		/*
		// fps controlling
		if (interval < Cocos2dxRenderer.sAnimationInterval) {
			try {
				// because we render it before, so we should sleep twice time interval
				Thread.sleep((Cocos2dxRenderer.sAnimationInterval - interval) / Cocos2dxRenderer.NANOSECONDSPERMICROSECOND);
			} catch (final Exception e) {
			}
		}

		this.mLastTickInNanoSeconds = nowInNanoSeconds;
		*/
	}

	// ===========================================================
	// Methods
	// ===========================================================

	private static void nativeTouchesBegin(final int pID, final float pX, final float pY) {
// TODO		CCDirector.sharedDirector().getOpenGLView().handleTouchesBegin(1, pID, pX, pY);
	}

	private static void nativeTouchesEnd(final int pID, final float pX, final float pY) {
// TODO		CCDirector.sharedDirector().getOpenGLView().handleTouchesEnd(1, pID, pX, pY);
	}

	private static void nativeTouchesMove(final int[] pIDs, final float[] pXs, final float[] pYs) {
// TODO		CCDirector.sharedDirector().getOpenGLView().handleTouchesMove(pIDs.length, pIDs, pXs, pYs);
	}

	private static void nativeTouchesCancel(final int[] pIDs, final float[] pXs, final float[] pYs) {
// TODO		CCDirector.sharedDirector().getOpenGLView().handleTouchesCancel(pIDs.length, pIDs, pXs, pYs);
	}

	private static final int KEYCODE_BACK = 0x04;
	private static final int KEYCODE_MENU = 0x52;
	private static boolean nativeKeyDown(final int pKeyCode) {

		CCDirector pDirector = CCDirector.sharedDirector();
		switch (pKeyCode) {
		case KEYCODE_BACK:
// TODO			if (pDirector.getKeypadDispatcher().dispatchKeypadMSG(kTypeBackClicked))
// TODO				return true;
			break;
		case KEYCODE_MENU:
// TODO			if (pDirector.getKeypadDispatcher().dispatchKeypadMSG(kTypeMenuClicked))
// TODO				return true;
			break;
		default:
			return false;
		}
		return false;
	}

	private static void nativeRender() {
		CCDirector.sharedDirector().mainLoop();
	}

	private static void nativeInit(final int pWidth, final int pHeight) {
/* TODO
		if (CCDirector.sharedDirector().getOpenGLView() == null) {
			CCEGLView view = CCEGLView.sharedOpenGLView();
			view.setFrameSize(w, h);

			CCApplication.sharedApplication().run();
		} else {
			ccDrawInit();
			ccGLStateCache.ccGLInvalidateStateCache();

			CCShaderCache.sharedShaderCache().reloadDefaultShaders();
			CCTextureCache.reloadAllTextures();
			CCNotificationCenter.sharedNotificationCenter().postNotification(EVNET_COME_TO_FOREGROUND, null);
			CCDirector.sharedDirector().setGLDefaultValues();
		}
*/
	}

	private static void nativeOnPause() {
		CCApplication.sharedApplication().applicationDidEnterBackground();

// TODO		CCNotificationCenter.sharedNotificationCenter().postNotification(EVENT_COME_TO_BACKGROUND, null);
	}

	private static void nativeOnResume() {
		if (CCDirector.sharedDirector().getOpenGLView() != null) {
			CCApplication.sharedApplication().applicationWillEnterForeground();
		}
	}

	public void handleActionDown(final int pID, final float pX, final float pY) {
		Cocos2dRenderer.nativeTouchesBegin(pID, pX, pY);
	}

	public void handleActionUp(final int pID, final float pX, final float pY) {
		Cocos2dRenderer.nativeTouchesEnd(pID, pX, pY);
	}

	public void handleActionCancel(final int[] pIDs, final float[] pXs, final float[] pYs) {
		Cocos2dRenderer.nativeTouchesCancel(pIDs, pXs, pYs);
	}

	public void handleActionMove(final int[] pIDs, final float[] pXs, final float[] pYs) {
		Cocos2dRenderer.nativeTouchesMove(pIDs, pXs, pYs);
	}

	public void handleKeyDown(final int pKeyCode) {
		Cocos2dRenderer.nativeKeyDown(pKeyCode);
	}

	public void handleOnPause() {
		Cocos2dRenderer.nativeOnPause();
	}

	public void handleOnResume() {
		Cocos2dRenderer.nativeOnResume();
	}

	private static void nativeInsertText(final String pText) {
/* TODO
		final String pszText = env->GetStringUTFChars(text, null);
		CCIMEDispatcher.sharedDispatcher().dispatchInsertText(pszText, pszText.length());
		env->ReleaseStringUTFChars(text, pszText);
*/
	}

	private static void nativeDeleteBackward() {
// TODO		CCIMEDispatcher.sharedDispatcher().dispatchDeleteBackward();
	}

	private static String nativeGetContentText() {
/* TODO
		JNIEnv * env = 0;

		if (JniHelper::getJavaVM()->GetEnv((void**)&env, JNI_VERSION_1_4) != JNI_OK || ! env) {
			return null;
		}
		final String pszText = CCIMEDispatcher.sharedDispatcher().getContentText();
		return env->NewStringUTF(pszText);
*/
		return null;
	}

	public void handleInsertText(final String pText) {
		Cocos2dRenderer.nativeInsertText(pText);
	}

	public void handleDeleteBackward() {
		Cocos2dRenderer.nativeDeleteBackward();
	}

	public String getContentText() {
		return Cocos2dRenderer.nativeGetContentText();
	}

	// ===========================================================
	// Inner and Anonymous Classes
	// ===========================================================
}
