/****************************************************************************
Copyright (c) 2010-2012 cocos2d-x.org
Copyright (c) 2008-2010 Ricardo Quesada
Copyright (c) 2011      Zynga Inc.

http://www.cocos2d-x.org

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

Use any of these editors to generate BMFonts:
  http://glyphdesigner.71squared.com/ (Commercial, Mac OS X)
  http://www.n4te.com/hiero/hiero.jnlp (Free, Java)
  http://slick.cokeandcode.com/demos/hiero.jnlp (Free, Java)
  http://www.angelcode.com/products/bmfont/ (Free, Windows only)

****************************************************************************/
package org.cocos2d.label_nodes;

import org.cocos2d.include.CCProtocols.CCLabelProtocol;
import org.cocos2d.include.CCProtocols.CCRGBAProtocol;
import org.cocos2d.include.ccTypes.ccColor3B;
import org.cocos2d.sprite_nodes.CCSpriteBatchNode;

/**
 * @addtogroup GUI
 * @{
 * @addtogroup label
 * @{
 */

/** @brief CCLabelBMFont is a subclass of CCSpriteBatchNode.
 * 
 * Features:
 * - Treats each character like a CCSprite. This means that each individual character can be:
 * - rotated
 * - scaled
 * - translated
 * - tinted
 * - change the opacity
 * - It can be used as part of a menu item.
 * - anchorPoint can be used to align the "label"
 * - Supports AngelCode text format
 * 
 * Limitations:
 * - All inner characters are using an anchorPoint of (0.5f, 0.5f) and it is not recommend to change it
 * because it might affect the rendering
 * 
 * CCLabelBMFont implements the protocol CCLabelProtocol, like CCLabel and CCLabelAtlas.
 * CCLabelBMFont has the flexibility of CCLabel, the speed of CCLabelAtlas and all the features of CCSprite.
 * If in doubt, use CCLabelBMFont instead of CCLabelAtlas / CCLabel.
 * 
 * Supported editors:
 * http://glyphdesigner.71squared.com/ (Commercial, Mac OS X)
 * http://www.n4te.com/hiero/hiero.jnlp (Free, Java)
 * http://slick.cokeandcode.com/demos/hiero.jnlp (Free, Java)
 * http://www.angelcode.com/products/bmfont/ (Free, Windows only)
 * 
 * @since v0.8
 */
public class CCLabelBMFont extends CCSpriteBatchNode implements CCLabelProtocol, CCRGBAProtocol {

	public CCLabelBMFont() {
		;
	}

	@Override
	public void setColor(ccColor3B color) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public ccColor3B getColor() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public ccColor3B getDisplayedColor() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public int getDisplayedOpacity() {
		// TODO Auto-generated method stub
		return 0;
	}

	@Override
	public int getOpacity() {
		// TODO Auto-generated method stub
		return 0;
	}

	@Override
	public void setOpacity(int opacity) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void setOpacityModifyRGB(boolean bValue) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public boolean isOpacityModifyRGB() {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public boolean isCascadeColorEnabled() {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public void setCascadeColorEnabled(boolean cascadeColorEnabled) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void updateDisplayedColor(ccColor3B color) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public boolean isCascadeOpacityEnabled() {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public void setCascadeOpacityEnabled(boolean cascadeOpacityEnabled) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void updateDisplayedOpacity(int opacity) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void setString(String label) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public String getString() {
		// TODO Auto-generated method stub
		return null;
	}

}

// end of GUI group
/// @}
/// @}
