/*
Copyright (c) 2008, Luke Benstead.
All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice,
      this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright notice,
      this list of conditions and the following disclaimer in the documentation
      and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

package org.cocos2d.kazmath;

import static org.cocos2d.kazmath.Utility.kmEpsilon;
import static org.cocos2d.kazmath.Utility.kmSQR;

public class kmVec2 {

	public float x;
	public float y;

	public kmVec2 kmVec2Fill(kmVec2 pOut, float x, float y) {
		pOut.x = x;
		pOut.y = y;
		return pOut;
	}

	///< Returns the length of the vector
	public static float kmVec2Length(final kmVec2 pIn) {
		return (float) Math.sqrt(kmSQR(pIn.x) + kmSQR(pIn.y));
	}

	///< Returns the square of the length of the vector
	public static float kmVec2LengthSq(final kmVec2 pIn) {
		return kmSQR(pIn.x) + kmSQR(pIn.y);
	}

	///< Returns the vector passed in set to unit length
	public static kmVec2 kmVec2Normalize(kmVec2 pOut, final kmVec2 pIn) {
		float l = 1.0f / kmVec2Length(pIn);

		pOut.x = pIn.x * l;
		pOut.y = pIn.y * l;

		return pOut;
	}

	///< Adds 2 vectors and returns the result
	public static kmVec2 kmVec2Add(kmVec2 pOut, final kmVec2 pV1, final kmVec2 pV2) {
		pOut.x = pV1.x + pV2.x;
		pOut.y = pV1.y + pV2.y;

		return pOut;
	}

	/** Returns the Dot product which is the cosine of the angle between the two vectors multiplied by their lengths */
	public static float kmVec2Dot(final kmVec2 pV1, final kmVec2 pV2) {
		return pV1.x * pV2.x + pV1.y * pV2.y;
	}

	///< Subtracts 2 vectors and returns the result
	public static kmVec2 kmVec2Subtract(kmVec2 pOut, final kmVec2 pV1, final kmVec2 pV2) {
		pOut.x = pV1.x - pV2.x;
		pOut.y = pV1.y - pV2.y;

		return pOut;
	}

	/** Transform the Vector */
	public static kmVec2 kmVec2Transform(kmVec2 pOut, final kmVec2 pV, final kmMat3 pM) {
		pOut.x = pV.x * pM.mat[0] + pV.y * pM.mat[3] + pM.mat[6];
		pOut.y = pV.x * pM.mat[1] + pV.y * pM.mat[4] + pM.mat[7];

		return pOut;
	}

	///<Transforms a 2D vector by a given matrix, projecting the result back into w = 1.
	public static kmVec2 kmVec2TransformCoord(kmVec2 pOut, final kmVec2 pV, final kmMat3 pM) {
		assert false : "";
		return null;
	}

	///< Scales a vector to length s
	public static kmVec2 kmVec2Scale(kmVec2 pOut, final kmVec2 pIn, final float s) {
		pOut.x = pIn.x * s;
		pOut.y = pIn.y * s;

		return pOut;
	}

	///< Returns true if both vectors are equal
	public static boolean kmVec2AreEqual(final kmVec2 p1, final kmVec2 p2) {
		return (
					(p1.x < p2.x + kmEpsilon && p1.x > p2.x - kmEpsilon) &&
					(p1.y < p2.y + kmEpsilon && p1.y > p2.y - kmEpsilon)
				);
	}
}
