package org.cocos2d.platform;

import org.cocos2d.lib.Cocos2dxRenderer;
import org.cocos2d.platform.CCCommon.ccLanguageType;

public abstract class CCApplication extends CCApplicationProtocol {

	public CCApplication() {
		assert sm_pSharedApplication == null : "";
		sm_pSharedApplication = this;
	}

	/**
	 * @brief    Callback by CCDirector to limit FPS.
	 * @interval       The time, expressed in seconds, between current frame and next. 
	 */
	public void setAnimationInterval(double interval) {
		Cocos2dxRenderer.setAnimationInterval(interval);
	}

	/**
	 * @brief    Run the message loop.
	 */
	public int run() {
		// Initialize instance and cocos2d.
		if(! applicationDidFinishLaunching()) {
			return 0;
		}

		return -1;
	}

	/**
	 * @brief    Get current application instance.
	 * @return Current application instance pointer.
	 */
	public static CCApplication sharedApplication() {
		assert sm_pSharedApplication != null : "";
		return sm_pSharedApplication;
	}

	/**
	 * @brief Get current language config
	 * @return Current language config
	 */
	public ccLanguageType getCurrentLanguage() {
		// TODO
		return ccLanguageType.kLanguageEnglish;
	}

	/**
	 * @brief Get target platform
	 */
	public TargetPlatform getTargetPlatform() {
		return TargetPlatform.kTargetAndroid;
	}

	// sharedApplication pointer
	protected static CCApplication sm_pSharedApplication;
}
