package org.cocos2d.lib;

import org.cocos2d.CCDirector;
import org.cocos2d.lib.Cocos2dHelper.Cocos2dHelperListener;
import org.cocos2d.opengl.CCGLSurfaceView;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.view.Window;
import android.view.WindowManager;

public abstract class Cocos2dActivity extends Activity implements Cocos2dHelperListener {
	// ===========================================================
	// Constants
	// ===========================================================

	// private static final String TAG = Cocos2dActivity.class.getSimpleName();

	// ===========================================================
	// Fields
	// ===========================================================

	private CCGLSurfaceView mGLSurfaceView;
// TODO	private Cocos2dGLSurfaceView mGLSurfaceView;
// TODO	private Cocos2dHandler mHandler;
	private static Context sContext = null;

	public static Context getContext() {
		return sContext;
	}

	// ===========================================================
	// Constructors
	// ===========================================================

	@Override
	protected void onCreate(final Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		sContext = this;
// TODO		this.mHandler = new Cocos2dxHandler(this);

		this.init();

		Cocos2dHelper.init(this, this);
	}

	// ===========================================================
	// Getter & Setter
	// ===========================================================

	// ===========================================================
	// Methods for/from SuperClass/Interfaces
	// ===========================================================

	@Override
	protected void onResume() {
		super.onResume();

		Cocos2dHelper.onResume();
// TODO		this.mGLSurfaceView.onResume();

		// TODO legacy
		CCDirector.sharedDirector().onResume();
	}

	@Override
	protected void onPause() {
		super.onPause();

		Cocos2dHelper.onPause();
// TODO		this.mGLSurfaceView.onPause();

		// TODO legacy
		CCDirector.sharedDirector().onPause();
	}

	@Override
	public void showDialog(final String pTitle, final String pMessage) {
/* TODO
		Message msg = new Message();
		msg.what = Cocos2dHandler.HANDLER_SHOW_DIALOG;
		msg.obj = new Cocos2dHandler.DialogMessage(pTitle, pMessage);
		this.mHandler.sendMessage(msg);
*/
	}

	@Override
	public void showEditTextDialog(final String pTitle, final String pContent, final int pInputMode, final int pInputFlag, final int pReturnType, final int pMaxLength) {
/* TODO
		Message msg = new Message();
		msg.what = Cocos2dHandler.HANDLER_SHOW_EDITBOX_DIALOG;
		msg.obj = new Cocos2dHandler.EditBoxMessage(pTitle, pContent, pInputMode, pInputFlag, pReturnType, pMaxLength);
		this.mHandler.sendMessage(msg);
*/
	}
	
	@Override
	public void runOnGLThread(final Runnable pRunnable) {
		this.mGLSurfaceView.queueEvent(pRunnable);
	}

	// ===========================================================
	// Methods
	// ===========================================================

	public void init() {
		requestWindowFeature(Window.FEATURE_NO_TITLE);
		getWindow().setFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN,
				WindowManager.LayoutParams.FLAG_FULLSCREEN);
		getWindow().setFlags(WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON,
				WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON);

		this.mGLSurfaceView = this.onCreateView();

// TODO		this.mGLSurfaceView.setCocos2dRenderer(new Cocos2dRenderer());

		CCDirector director = CCDirector.sharedDirector();
		director.attachInView(mGLSurfaceView);
		director.setDeviceOrientation(CCDirector.kCCDeviceOrientationLandscapeLeft);

		setContentView(mGLSurfaceView);
	}

	public CCGLSurfaceView onCreateView() {
		return new CCGLSurfaceView(this);
	}

	// ===========================================================
	// Inner and Anonymous Classes
	// ===========================================================

	// TODO legacy -->

	@Override
	public void onDestroy() {
		super.onDestroy();

		Cocos2dHelper.end();
		CCDirector.sharedDirector().end();
		// CCTextureCache.sharedTextureCache().removeAllTextures();
	}
}
