/*
Copyright (c) 2008, Luke Benstead.
All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice,
      this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright notice,
      this list of conditions and the following disclaimer in the documentation
      and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

package org.cocos2d.kazmath.GL;

import org.cocos2d.kazmath.kmMat4;

public class km_mat4_stack {

	public int capacity; //The total item capacity
	public int item_count; //The number of items
	public kmMat4 top;
	public kmMat4 [] stack;

	public static void km_mat4_stack_initialize(km_mat4_stack stack) {
		stack.stack = new kmMat4[INITIAL_SIZE]; //allocate the memory
		for(int i = 0;i < stack.stack.length;i++) {
			stack.stack[i] = new kmMat4();
		}
		stack.capacity = INITIAL_SIZE; //Set the capacity to 10
		stack.top = null; //Set the top to NULL
		stack.item_count = 0;
	}

	public static void km_mat4_stack_push(km_mat4_stack stack, final kmMat4 item) {
		stack.top = stack.stack[stack.item_count];
		kmMat4.kmMat4Assign(stack.top, item);
		stack.item_count++;

		if(stack.item_count >= stack.capacity) {
			kmMat4 [] temp = null;
			stack.capacity += INCREMENT;
			temp = stack.stack;
			stack.stack = new kmMat4[stack.capacity];
			System.arraycopy(temp, 0, stack.stack, 0, stack.capacity - INCREMENT);
			temp = null;
			stack.top = stack.stack[stack.item_count - 1];
		}
	}

	public static void km_mat4_stack_pop(km_mat4_stack stack, kmMat4 pOut) {
		assert stack.item_count != 0 : "Cannot pop an empty stack";

		stack.item_count--;
		stack.top = stack.stack[stack.item_count - 1];
	}

	public static void km_mat4_stack_release(km_mat4_stack stack) {
		stack.stack = null;
		stack.top = null;
		stack.item_count = 0;
		stack.capacity = 0;
	}

	private static final int INITIAL_SIZE = 30;
	private static final int INCREMENT = 50;
}
