package org.cocos2d.actions.grid;

import org.cocos2d.cocoa.CCGeometry.CCSize;
import org.cocos2d.support.CCPointExtension;
import org.cocos2d.types.CCVertex3D;

////////////////////////////////////////////////////////////

/** CCShaky3D action */
public class CCShaky3D extends CCGrid3DAction {
	int randrange;
	boolean	shakeZ;


	/** creates the action with a range, shake Z vertices, a grid and duration */
	public static CCShaky3D action(int range, boolean sz, CCSize gridSize, float d) {
		return new CCShaky3D(range, sz, gridSize, d);
	}

	/** initializes the action with a range, shake Z vertices, a grid and duration */
	public CCShaky3D(int range, boolean sz, CCSize gSize, float d) {
		super(gSize, d);
		randrange = range;
		shakeZ = sz;
	}

	@Override
	public CCShaky3D copy()	{
		CCShaky3D copy = new CCShaky3D(randrange, shakeZ, gridSize, duration);
		return copy;
	}

	@Override
	public void update(float time) {
		int i, j;
		
		for( i = 0; i < (gridSize.width+1); i++ ) {
			for( j = 0; j < (gridSize.height+1); j++ ) {
				CCVertex3D	v = originalVertex(CCPointExtension.ccp(i,j));
				float r = (float)Math.random() * (randrange*2);
				v.x += r - randrange;
				v.y += r - randrange;
				if( shakeZ )
					v.z += r - randrange;
				
				setVertex(CCPointExtension.ccp(i,j), v);
			}
		}
	}

}

