package org.cocos2d.platform;

import org.cocos2d.include.ccConfig;

public class CCPlatformMacros {

	/** @def CC_ENABLE_CACHE_TEXTURE_DATA
	 * Enable it if you want to cache the texture data.
	 * Basically,it's only enabled in android
	 * 
	 * It's new in cocos2d-x since v0.99.5
	 */
	public static final int CC_ENABLE_CACHE_TEXTURE_DATA = 1;

	/* Application will crash in glDrawElements function on some win32 computers and some android devices.
	 * Indices should be bound again while drawing to avoid this bug.
	 */
	public static final int CC_REBIND_INDICES_BUFFER = 1;

	public static void CCLOG(final String format, Object... objects) {
		if(ccConfig.COCOS2D_DEBUG >= 1) {
			CCCommon.CCLog(format, objects);
		}
	}

	public static void CCLOGINFO(final String format, Object... objects) {
		if(ccConfig.COCOS2D_DEBUG >= 1) {
			CCCommon.CCLog(format, objects);
		}
	}

	public static void CCLOGERROR(final String format, Object... objects) {
		if(ccConfig.COCOS2D_DEBUG > 1) {
			CCCommon.CCLog(format, objects);
		}
	}

	public static void CCLOGWARN(Object... objects) {
		// TODO
	}
}
