package org.cocos2d.actions.tile;

import org.cocos2d.cocoa.CCGeometry.CCPoint;
import org.cocos2d.cocoa.CCGeometry.CCSize;
import org.cocos2d.support.CCPointExtension;
import org.cocos2d.types.ccGridSize;
import org.cocos2d.types.ccQuad3;

////////////////////////////////////////////////////////////

/** CCFadeOutUpTiles action.
 Fades out the tiles in upwards direction
 */
public class CCFadeOutUpTiles extends CCFadeOutTRTiles {
	public static CCFadeOutUpTiles action(CCSize gSize, float d) {
		return new CCFadeOutUpTiles(gSize, d);
	}
	
	protected CCFadeOutUpTiles(CCSize gSize, float d) {
		super(gSize, d);
	}
	
	
	@Override
    public float testFunc(ccGridSize pos, float time) {
        CCPoint	n = CCPointExtension.ccpMult(CCPointExtension.ccp(gridSize.width, gridSize.height), time);
        if ( n.y == 0 )
            return 1.0f;
        return (float)Math.pow( pos.y / n.y, 6 );
    }

	@Override
    public void transformTile(CCPoint pos, float distance) {
        ccQuad3	coords = originalTile(pos);
        CCPoint step = target.getGrid().getStep();

        coords.bl_y += (step.y / 2) * (1.0f - distance);
        coords.br_y += (step.y / 2) * (1.0f - distance);
        coords.tl_y -= (step.y / 2) * (1.0f - distance);
        coords.tr_y -= (step.y / 2) * (1.0f - distance);

        setTile(pos, coords);
    }

}

