package org.cocos2d.touch_dispatcher;

import org.cocos2d.CCDirector;
import org.cocos2d.types.CGPoint;

/**
 * @addtogroup input
 * @{
 */

public class CCTouch {
	public CCTouch() { 
		m_nId = 0;
		m_startPointCaptured = false;
	}

	/** returns the current touch location in OpenGL coordinates */
	public CGPoint getLocation() {
		return CCDirector.sharedDirector().convertToGL(m_point);
	}

	/** returns the previous touch location in OpenGL coordinates */
	public CGPoint getPreviousLocation() {
		return CCDirector.sharedDirector().convertToGL(m_prevPoint);
	}

	/** returns the start touch location in OpenGL coordinates */
	public CGPoint getStartLocation() {
		return CCDirector.sharedDirector().convertToGL(m_startPoint);
	}

	/** returns the delta of 2 current touches locations in screen coordinates */
	public CGPoint getDelta() {
		return CGPoint.ccpSub(getLocation(), getPreviousLocation()); 
	}

	/** returns the current touch location in screen coordinates */
	public CGPoint getLocationInView() {
		return m_point;
	}

	/** returns the previous touch location in screen coordinates */
	public CGPoint getPreviousLocationInView() {
		return m_prevPoint;
	}

	/** returns the start touch location in screen coordinates */
	public CGPoint getStartLocationInView() {
		return m_startPoint;
	}

	public void setTouchInfo(int id, float x, float y) {
		m_nId = id;
		m_prevPoint = m_point;
		m_point.x   = x;
		m_point.y   = y;
		if(! m_startPointCaptured) {
			m_startPoint = m_point;
			m_startPointCaptured = true;
		}
	}

	public int getID() {
		return m_nId;
	}

	private int m_nId;
	private boolean m_startPointCaptured;
	private CGPoint m_startPoint;
	private CGPoint m_point;
	private CGPoint m_prevPoint;
}

// end of input group
/// @}
