package org.cocos2d.layers;

import org.cocos2d.CCDirector;
import org.cocos2d.nodes.CCNode;
import org.cocos2d.types.CGPoint;
import org.cocos2d.types.CGSize;

/**
 * @addtogroup scene
 * @{
 */

/** @brief CCScene is a subclass of CCNode that is used only as an abstract concept.
 * 
 * CCScene an CCNode are almost identical with the difference that CCScene has it's
 * anchor point (by default) at the center of the screen.
 * 
 * For the moment CCScene has no other logic than that, but in future releases it might have
 * additional logic.
 * 
 * It is a good practice to use and CCScene as the parent of all your nodes.
 */
public class CCScene extends CCNode {
	public CCScene() {
		m_bIgnoreAnchorPointForPosition = true;
		setAnchorPoint(CGPoint.ccp(0.5f, 0.5f));

		// TODO legacy -->
		CGSize s = CCDirector.sharedDirector().getWinSizeInPixels();

		setRelativeAnchorPoint(false);

		setAnchorPoint(CGPoint.ccp(0.5f, 0.5f));
		setContentSize(s);	
	}

	public boolean init() {
		boolean bRet = false;
		CCDirector pDirector;
		pDirector = CCDirector.sharedDirector();
		if(pDirector != null) {
			this.setContentSize(pDirector.getWinSize());
			// success
			bRet = true;
		}
		return bRet;
	}

	public static CCScene create() {
		CCScene pRet = new CCScene();
		if(! pRet.init()) {
			pRet = null;
		}
		return pRet;
	}

	// TODO legacy -->

	public static CCScene node() {
		return new CCScene();
	}

}

// end of scene group
/// @}
