﻿using System;



namespace AdminToolkit
{
	/// <summary>
	/// POCO for config settings
	/// </summary>
	internal class AdminModConfig
	{	
		/// <summary>
		/// The Role to constrain players with until rule acceptance
		/// </summary>
		public string PlayerRoleRestrain { get; set; }

		/// <summary>
		/// The Role to transition players after rule acceptance
		/// </summary>
		public string PlayerRoleNormal { get; set; }

		/// <summary>
		/// Sets rule role changer swapping behavior on/off.
		/// </summary>
		/// <value>If rule role changer should be enabled.</value>
		public bool RuleRoleChangerEnabled { get; set; }

		/// <summary>
		/// Time to wait between backup windows
		/// </summary>
		/// <value>The backup delay.</value>
		public TimeSpan BackupDelay { get; set;}

		/// <summary>
		/// Number of full backup files to keep (older get deleted first)
		/// </summary>
		/// <value>The backup count.</value>
		public uint BackupCount { get; set;}

		/// <summary>
		/// If auto-enable delayed backup cycle on server start
		/// </summary>
		/// <value>The autobackup.</value>
		public bool Autobackup { get; set; }

		/// <summary>
		/// Admins get special underlined text chats. Distinctive!
		/// </summary>
		/// <value>The booming voice.</value>
		public bool BoomingVoice { get; set; }

		/// <summary>
		/// Semi-Randomize spawn point from a set list
		/// </summary>
		public bool VariableSpawnpoints { get; set; }

		public AdminModConfig( )
		{
			this.PlayerRoleRestrain = "suvisitor";
			this.PlayerRoleNormal = "suplayer";
			this.RuleRoleChangerEnabled = false;
			this.BoomingVoice = false;

			this.BackupDelay = new TimeSpan(4, 0, 0);
			this.BackupCount = 6;
			this.Autobackup = false;
		}


	}
}

