package errorReachableAnalyzer;

import java.util.*;

public class TransitionParser {
	int trNum=0;	//debug
	ModelInterface model;
	ModelInterface controller;
	boolean isController=false;
	List<String> transitionRecordsOfModel;
	List<String> transitionRecordsOfController;
	List<String> additionalTransitionSequences;
	List<String> controllableActions;
	String transitionSequence="";
	String crlf=System.getProperty("line.separator");
	List<String> eliminatedLabel;
	TransitionParser(Model model){
		this.model=model;
		this.transitionRecordsOfModel=new ArrayList<String>();
	}
	public TransitionParser(ModelInterface model,ModelInterface controller){
		this.model=model;
		this.controller=controller;
	}

	
	private void doAllTransition(State current,String record,List<State> history){
		if(current.toString().equals("ERROR")){
			System.out.println(++trNum);//debug
			record+="ERROR";
			if(isController){
				this.transitionRecordsOfController.add(record);
			}else{
				this.transitionRecordsOfModel.add(record);
			}
			return;
		}else if(history.contains(current)){
			System.out.println(++trNum);//debug
			record+="LOOP";
//			System.out.println(record);//debug
			if(isController){
//				this.transitionRecordsOfController.add(record);
			}else{
//				this.transitionRecordsOfModel.add(record);
			}
			return;
		}
		history.add(current);
		int transitionVariation=current.getToTransitionNum();
		for(int i=0;i<transitionVariation;i++){
			Transition t=current.getToTransition(i);
			this.doAllTransition(t.getTo(),record+t.toString()+crlf,new ArrayList<State>(history));
		}
	}
	void setEliminatedLabel(List<String> eliminatedLabel){
		this.eliminatedLabel=eliminatedLabel;
	}
	boolean checkModelSimulateController(List<String> eLabel){
		setEliminatedLabel(eLabel);
		return this.checkSimulate(this.transitionRecordsOfController, this.model);
	}
	boolean checkErrorSequensesSimulateController(List<String> s){
		List<String> ss=new ArrayList<String>();
		for(int i=0;i<s.size();i++){
			String[] seq=s.get(i).split(crlf);
//			String[] b=this.additionalTransitionSequences.split(crlf);
			String b=this.additionalTransitionSequences.get(this.additionalTransitionSequences.size()-1);
			int c=seq.length-1;
			String a=seq[c];
			
			while(!a.equals(b)){
				System.out.println(a);//debug
				a=seq[--c];
			}
			
			String sWithoutError="";
			for(int j=0;j<c;j++){
				sWithoutError+=seq[j]+crlf;
			}
			System.out.println(sWithoutError);//debug
			ss.add(sWithoutError);
		}
		setEliminatedLabel(new ArrayList<String>());
		return this.checkSimulate(ss, controller);
	}
	boolean checkSimulate(List<String> transitionSequenses,ModelInterface model){
		boolean isSimulateWithNoError=true;
		State current=model.getInitState();
		for(int i=0;i<transitionSequenses.size();i++){//SJڗΏۂɃ[v
			String[] tr= transitionSequenses.get(i).split(crlf);
			for(int j=0;j<tr.length;j++){
				if(!(tr[j].equals("ERROR"))&&!(tr[j].equals("LOOP"))){//Jڗ̑SJڂԂɃ`FbN
					if(current.containsToTransition(tr[j])){
						System.out.println("Choise of actions (controller's one is:"+tr[j]+")");
						for(int k=0;k<current.getToTransitionNum();k++){//JڂɂĒH蒅ԂERRORɍs\`FbN
							System.out.println(i+":"+current.toString()+":"+current.getToTransition(k).toString()+":"+current.getToTransition(k).getTo().toString());
							if(current.getToTransition(k).getTo().toString().equals("ERROR")){
								System.out.println("==============Caution!! This is ERROR state==============");
								isSimulateWithNoError=false;
							}
						}
						current=current.getToStateByTransition(tr[j]);
						
					}else if(eliminatedLabel.contains(tr[j].toString())){
					}else{
						System.out.println("in"+current.toString()+",There are no transition by:"+ tr[j].toString());
						return false;
					}
				}
			}
		}
		return isSimulateWithNoError;
	}
	void startAllTransitionOfModel(){
		this.transitionRecordsOfModel=new ArrayList<String>();
		this.isController=false;
		doAllTransition(model.getInitState(),"",new ArrayList<State>());
	}
	void startAllTransitionOfController(){
		this.transitionRecordsOfController=new ArrayList<String>();
		this.isController=true;
		doAllTransition(controller.getInitState(),"",new ArrayList<State>());
	}
	
	List<String> getTransitionRecords(){
		this.startAllTransitionOfModel();
		return this.transitionRecordsOfModel;
	}

	String toAdditionalTransitionSequences(){
		String a="";
		for(int i=0;i<this.additionalTransitionSequences.size();i++){
			a+=this.additionalTransitionSequences.get(i)+this.crlf;
		}
		return a.trim();
	}//*/
	void setAdditionaltransitionSequences(List<String> ts){
		this.additionalTransitionSequences=ts;
	}
	boolean checkContainingSequences(String target){
		return target.contains(this.toAdditionalTransitionSequences());
	}//*/
	String getTransitionSeqence(){
		return transitionSequence;
	}
	void setModel(Model model){
		this.model=model;
	}
	void setControllableActions(List<String> c){
		this.controllableActions=c;
	}
	
	void pasteController(List<String> l){
		System.out.println("pasteController");
		this.setEliminatedLabel(l);
		pasteCToState(controller.getInitState(),model.getInitState());
	}
	void pasteController(){
		this.setEliminatedLabel(new ArrayList<String>());
//		pasteCToState(controller.getInitState(),model.getInitState());
		pasteCToStateWithHash(controller.getInitState(),model.getInitState());
	}
	void pasteCToState(State c,State m){
		if(c.isController()||m.toString().equals("ERROR")){return;}
		c.setIsController();
		m.setIsController();
		for(int i=0;i<c.getToTransitionNum();i++){
			if(eliminatedLabel.contains(c.getToTransition(i).toString())){
				pasteCToState(c.getToTransition(i).getTo(),m);
			}else{
				if(!c.getToTransition(i).isController()){
					c.getToTransition(i).setIsController();
					m.getToTransition(c.getToTransition(i).toString()).setIsController();
					if(!c.getToTransition(i).toString().equals(m.getToTransition(c.getToTransition(i).toString()).toString()))System.out.println("ERROR");
					pasteCToState(c.getToTransition(i).getTo(),m.getToTransition(c.getToTransition(i).toString()).getTo());
				}
//				pasteCToTransition(c.getToTransition(i),m.getToTransition(c.getToTransition(i).toString()));
			}
		}
	}
	void pasteCToStateWithHash(State c,State m){
		HashMap<State,ContSet> map =new HashMap<State,ContSet>();
		ContSet cu=new ContSet(c,m),next;
		cu.getController().setIsController();
		cu.getModel().setIsController();
		int i=0;
		while(cu.getController().hasNext()){
			Transition t =(Transition)cu.getController().next();
			if(cu.getModel().getToTransition(t.toString())==null){
				System.out.println("Caution!:"+t+" in "+cu.getModel());
				for(int j=0;j<cu.getModel().getToTransitionNum();j++){
					System.out.println("  "+cu.getModel().getToTransition(j));
				}
				break;
			}else{
				i++;
				System.out.println(i+":"+cu.getModel()+"->"+t+"(Model is :"+cu.getModel()+"and transition is...");
				for(int j=0;j<cu.getModel().getToTransitionNum();j++)System.out.println("  "+cu.getModel().getToTransition(j)+"->"+cu.getModel().getToTransition(j).getTo());
				System.out.println("transition of this Time :"+t.toString()+"->"+cu.getModel().getToStateByTransition(t.toString()));
				if(cu.getController().hasNext()&&!map.containsValue(cu)){
					System.out.println("push "+cu.getController());
					map.put(cu.getController(),cu);
				}
				next=new ContSet(t.getTo(),cu.getModel().getToStateByTransition(t.toString()));
				next.getController().setIsController();
				next.getModel().setIsController();
				if(!next.getController().hasNext()&&!map.isEmpty()){
					next=map.remove(map.keySet().toArray()[0]);
					System.out.println("pop "+next.getController());
				}else if(map.containsKey(next.getController())){
					System.out.println("Removing");
					map.remove(next.getController());
				}
				cu=next;
				System.out.println("Next C is:"+cu.getController()+",hasNext:"+cu.getController().hasNext()+" and M is"+cu.getModel());
			}				
		}
		
	}
	class ContSet{
		State controller,model;
		ContSet(State c,State m){
			this.controller=c;
			this.model=m;
		}
		State getController(){
			return this.controller;
		}
		State getModel(){
			return this.model;
		}
	}
	
	void pasteCToTransition(Transition c,Transition m){
		if(c.isController()){return;}
		c.setIsController();
		m.setIsController();		
		if(!c.toString().equals(m.toString()))System.out.println("ERROR");
		pasteCToState(c.getTo(),m.getTo());
	}
	void eraseConttoller(){
		Model m=(Model)this.controller;
		for(int i=0;i<m.getSize();i++){
			State s=m.getState(i);
			s.eraseIsController();
			for(int j=0;j<s.getFromTransitionNum();j++){
				s.getFromTransition(j).eraseIsController();
			}
			for(int j=0;j<s.getToTransitionNum();j++){
				s.getToTransition(j).eraseIsController();
			}
		}
	
	}
	void eraseDead(){
		State er=model.getErrorState();
		er.eraseIsDead();
		for(int i=0;i<er.getFromTransitionNum();i++){
			eraseDFromTransition(er.getFromTransition(i));
		}
	}
	private void eraseDFromTransition(Transition t){
		if(!t.isDead())return;
		t.eraseIsDead();
		this.eraseDFromState(t.getFrom());
	}
	private void eraseDFromState(State s){
		if(!s.isDead())return;
		s.eraseIsDead();
		for(int i=0;i<s.getFromTransitionNum();i++){
			if(s.getFromTransition(i).isDead())eraseDFromTransition(s.getFromTransition(i));
		}
	}
	void pasteDead(){
		State er=model.getErrorState();
		er.setIsDead();
		for(int i=0;i<er.getFromTransitionNum();i++){
			
//			System.out.println("here is "+i+" times");
			pasteDToTransition(er.getFromTransition(i));
		}
		System.out.println("pasteDeadEnd");//debug
	}
	void pasteDeadFromMultiConcurrentSystem(){
		int errorSize=((MultiConcurrentModel)model).getErrorSize();
		for(int j=0;j<errorSize;j++){
			State er=((MultiConcurrentModel)model).getErrorState(j);
			System.out.println("ERROR:"+er);
			er.setIsDead();
			for(int i=0;i<er.getFromTransitionNum();i++){
//				System.out.println("here is "+i+" times");
				pasteDToTransition(er.getFromTransition(i));
			}
			System.out.println("pasteDeadEnd");			
		}
	}
	
	void pasteUpdatedDead(){
		List<Transition> l=model.getUpdatedPart();
		for(int i=0;i<l.size();i++){
			if(l.get(i).getTo().isDead()){
				pasteDToTransition(l.get(i));
			}
		}
	}
	void pasteDToTransition(Transition m){
		if(m.isDead())return;
//		System.out.println("This is dead state:["+m+"]");//debug
		m.setIsDead();
		this.pasteDToState(m.getFrom());
	}
	void pasteDToState(State m){
		if(m.isDead())return;
		
		boolean dead=true;
		for(int i=0;i<m.getToTransitionNum();i++){
			Transition t=m.getToTransition(i);
			if(!t.isControllable()&&t.isDead()){
				m.setIsDead();
//				System.out.println("Dead state:["+m+"]");//debug
				for(int j=0;j<m.getFromTransitionNum();j++){
					pasteDToTransition(m.getFromTransition(j));
				}
				return;
			}else if(!t.isDead()){
				dead=false;
			}
		}

		if(dead)m.setIsDead();
		if(m.isDead()){
			for(int i=0;i<m.getFromTransitionNum();i++){
				pasteDToTransition(m.getFromTransition(i));
			}
		}
	}
	void checkCanSimulate(ModelInterface rs){
		boolean isDead=false;
		
		for(int i=0;i<rs.getSize();i++){
			State s=rs.getState(i);
			if(s.isController()&&s.isDead()){
				isDead=true;
				System.out.println("controller cannot be generated:"+s);
				return;
			}
		}if(!isDead){
			System.out.println("controller can be generated");	
		}
	}
	public void checkSimulate(){
		pasteDeadFromMultiConcurrentSystem();
		pasteController();
		checkCanSimulate(this.model);
	}
	public void checkUpdatedSimulate(ConcurrentModel rs){
		pasteUpdatedDead();
		checkCanSimulate(rs);
	}
	public void checkSimulateOld(ConcurrentModel rs){
		eraseDead();
		eraseConttoller();
		pasteDead();
		pasteController();
		checkCanSimulate(rs);
	}


}