/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package android.i18n;

import javax.swing.JTable;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

/**
 *
 * @author nobuo
 */
public class SaxHandler extends DefaultHandler {
    JTable table;
    Integer IROW;
    
    public SaxHandler(JTable table){
        this.table = table;
        IROW = 0;
    }
    
    @Override
    public void startDocument() {
        System.out.println("startDocument");
    }

    @Override
    public void endDocument() {
        System.out.println("endDocument");
    }

    @Override
    public void startElement(String namespaceURI,
            String localName,
            String qName,
            Attributes atts) {
        System.out.println("startElement: " + qName);
        int length = atts.getLength();
        for (int i = 0; i < length; i++) {
            System.out.println(atts.getQName(i) + " = " + atts.getValue(i));
            if(!"".equals(atts.getValue(i))){
                ++IROW;
                table.setValueAt(atts.getValue(i), IROW, 1);
            }
        }
    }

    @Override
    public void endElement(String namespaceURI,
            String localName,
            String qName) {
        System.out.println("endElement: " + qName);
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        System.out.print("characters: ");
        String str = "";
        for (int i = 0; i < length; i++) {
            System.out.print(ch[start + i]);
        }
        str = String.valueOf(ch);

        if(str != ""){
            table.setValueAt(str, IROW, 2);
        }
        System.out.println();
    }
}
