/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package android.i18n;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JTable;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;

/**
 *
 * @author nobuo
 */
public class FileActionListener {

    private final JTable jTable;

    /**
     * ファイルアクション
     *
     * @param jTable
     */
    public FileActionListener(JTable jTable) {
        this.jTable = jTable;
    }

    // 新規ファイル
    public class FileNew implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent e) {
            Android_i18n ai = new Android_i18n();
            ai.getFrame().setVisible(true);
        }

    }

    // ファイルを開く
    public class FileOpen implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent e) {
            String prjPath = "xmldata";    // xmldata
            JFileChooser filechooser = new JFileChooser(prjPath);
            filechooser.setDialogTitle("ファイルを開く");
            filechooser.setAcceptAllFileFilterUsed(false);
            FileFilter filter = new FileNameExtensionFilter("XMLファイル", "xml");
            filechooser.addChoosableFileFilter(filter);

            int selected = filechooser.showOpenDialog(null);
            if (selected == JFileChooser.APPROVE_OPTION) {
                File file = filechooser.getSelectedFile();

                AccessFile afile = new AccessFile(jTable);
                afile.read(file);
                //XMLdom4j xml4 = new XMLdom4j(jTable);
                //xml4.read(file);
            }

        }

    }

    // ファイルの保存
    public class FileSave implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent e) {
            AccessFile afile = new AccessFile(jTable);
            afile.write();
        }

    }

    // ファイルの名前を変えて保存
    public class FileSaveAs implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent e) {
            //AccessXML wxml = new AccessXML(jTable);
            //wxml.write();
        }

    }
    
   // ファイルのプロパティ
    public class FileProperty implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent e) {
            //AccessXML wxml = new AccessXML(jTable);
            //wxml.write();
        }

    }
    // 終了
    public class FileQuit implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent e) {
            // Quit が押下されたので、保存確認後終了する。

            System.exit(0);
        }
    }

}
