window.addEventListener('load', event => {
  // 各種イベントハンドラを登録
  // 「更新」ボタンをクリック→updateStatus()を実行
  document.getElementById("update_status_button")
    .addEventListener("click", updateStatus);

  // 「インストール」ボタンをクリック→registerServiceWorker()を実行
  document.getElementById("install_svcworker_button")
    .addEventListener("click", registerServiceWorker);

  // 「インストール」ボタンをクリック→unregisterServiceWorker()を実行
  document.getElementById("uninstall_svcworker_button")
    .addEventListener("click", unregisterServiceWorker);

  // ページロード時にService Workerの登録状況をチェックする
  checkServiceWorkerRegistered();

  // ページ内のテキストを更新する
  updateStatus();
});

function checkServiceWorkerRegistered() {
  // Servie Workerが登録されているかチェックする

  if (!"serviceWorker" in navigator) {
    // Service Workerが利用できない環境では
    // Service Workerに関する表示を行わない
    return;
  }
  
  navigator.serviceWorker.getRegistration()
    .then(registration => {
      // registrationが存在すれば登録済み、
      // undefinedなら未登録
      // 結果に応じてinstall-svcwもしくはuninstall-svcwを
      // 表示する
      const elInst = document.getElementById("install-svcw");
      const elUninst = document.getElementById("uninstall-svcw");
      if (registration) {
        elUninst.removeAttribute("style");
        elInst.setAttribute("style", "display:none;");
      } else {
        elInst.removeAttribute("style");
        elUninst.setAttribute("style", "display:none;");
      }
    });
}

function updateStatus() {
  // data.jsonをGETし、その結果から
  // ページ内のステータス表示を更新する
  updateStatusText("...");

  fetch("./data.json")
    .then(response => {
      return response.json();
    })
    .then(result => {
      if (result.data === undefined) {
        updateStatusText("no data");
        return;
      }
      updateStatusText(result.data);
    })
    .catch(err => {
      console.log(err);
      updateStatusText(err);
    });
}

function updateStatusText(message) {
  // ページ内のテキストを更新する
  // 「broser_status」というIDが付けられた要素を取得
  const elem = document.getElementById("browser_status");
  if (elem === null) {
    // 要素が存在しなければエラーログを出力
    console.log("no #browser_status element");
    return;
  }

  // 要素内のテキストを書き換える
  elem.innerText = message;
}

function registerServiceWorker() {
  // Service Workerを登録する
  if ("serviceWorker" in navigator) {
    navigator.serviceWorker.register("./svc_worker.js")
      .then(registration => {
        // 成功ログを出力する
        console.log("Service Worker registration succeed."
                    + `scope: ${registration.scope}`);
        checkServiceWorkerRegistered();
      })
      .catch(err => {
        // 失敗ログを出力する
        console.log(`Service Worker registration failed: ${err}`);
        checkServiceWorkerRegistered();
      });
  }
}

function unregisterServiceWorker() {
  // Service Workerの登録を解除する
  if ("serviceWorker" in navigator) {
    // Service Workerの登録情報を取得するために
    // まずServiceWorkerRegistrationオブジェクトを取得する
    navigator.serviceWorker.getRegistration()
      .then(registration => {
        // ServiceWorkerRegistrationオブジェクトを取得できた場合、
        // unregister()で登録解除を行う
        if (registration) {
          registration.unregister()
            .then(result => {
              if (result) {
                console.log("Service Worker unregister succeed.");
              }
              checkServiceWorkerRegistered();
            });
        }
      })
      .catch(err => {
        // 失敗ログを出力する
        console.log("Service Worker unregister failed.");
      });
  }
}

