// prepare-benchmark.js

/*
10KB * 100 = 1MB
100KB * 100 = 10MB
1MB * 100 = 100MB
10MB * 100 = 1000MB
*/

var fs = require('fs');
var path = require('path');

var DESTINATION = './data';
var RANDOM_DEV = '/dev/urandom'

function createTestFiles(size, dirName, count) {
  var i;
  var fhRandom;
  var fhOut;
  var buf = new Buffer(size);
  var outputFile;

  fhRandom = fs.openSync(RANDOM_DEV, 'r');

  for(i = 0; i < count; i++) {
    outputFile = path.join(dirName, i + '.dat');
    console.log('create: ' + outputFile);
    fs.readSync(fhRandom, buf, 0, size, null);
    fhOut = fs.openSync(outputFile, 'w');
    fs.writeSync(fhOut, buf, 0, size, null);
    fs.closeSync(fhOut);
  }

  fs.closeSync(fhRandom);
};


fs.mkdir(path.join(DESTINATION, 'A'));
fs.mkdir(path.join(DESTINATION, 'B'));
fs.mkdir(path.join(DESTINATION, 'C'));
fs.mkdir(path.join(DESTINATION, 'D'));

createTestFiles(10 * 1024, DESTINATION + '/A', 100);
createTestFiles(100 * 1024, DESTINATION + '/B', 100);
createTestFiles(1024 * 1024, DESTINATION + '/C', 100);
createTestFiles(10 * 1024 * 1024, DESTINATION + '/D', 100);

