#ifndef ENEMYDUNA_H_
#define ENEMYDUNA_H_
#include "jp/ggaf/lib/actor/DefaultMorphMeshActor.h"

#include "jp/ggaf/dxcore/util/GgafDxGeoElem.h"

namespace VioletVreath {

/**
 * G@hD[i(쐬I) .
 * [NX^̃R[hAĈ悤ȓɒbIIB
 * @version 1.00
 * @since 2013/08/22
 * @author Masatoshi Tsuge
 */
class EnemyDuna : public GgafLib::DefaultMorphMeshActor {

public:
    enum {
        MPH_OPEN = 1,
    };

    enum {
        SE_EXPLOSION ,
    };

    enum {
        PROG_INIT   ,
        PROG_ENTRY_EFFECT,
        PROG_ENTRY_MOVE01,
        PROG_ENTRY_MOVE02,
        PROG_MOVE_ORDER_LARGE_SEMIARC_CW,
        PROG_MOVE_ORDER_LARGE_SEMIARC_CCW,
        PROG_MOVE_REV_LARGE_SEMIARC_CW,
        PROG_MOVE_REV_LARGE_SEMIARC_CCW,
        PROG_MOVE_ORDER_SMALL_SEMIARC_CW,
        PROG_MOVE_ORDER_SMALL_SEMIARC_CCW,
        PROG_MOVE_REV_SMALL_SEMIARC_CW,
        PROG_MOVE_REV_SMALL_SEMIARC_CCW,
        PROG_CLOSE ,
        PROG_BANPEI,
    };

    /** tB[hCEtF[hAEgx */
    GgafDxCore::GgafDxAlphaFader* pAFader_;
    /** sړx */
    GgafDxCore::GgafDxAxesMover* pAxsMver_;

    GgafDxCore::GgafDxGeoElem next_pos_;
    int num_fire_;
    int nprog_;
public:
    /**
     * RXgN^
     * @param prm_name
     * @return
     */
    EnemyDuna(const char* prm_name);

    void onCreateModel() override;

    /**
     * hD[ȉiCX^Xۏ؁j
     */
    void initialize() override;

    /**
     * hD[îANeBuɂȂuԂ̏ .
     */
    void onActive() override;

    /**
     * hD[i̐U镑 .
     */
    void processBehavior() override;

    /**
     * hD[i̐U镑̔菈 .
     */
    void processJudgement() override;

    /**
     * hD[ȉՓˎ .
     * @param prm_pOtherActor ՓˑΏ
     */
    void onHit(GgafCore::GgafActor* prm_pOtherActor) override;

    void onInactive() override;

    static void onDispatchedShot(GgafDxCore::GgafDxDrawableActor* prm_pActor, int prm_dispatch_num, int prm_set_index, int prm_way_index);

    virtual ~EnemyDuna();
};

}
#endif /*ENEMYDUNA_H_*/

