#ifndef GGAFLIB_WALLEDSECTIONSCENE_H_
#define GGAFLIB_WALLEDSECTIONSCENE_H_
#include "jp/ggaf/lib/scene/DefaultScene.h"

#define FULL_VAL (-2)
#define KARA_VAL (-2)

namespace GgafLib {

/**
 * ǃubNZNVV[ .
 * WalledScene \V[̂PłA
 * WalledSectionScene AĈ WalledScene \܂B<BR>
 * WalledSectionScene ͕ǃubNt@CǏǂݍ݁A
 * ^C~OiXN[Xs[hjvȂAŕǂo܂B<BR>
 * @version 1.00
 * @since 2010/10/18
 * @author Masatoshi Tsuge
 */
class WalledSectionScene : public DefaultScene {

    /**
     * ǃubN(WallPartsActor)̔zu\
     */
    struct WallInfo {
        /** vYʒu(> 0̏ꍇ̓vYA0̏ꍇBOX) */
        int _pos_prism;
        /** \YW */
        int _y;
        /** \ZW */
        int _z;
        /** \ʏ */
        int _wall_draw_face;
        /** 蔻̈AAB */
        int _aColliBoxStretch[6];
    };

public:
    /** [r]OǃV[̒iXW̕ǃubNj */
    int _area_len;
    /** [r]OǃV[̍iYW̕ǃubNj */
    int _area_height;
    /** [r]OǃV[̕iZW̕ǃubNj */
    int _area_width;
    /** [r]ǃubN̒iPWallPartsActorIuWFNgXWj*/
    coord _wall_dep;
    /** [r]ǃubN̍iPWallPartsActorIuWFNgYWj*/
    coord _wall_height;
    /** [r]ǃubN̕iPWallPartsActorIuWFNgZWj*/
    coord _wall_width;
    /** [r]OǕ\XWʒu */
    coord _wall_start_x;
    /** [r]JԂ */
    int _loop_num;
    /** [r]JԂJE^ */
    int _cnt_loop;
    /** [r]OǕ\Ԋu */
    frame _frame_of_launch_next;
    /** [r]\ς݊OǃV[̒(ǃubN) */
    int _cnt_area_len;
    /** [r]SǃubN(WallPartsActor)̔zu */
    WallInfo** _papaWallInfo;
    /** [r]SǃubN(WallPartsActor)̔zúAOǂ̕ǃubNBvfubNڂ */
    int* _paWallInfoLen;
    /** [r]ǃubN(WallPartsActor)f|Wg */
    GgafCore::GgafActorDepository* _pDepo_WallAAB;
    GgafCore::GgafActorDepository* _pDepo_WallAAPrism;
    /** [r]OubN̓ߋ@\L̊ƂȂAN^[ */
    GgafDxCore::GgafDxGeometricActor* _pTarget_FrontAlpha;
    /** ZNVV[JԂtO */
    bool _is_loop_end;
    WallPartsActor* _pWallPartsLast;

    WalledScene*  _pWalledScene;

public:
    /**
     * RXgN^ .
     * ǃubNt@Cǂݍ݁AIuWFNgɓWJ܂B
     * @param prm_name V[
     * @param prm_data_filename ǃubNt@C
     * @param prm_pWalledScene e̕ǃV[IuWFNg
     */
    WalledSectionScene(const char* prm_name, const char* prm_data_filename, WalledScene* prm_pWalledScene);

    /**
     * OǃV[ݒ.
     * new Ainitialize() s܂ł config ĉB
     * @param prm_pDepo_WallAAB ǃubNiWallAABActorIuWFNgjo^Ăf|Wg
     * @param prm_pDepo_WallAAPrism ǃvYubNiWallAAPrismActorIuWFNgjo^Ăf|Wg
     * @param prm_wall_start_x OǏoXWʒu
     * @param prm_wall_dep ǃubN̒iPWallPartsActorIuWFNgXWj
     * @param prm_wall_width ǃubN̍iPWallPartsActorIuWFNgYWj
     * @param prm_wall_height ǃubN̍iPWallPartsActorIuWFNgZWj
     */
    virtual void config(
            GgafCore::GgafActorDepository* prm_pDepo_WallAAB,
            GgafCore::GgafActorDepository* prm_pDepo_WallAAPrism,
            coord prm_wall_start_x,
            coord prm_wall_dep, coord prm_wall_width, coord prm_wall_height);

    /**
     *  .
     * f|Wg(_pDepo_Wall)̃`FbNsĂ̂ .
     */
    virtual void initialize() override;

    /**
     * OǕ\ԊuԓvZݒ .
     * I[o[ChꍇȀ̒ WalledSectionScene::onActive() ĂяoĉB
     */
    virtual void onActive() override;

    /**
     * OǂoAړ.
     * I[o[ChꍇȀ̒ WalledSectionScene::processBehavior() ĂяoĉB
     */
    virtual void processBehavior() override;

    WallPartsActor* getLastWallParts();

    /**
     * OubN̓ߋ@\LɂB
     * ɂꍇ nullptr ݒ肷
     * @param prm_pTarget_FrontAlpha O̊ɂȂAN^[
     */
    void enableFrontAlpha(GgafDxCore::GgafDxGeometricActor* prm_pTarget_FrontAlpha) {
        _pTarget_FrontAlpha = prm_pTarget_FrontAlpha;
    }

    /**
     * YZʂɁAubÑZbgoɌĂяoR[obNB .
     * I[o[ChĂ̂B
     * @param prm_loop_count ZNṼ[vJEg(0`)
     * @param prm_wall_count ZNVYZʃubNZbgJEg(0`)
     * @param prm_wall_x oYZʂ̃ubNXW
     */
    virtual void onBlockLaunch(int prm_loop_count, int prm_wall_count, coord prm_wall_x) {};

    virtual ~WalledSectionScene();
};

}
#endif /*GGAFLIB_WALLEDSECTIONSCENE_H_*/
