#ifndef GGAFLIB_WALLPARTSACTOR_H_
#define GGAFLIB_WALLPARTSACTOR_H_
#include "jp/ggaf/dxcore/actor/GgafDxMeshSetActor.h"

#define FACE_A_IDX 5
#define FACE_B_IDX 4
#define FACE_C_IDX 3
#define FACE_D_IDX 2
#define FACE_E_IDX 1
#define FACE_F_IDX 0

#define FACE_A_BIT 32  // 0b100000
#define FACE_B_BIT 16  // 0b010000
#define FACE_C_BIT 8   // 0b001000
#define FACE_D_BIT 4   // 0b000100
#define FACE_E_BIT 2   // 0b000010
#define FACE_F_BIT 1   // 0b000001

namespace GgafLib {

/**
 * OǃV[(WalledSectionScene)̕ǃubNNX .
 * OǃV[(WalledSectionScene)̍\vf̕ǃubN͖{NXpKvB
 * @version 1.00
 * @since 2010/10/18
 * @author Masatoshi Tsuge
 */
class WallPartsActor : public GgafDxCore::GgafDxMeshSetActor {
    friend class GgafDxEffectManager;

public:
    /** [r]ǃubNvYʒu(> 0̏ꍇ̓vYA0̏ꍇBOX) */
    int _pos_prism;
    /** [r]ǃubN\ʏ */
    int _wall_draw_face;
    /** [r]ǃubN̒iXWj*/
    coord _wall_dep;
    /** [r]ǃubN̍iYWj*/
    coord _wall_height;
    /** [r]ǃubN̕iZWj*/
    coord _wall_width;
//    /** [r]ǃubNړXs[h(l͐AAړX̕) */
//    int _scroll_speed;
    GgafLib::CollisionChecker3D* _pColliChecker;
    /** [r]OǃV[ */
    WalledSectionScene* _pWalledSectionScene;

public:
    WallPartsActor(const char* prm_name,
              const char* prm_model_id,
              const char* prm_effect_id,
              const char* prm_technique,
              GgafCore::GgafStatus* prm_pStat=nullptr
              );

    virtual void executeHitChk_MeAnd(GgafActor* prm_pOtherActor) override;

    virtual void onCreateModel() override {
    }
    virtual void initialize() override;

    virtual void onActive() override;

    virtual void processDraw() = 0;

    virtual void processBehavior() override;

    virtual void processJudgement() override;

    virtual void processPreDraw() override;

    virtual bool isOutOfUniverse() override;

    virtual int isOutOfView() override;

    virtual void onCatchEvent(hashval prm_no, void* prm_pSource) override {
    }

    virtual void onHit(GgafCore::GgafActor* prm_pOtherActor) override {
    }

    virtual void drawHitArea() override;

    /**
     * ǃubNݒ肷 .
     * @param prm_pWalledSectionScene WalledSectionSceneIuWFNg
     * @param prm_pos_prism vYʒuԍivY^ubN̏ꍇ̂݁j
     * @param prm_wall_draw_face ǃubN\ʏ
     * @param prm_aColliBoxStretch ǃubN蔻
     */
    virtual void config(WalledSectionScene* prm_pWalledSectionScene,
                        int prm_pos_prism, int prm_wall_draw_face, int* prm_aColliBoxStretch);

    inline CollisionChecker3D* getCollisionChecker() {
        return _pColliChecker;
    }

    virtual ~WallPartsActor();
};

}
#endif /*GGAFLIB_WALLPARTSACTOR_H_*/
