// {vÓA<BR>
// u~i܂؂j[ǂƃRv http://marupeke296.com/index.html <BR>
// TCgRec uOgg Vorbisҁv http://marupeke296.com/OGG_main.html <BR>
// ̃TvvOIWiłB<BR>
// ꕔύXĎgpĂ܂B<BR>
//                                            2009/01/13 Masatoshi Tsuge<BR>

#include "stdafx.h"
#include "jp/ggaf/dxcore/sound/IkdLib/PCMPlayer.h"

#include <process.h>
#include "jp/ggaf/dxcore/exception/GgafDxCriticalException.h"
#include "jp/ggaf/dxcore/sound/IkdLib/PCMDecoder.h"
#include "jp/ggaf/dxcore/GgafDxGod.h"

using namespace IkdLib;


//#ifdef _MSC_VER
//
//#else
//#define nullptr 0
//#endif

namespace {
double playTime_g = 1; // 1 sec.
}

PCMPlayer::PCMPlayer() :
        _pDS8(nullptr), _pDSBuffer(nullptr), _pPCMDecoder(nullptr), _wave_format(), _buffer_desc(), _is_ready(false), _hnd_thread(0), _is_terminate(false), _is_looping(true), _state(STATE_NONE)
{
    clear();
}

PCMPlayer::PCMPlayer(IDirectSound8* prm_pDS8) :
        _pDS8(prm_pDS8), _pDSBuffer(nullptr), _pPCMDecoder(nullptr), _wave_format(), _buffer_desc(), _is_ready(false), _hnd_thread(0), _is_terminate(false), _is_looping(true), _state(STATE_NONE)
{
    clear();
}

PCMPlayer::PCMPlayer(IDirectSound8* prm_pDS8, PCMDecoder* prm_pDecoder) :
        _pDS8(prm_pDS8), _pDSBuffer(nullptr), _pPCMDecoder(nullptr), _wave_format(), _buffer_desc(), _is_ready(false), _hnd_thread(0), _is_terminate(false), _is_looping(true), _state(STATE_NONE)
{
    clear();
    setDecoder(prm_pDecoder);
}

PCMPlayer::~PCMPlayer() {
    //Ȃꍇ̌̂߁A
    //X}[g|C^OdeleteReleaseŉ
    _TRACE_("PCMPlayer::~PCMPlayer() begin");
    _TRACE_("terminateThread();");
    terminateThread();
    _TRACE_("GGAF_RELEASE(_pDSBuffer);");
    GGAF_RELEASE(_pDSBuffer);
    _TRACE_("GGAF_DELETE(_pPCMDecoder);");
    GGAF_DELETE(_pPCMDecoder);
    _TRACE_("PCMPlayer::~PCMPlayer() end");
}

//! NA
void PCMPlayer::clear() {
    terminateThread();
    memset(&_buffer_desc, 0, sizeof(_buffer_desc));
    memset(&_wave_format, 0, sizeof(_wave_format));
    if (_pDSBuffer) {
        GGAF_RELEASE(_pDSBuffer);
        _pDSBuffer = nullptr;
    }
    _is_ready = false;
    _state = STATE_NONE;
}

//! Đ̃Xbh~
void PCMPlayer::terminateThread() {
    if (_hnd_thread != 0) {
        _is_terminate = true;
        bool end = false;
        int wait = 0;
        while (!end) {
            //if (wait > 1) {
            if (wait > 10000) {
                _TRACE_("x PCMPlayer::terminateThread() BXbhI邱ƂBREAK (T_T)");
                break;
            }
            DWORD flag = WaitForSingleObject(_hnd_thread, 4);
            switch (flag) {
                case WAIT_OBJECT_0:
                    // XbhI
                    end = true;
                    _TRACE_("PCMPlayer::terminateThread() WaitForSingleObject=WAIT_OBJECT_0 OK!Done! flag="<<flag<<" wait="<<wait<<"");
                    break;
                case WAIT_TIMEOUT:
                    wait++;
                    _is_terminate = true;
                    // ܂IĂȂ̂őҋ@
                    _TRACE_("PCMPlayer::terminateThread() WaitForSingleObject=WAIT_TIMEOUT... flag="<<flag<<" wait="<<wait<<"");
                    break;
                case WAIT_FAILED:
                    // sĂ悤ł
                    end = true;
                    _TRACE_("PCMPlayer::terminateThread() WaitForSingleObject=WAIT_FAILED... flag="<<flag<<" wait="<<wait<<"");
                    break;
                default:
                    wait++;
                    _TRACE_("PCMPlayer::terminateThread() WaitForSingleObject=?  flag="<<flag<<" wait="<<wait<<"");
                    break;
            }
            if (!end) {
                Sleep(2);
            }
        }
        _is_terminate = false;
        CloseHandle(_hnd_thread);
        _hnd_thread = 0;
    } else {
        _TRACE_("PCMPlayer::terminateThread() ȑOɊɎsς݁BBthis=" << this << "/_is_terminate=" << _is_terminate);
    }
}

//! foCXݒ
void PCMPlayer::setDevice(IDirectSound8* prm_pDS8) {
    _pDS8 = prm_pDS8;
}

//! PCMfR[_ݒ
bool PCMPlayer::setDecoder(PCMDecoder* prm_pPcmDecoder) {
    if (_pDS8 == nullptr || prm_pPcmDecoder == nullptr || prm_pPcmDecoder->isReady() == false) {
        _is_ready = false;
        return false;
    }

    _state = STATE_STOP;

    if (!prm_pPcmDecoder->getWaveFormatEx(_wave_format)) {
        return false;
    }

    _buffer_desc.dwSize = sizeof(DSBUFFERDESC);
    _buffer_desc.dwFlags = DSBCAPS_CTRLPAN | DSBCAPS_CTRLVOLUME | DSBCAPS_CTRLFREQUENCY | DSBCAPS_GLOBALFOCUS | DSBCAPS_CTRLPOSITIONNOTIFY;
    _buffer_desc.dwBufferBytes = _wave_format.nAvgBytesPerSec * playTime_g;
    _buffer_desc.dwReserved = 0;
    _buffer_desc.lpwfxFormat = &_wave_format;
    _buffer_desc.guid3DAlgorithm = GUID_NULL;

    // N[ۑ
    _pPCMDecoder = prm_pPcmDecoder->createClone();

    // ZJ_obt@܂ꍇ͍쐬
    if (_pDSBuffer == nullptr) {
        IDirectSoundBuffer* ptmpBuf = 0;
        if (SUCCEEDED(_pDS8->CreateSoundBuffer(&_buffer_desc, &ptmpBuf, nullptr))) {
            ptmpBuf->QueryInterface(IID_IDirectSoundBuffer8, (void**)&_pDSBuffer);
        } else {
            clear();
            return false;
        }
        ptmpBuf->Release();
    }

    // obt@
    //pDSBuffer->Lock ŋɋHɂB
    //initializeBuffer() ƍĐr΂悳
    bool r = initializeBuffer();
    if (r == false) {
        return false;
    }

    // obt@Rs[Xbh
    if (_hnd_thread == 0) {
        //_hnd_thread = (uintptr_t)_beginthread(PCMPlayer::streamThread, 0, (void*)this);
        _hnd_thread = (HANDLE)_beginthreadex(nullptr, 0, IkdLib::PCMPlayer::streamThread, (void*)this, 0, nullptr);
    }

    _is_ready = true;

    return true;
}

//! obt@
bool PCMPlayer::initializeBuffer() {
    if (_pPCMDecoder == nullptr) {
        return false;
    }
    BEGIN_SYNCHRONIZED2; //ꂪĂ
    _pPCMDecoder->setHead(); // o
    HRESULT hr = _pDSBuffer->SetCurrentPosition(0);
    checkDxException(hr, DS_OK , "PCMPlayer::initializeBuffer()  SetCurrentPosition( 0 ) Ɏs܂B");
    // obt@bNďf[^
    for (int i = 0; i < 10; i++) { //őPO񎎍sĂ݂B̍B
                                   // DSBLOCK_ENTIREBUFFER iS̃bN)
                                   //dg̃^C~OŎs邱Ƃ͔Ȃƍl߁B
                                   //TODO:͂Ăȕ@ł̂낤B


        void* AP1 = 0, *AP2 = 0;
        DWORD AB1 = 0, AB2 = 0;
        hr = _pDSBuffer->Lock(0, 0, &AP1, &AB1, &AP2, &AB2, DSBLOCK_ENTIREBUFFER);
        //checkDxException(hr, DS_OK , "PCMPlayer::initializeBuffer() Lock Ɏs܂B");
        //TODO:bNsĂꍇBdȂ̂ŃG[`FbN̓RgɂB
        //  NꍇA[NĂۂBԔY񂾂uEEB
        //NeBJZNV   BEGIN_SYNCHRONIZED2 `    END_SYNCHRONIZED2 ŋނ悤ɂĂ݂B
        //ǋLFNeBJZNVň͂ނ悤ɏCĂAԈ肵ĂB

        if (SUCCEEDED(hr)) {
            _pPCMDecoder->getSegment((char*)AP1, AB1, 0, 0); // RRłɋHɗÎ́Bi͒Ԉ肵Ăj
            hr = _pDSBuffer->Unlock(AP1, AB1, AP2, AB2);
            checkDxException(hr, DS_OK , "PCMPlayer::initializeBuffer() Unlock Ɏs܂B");
            break;
        } else {
            //bNs
            if (i < 10) {
                _TRACE_("PCMPlayer::initializeBuffer() LockɎs i=" << i << " ");
//                _TRACE_("hr=" << hr << " " << DXGetErrorString(hr) << " " << DXGetErrorDescription(hr));
                _TRACE_("HRESULT="<<hr);
                hr = _pDSBuffer->Unlock(AP1, AB1, AP2, AB2);
                Sleep(5);
                continue; //撣
            } else {
                //߂
                _TRACE_("PCMPlayer::initializeBuffer() Lock߂ĉ܂B񂩂");
                clear();
                END_SYNCHRONIZED2;
                return false;
            }
        }
    }
    END_SYNCHRONIZED2;
    return true;
}

//! Xg[ĐXbh
unsigned __stdcall PCMPlayer::streamThread(void* playerPtr) {
    PCMPlayer* player = (PCMPlayer*)playerPtr;
    unsigned int size = player->_buffer_desc.dwBufferBytes / 2;
    unsigned int flag = 0;
    DWORD point = 0;
    void* AP1 = 0, *AP2 = 0;
    DWORD AB1 = 0, AB2 = 0;

    DWORD finishPos = 0;
    DWORD prePlayPos = 0;

    unsigned int writeSize = 0;
    bool isEnd = false;
    bool waitFinish = false;

    while (player->_is_terminate == false) {
        BEGIN_SYNCHRONIZED2;
        switch (player->getState()) {
            case STATE_PLAY: // Đ
                // Xg[Đ
                // ݈ʒu`FbN
                player->_pDSBuffer->GetCurrentPosition(&point, 0);
                if (flag == 0 && point >= size) {
                    // Oɏ
                    if (SUCCEEDED(player->_pDSBuffer->Lock(0, size, &AP1, &AB1, &AP2, &AB2, 0))) {
                        player->_pPCMDecoder->getSegment((char*)AP1, AB1, &writeSize, &isEnd);
                        player->_pDSBuffer->Unlock(AP1, AB1, AP2, AB2);
                        flag = 1;
                    }

                    // ŏȈ݂ꍇ͏Iʒu
                    if (isEnd && waitFinish == false) {
                        finishPos = writeSize;
                        player->_pDSBuffer->GetCurrentPosition(&prePlayPos, 0);
                        waitFinish = true;
                    }
                } else if (flag == 1 && point < size) {
                    // 㔼ɏ
                    if (SUCCEEDED(player->_pDSBuffer->Lock(size, size * 2, &AP1, &AB1, &AP2, &AB2, 0))) {
                        player->_pPCMDecoder->getSegment((char*)AP1, AB1, &writeSize, &isEnd);
                        player->_pDSBuffer->Unlock(AP1, AB1, AP2, AB2);
                        flag = 0;
                    }

                    // ŏȈ݂ꍇNorifyݒ
                    if (isEnd && waitFinish == false) {
                        finishPos = size + writeSize;
                        player->_pDSBuffer->GetCurrentPosition(&prePlayPos, 0);
                        waitFinish = true;
                    }
                }
                break;

            case STATE_STOP:
                flag = 0; // ~߂ƑO݂n܂邽
                isEnd = false;
                finishPos = 0;
                prePlayPos = 0;
                break;

            case STATE_PAUSE:
                break;

            default:
                break;
        }
        END_SYNCHRONIZED2;

        // Iʒu`FbN
        if (isEnd) {
            DWORD curPlayPos;
            player->_pDSBuffer->GetCurrentPosition(&curPlayPos, 0);
            if (curPlayPos < prePlayPos) {
                // obt@[vu
                //if ( prePlayPos <= finishPos ) {
                if (prePlayPos <= finishPos || finishPos <= curPlayPos) {
                    // I錾
                    player->stop();
                }
            } else {
                if (prePlayPos <= finishPos && finishPos <= curPlayPos) {
                    // I錾
                    player->stop();
                }
            }
            prePlayPos = curPlayPos;
        }

        Sleep(100);
    }

    return 0;
}

//! Đ
bool PCMPlayer::play(bool prm_is_looping) {
    if (isReady() == false) {
        return false;
    }
    _is_looping = prm_is_looping;
    _pPCMDecoder->setLooping(_is_looping);
    _pDSBuffer->Play(0, 0, DSBPLAY_LOOPING);
    _state = STATE_PLAY;
    return true;
}

//! ꎞ~
void PCMPlayer::pause() {
    if (_state == STATE_PLAY) {
        // Ă~߂
        _pDSBuffer->Stop();
        _state = STATE_PAUSE;
    } else if (_state == STATE_PAUSE) {
        //PAUSEpause()Ă
    } else if (_state == STATE_STOP) {
        //~pause()Ă
    }
}
void PCMPlayer::unpause() {
    if (_state == STATE_PLAY) {
        //t unpause() Ă
    } else if (_state == STATE_PAUSE) {
        // PAUSEȂĐ
        _state = STATE_PLAY;
        play(_is_looping);
    } else if (_state == STATE_STOP) {
        //~unpause()Ă
    }
}

//! ~
void PCMPlayer::stop() {
    if (isReady() == false) {
        return;
    }
    _state = STATE_STOP;
    _pDSBuffer->Stop();

    // obt@̓o
    bool r = initializeBuffer();
    _TRACE_("PCMPlayer::stop() initializeBuffer() = " << r);
}

//! ʂς
void PCMPlayer::setVolume(int volume) {
    if (isReady()) {
        _pDSBuffer->SetVolume(volume);
    }
}

//! p̈ʒuς
void PCMPlayer::setPan(int pan) {
    if (isReady()) {
        _pDSBuffer->SetPan(pan);
    }
}

//! łH
bool PCMPlayer::isReady() {
    return _is_ready;
}

//! ĐH
bool PCMPlayer::isPlaying() {
    return (_state == STATE_PLAY);
}

//! Ԃ擾
PCMPlayer::STATE PCMPlayer::getState() {
    return _state;
}
