#ifndef GGAFDXCORE_GGAFDXSE_H_
#define GGAFDXCORE_GGAFDXSE_H_
#include "jp/ggaf/core/GgafObject.h"

#include <sstream>

#ifdef __GNUG__
    #define __null
#endif
#include <dsound.h>  //sal.h  include 
#ifdef __GNUG__
    #undef __null
    #undef __in
    #undef __out
#endif

namespace GgafDxCore {

/**
 * Sound Effect(Wave) NX .
 */
class GgafDxSe : public GgafCore::GgafObject {

    static std::string getWaveFileName(std::string prm_file);

public:
    /** [r]TEhobt@ */
    LPDIRECTSOUNDBUFFER _pIDirectSoundBuffer;

    char* _wave_key;

    /** [r]wavet@C */
    std::string _wave_file_name;
    /** [r]̎g */
    DWORD _default_frequency;
    /** [r]SEŌɔAN^[ */
    GgafDxGeometricActor* _pActor_LastPlayed;

    bool _can_looping;

public:
    /**
     * RXgN^
     * @param prm_wave_name ID (vpeBt@C̃L[)
     * @return
     */
    explicit GgafDxSe(char* prm_wave_key);

    /**
     * obt@Wavef[^] .
     * @param WaveFile
     * @return (true: / false:s)
     */
    int writeBuffer(CWaveDecorder& WaveFile);

    /**
     * SoundBuffer̕A .
     * @return  (true: / false:s)
     */
    int restore(void);

    /**
     * {[ƃpƎg̗w肵SEPĐ .
     * {[ɂāAŃ}X^{[̍l̂ŁA
     * AvP[V́A{̉ʂCɂʏĐꍇ́A
     * {[100Őݒ肷鎖B
     * @param prm_volume {[(0 ` 100)
     * @param prm_pan p(left:-1.0 ` center:0 ` right:1.0)
     * @param prm_frequency ̎gɏ悸闦
     */
    virtual void play(int prm_volume, float prm_pan, float prm_frequency);

    /**
     * {[ƃpw肵SE1Đ
     * {[ɂāAŃ}X^{[̍l̂ŁA
     * AvP[V́A{̉ʂCɂʏĐꍇ́A
     * {[100Őݒ肷鎖B
     * @param prm_volume {[(0 ` 100)
     * @param prm_pan    p(left:-1.0 ` center:0 ` right:1.0)
     */
    virtual void play(int prm_volume, float prm_pan) {
        play(prm_volume, prm_pan, 1.0f);
    }

    /**
     * SE1Đ .
     */
    virtual void play();

    virtual void stop();

    /**
     * SEĐׂ .
     * @return
     */
    bool isPlaying();

    /**
     * {[ύX .
     * play()sASEĐɉʂωȂǂɎgp邱Ƃz .
     * Ń}X^{[̍lB
     * @param prm_volume {[(0 ` 100)
     */
    void setVolume(int prm_volume);

    /**
     * pύX .
     * play()sASEĐɎgp邱Ƃz .
     * @param prm_pan p(left:-1.0 ` center:0 ` right:1.0)
     */
    void setPan(float prm_pan);


    void setLooping(bool prm_can_looping) {
        _can_looping = prm_can_looping;
    }

    /**
     * g̗ύX .
     * play()sASEĐɎgp邱Ƃz .
     * @param prm_frequency ̎gɏ悸闦
     */
    void setFrequencyRate(float prm_frequency);

    virtual ~GgafDxSe();
};

}
#endif /*GGAFDXCORE_GGAFDXSE_H_*/
