#ifndef GGAFDXCORE_GGAFDXBOARDSETMODEL_H_
#define GGAFDXCORE_GGAFDXBOARDSETMODEL_H_
#include "jp/ggaf/dxcore/model/GgafDxModel.h"

namespace GgafDxCore {

/**
 * GgafDxBoardSetActorpfNX.
 * @version 1.00
 * @since 2009/07/21
 * @author Masatoshi Tsuge
 */
class GgafDxBoardSetModel : public GgafDxModel {
    friend class GgafDxModelManager;
    friend class GgafDxBoardSetActor;

public:
    struct INDEXPARAM {
        UINT MaterialNo;
        INT BaseVertexIndex;
        UINT MinIndex;
        UINT NumVertices;
        UINT StartIndex;
        UINT PrimitiveCount;
    };

    /** _\ */
    struct VERTEX {
        float x, y, z;    // _W
        float index;      // psizeł͂ȂĂ͂ȂĒ_ԍ𖄂ߍށBVF[_[ŉZbgڂ𔻒f邽߂ɎgpB
        float tu, tv;     // _̃eNX`W
    };

    /** _obt@̊eZbg */
    LPDIRECT3DVERTEXBUFFER9 _pIDirect3DVertexBuffer9;
    /** CfbNXobt@ */
    LPDIRECT3DINDEXBUFFER9 _pIDirect3DIndexBuffer9;
    /** _FVF */
    static DWORD FVF;
    /** `̒_ṽTCY */
    UINT _size_vertices;
    /** 1_̃TCY */
    UINT _size_vertex_unit;
    INDEXPARAM* _paIndexParam;

    float _fSize_BoardSetModelWidthPx;
    float _fSize_BoardSetModelHeightPx;
    int _row_texture_split;
    int _col_texture_split;

public:
    /**
     * RXgN^<BR>
     * @param prm_model_name XvCg`̎ʖB".x"ǉƒ`Xt@CɂȂB
     */
    GgafDxBoardSetModel(char* prm_model_name);

    virtual HRESULT draw(GgafDxDrawableActor* prm_pActor_Target, int prm_draw_set_num = 1) override;

    virtual void restore() override;

    virtual void onDeviceLost() override;

    void release() override;

    void changeVertexAlpha(int prm_vertex_alpha);

    /**
     * fXgN^<BR>
     */
    virtual ~GgafDxBoardSetModel(); //fXgN^
};

}
#endif /*GGAFDXCORE_GGAFDXBOARDSETMODEL_H_*/
