#ifndef GGAFDXCORE_GGAFDXKUROKOA_H_
#define GGAFDXCORE_GGAFDXKUROKOA_H_
#include "jp/ggaf/core/GgafObject.h"

#include "jp/ggaf/dxcore/util/GgafDxGeoElem.h"
#include "jp/ggaf/dxcore/actor/GgafDxGeometricActor.h"

namespace GgafDxCore {

/**
 *  .
 * ߂͉X̖ڂɂ͐G܂񂪁A(AN^[)グAuړvủ]vs킹鐢blłB<BR>
 * (AN^[)͎̈ӎvœ삹ƂA߂̂ŕщ܂邱Ƃł܂B<BR>
 * {Iȓ͍߂łقƂǃJo[łĂ܂܂B̂ŁA҂͎g̉ZɏWł̂łB<BR>
 * 񉉎Ҏg͂ĈړE]sƁA߂ł͏oȂA蕡GȈړ\ł傤B<BR>
 * ҈lɂA߂WňltĂ܂B<BR>
 * <BR>
 * ͂ĒuA܂͍WvZxiʉjNXłB<BR>
 * GgafDxGeometricActor ̃o<BR>
 *  _x,  _y,  _z  EEE AN^[̍W<BR>
 * _rx, _ry, _rz  EEE AN^[̎]px<BR>
 * ω܂BxNgAxAAԁAɂĊǗ삷邽߂ɍ쐬NXB<BR>
 * ʂ̊{IȈړA]͍߂ɔCāA<BR>
 * AN^[ŗL̓Ȉړ] processBehave() ɒڋLqBƂ݌vvzB<BR>
 * @version 1.00
 * @since 2008/08/20
 * @author Masatoshi Tsuge
 */
class GgafDxKuroko : public GgafCore::GgafObject {

private:
    /** [r]߂̏A(ړx̕⍲) */
    GgafDxKurokoAssistantA* _pHlprA;
    /** [r]߂̏B(]ppx̕⍲) */
    GgafDxKurokoAssistantB* _pHlprB;
    /** [r]߂̏C(ړppx̕⍲) */
    GgafDxKurokoAssistantC* _pHlprC;

public:
    /** [r]ΏۃAN^[ */
    GgafDxGeometricActor* const _pActor;

public:
    /**
     * RXgN^<BR>
     * @param   prm_pActor  KpActor
     */
    explicit GgafDxKuroko(GgafDxGeometricActor* prm_pActor);

    /**
     * ߂̏A(ړx̕⍲)擾 .
     * @return ߂̏A
     */
    GgafDxKurokoAssistantA* asstA();

    /**
     * ߂̏B(]ppx̕⍲)擾 .
     * @return ߂̏B
     */
    GgafDxKurokoAssistantB* asstB();

    /**
     * ߂̏C(ړppx̕⍲)擾 .
     * @return ߂̏C
     */
    GgafDxKurokoAssistantC* asstC();


public: //_rx , _ry, _rz ֘A //////////////////////////////////////////////
    /** [r]ΏۃĽ(_rx, _ry, _rz)ւ̎Q */
    angle* _apActorFaceAng[3];
    /** [r/w]]p̊pxi]pɖt[Zpj */
    angvelo _angveloFace[3];
    /** [r/w]]p̊px(ōl360,000) */
    angvelo _angveloTopFace[3];
    /** [r/w]]p̊px(ōl-360,000) */
    angvelo _angveloBottomFace[3];
    /** [r/w]]p̊pxipxɖt[Zlj */
    angacce _angacceFace[3];
    /** [r/w]]p̊pxipxɖt[Zlj */
    angjerk _angjerkFace[3];
    /** [r/w]ڕW̎]pLtO */
    bool _face_ang_targeting_flg[3];
    /** [r/w]ڕW̎]p~@\LtO */
    bool _face_ang_targeting_stop_flg[3];
    /** [r/w]ڕWƂL̎]p̕p(0`360,000) */
    angle _angTargetFace[3];
    /** [r/w]ڕW̎]p~@\LɂȂ] */
    int _face_ang_target_allow_way[3]; //TURN_CLOCKWISE or TURN_COUNTERCLOCKWISE or TURN_BOTH
    /** [r/w]ڕW̎]p~@\LɂȂpxi]ʁj */
    angvelo _face_ang_target_allow_velo[3]; //̊px菬l̏ꍇ@\LƂz

public:
    void setMvAngByFaceAng() {
        setRzRyMvAng(_pActor->_rz, _pActor->_ry);
    }
    /**
     * Actor̖ڕW̎]p~@\L(ڕW̎]pݒ)<BR>
     * ɐݒ肳ꂽ]pɂȂƁA]ppxyю]ppx 0 ɂA]~܂B<BR>
     * ]ppx 0 ̏ꍇAN܂B{\bhsƌďɌςƂƂӖł͂܂B <BR>
     * ]ppx̐ݒ𕹂ĎsāAʓr]sȂĂB<BR>
     * Iɂ́AaddFaceAng(prm_axis, int) t[sdg݂łB<BR>
     * ڕW̉]pɓBȂ΁A̖ڕW̎]p~@\͉(̃tOAZbg)܂B<BR>
     * @param   prm_axis    ]iAXIS_X / AXIS_Y / AXIS_Z)
     * @param   prm_angTargetRot    BڕW̉]p(0`360,000)
     * @param   prm_way_allow  ~i(TURN_CLOCKWISE/TURN_COUNTERCLOCKWISE/TURN_BOTH)
     * @param   prm_angveloAllow ~@\LɂȂ]px
     */
    void setStopTargetFaceAng(axis prm_axis,
                              angle prm_angTargetRot,
                              int prm_way_allow = TURN_BOTH,
                              angvelo prm_angveloAllow = D180ANG);

    /**
     * Actor̖ڕW]~@\L(XYW̑ΏXYWŐݒ)<BR>
     * @param   prm_axis    ]iAXIS_X / AXIS_Y / AXIS_Z)
     * @param   prm_tx  ΏXW
     * @param   prm_ty  ΏYW
     * @param   prm_way_allow  ~@\LɂȂ]
     * @param   prm_angveloAllowRyMv ~@\LɂȂ]px
     */
    void setStopTargetFaceAngTwd(axis prm_axis,
                                 coord prm_tx,
                                 coord prm_ty,
                                 int prm_way_allow = TURN_BOTH,
                                 angvelo prm_angveloAllowRyMv = D180ANG);
    /**
     * ]p̊pxi]pɖt[Zljݒ .
     * @param prm_axis ]iAXIS_X / AXIS_Y / AXIS_Z)
     * @param prm_angveloRot px
     */
    void setFaceAngVelo(axis prm_axis, angvelo prm_angveloRot);

    /**
     * ]p̊pxi]pɖt[Zljݒ .
     * @param prm_axis_x_angveloRot X]̊px
     * @param prm_axis_y_angveloRot Y]̊px
     * @param prm_axis_z_angveloRot Z]̊px
     */
    void setFaceAngVelo(angvelo prm_axis_x_angveloRot,
                        angvelo prm_axis_y_angveloRot,
                        angvelo prm_axis_z_angveloRot);

    void forceFaceAngVeloRange(axis prm_axis,
                               angvelo prm_angveloRot01,
                               angvelo prm_angveloRot02);

    void setFaceAngAcce(axis prm_axis, angacce prm_angacceRot);
    angle getFaceAngDistance(axis prm_axis, coord prm_tx, coord prm_ty, int prm_way);

    angle getFaceAngDistance(axis prm_axis, angle prm_angTargetRot, int prm_way);

    ////////////////////////////////////////////////////MOVER

public: //_x, _y, _z ֘A //////////////////////////////////////////////
    /** [r]L̈ړpPʃxNg */
    float _vX, _vY, _vZ;
    /** [r/w]ړpZ]p */
    angle _angRzMv;
    /** [r/w]ړpY]p */
    angle _angRyMv;
    /** [r/w]ړx */
    velo _veloMv;
    /** [r/w]ړx */
    velo _veloTopMv;
    /** [r/w]ړx */
    velo _veloBottomMv;
    /** [r/w]ړx */
    acce _accMv;

    /** [r/w]ړpiZ]j̊pxiړpiZ]jɖt[Zpj */
    angvelo _angveloRzMv;
    /** [r/w]ړpiZ]j̊px(ōl360,000) */
    angvelo _angveloRzTopMv;
    /** [r/w]ړpiZ]j̊px(ōl-360,000) */
    angvelo _angveloRzBottomMv;
    /** [r/w]ړpiZ]j̊pxipxɖt[Zlj */
    angacce _angacceRzMv;
    /** [r/w]ړpiZ]j̊pxipxɖt[Zlj */
    angjerk _angjerkRzMv;
    /** [r/w]ڕẄړpiZ]jLtO */
    bool _mv_ang_rz_target_flg;
    /** [r/w]ڕẄړpiZ]j~@\LtO */
    bool _mv_ang_rz_target_stop_flg;
    /** ڕWƂL̈ړpiZ]j̕p(0`360,000) */
    angle _angTargetRzMv;
    /** [r/w]ڕẄړpiZ]j~@\LɂȂi] */
    int _mv_ang_rz_target_allow_way; //TURN_CLOCKWISE or TURN_COUNTERCLOCKWISE or TURN_BOTH
    /** [r/w]ڕẄړpiZ]j~@\LɂȂړppx */
    angvelo _mv_ang_rz_target_allow_velo;
    /** [r/w]O@\LtO */
    bool _relate_RzFaceAng_with_RzMvAng_flg;
    //true  : ړpiZ]jύXƁAɔp]p(Z)ɂݒ肳
    //false : ړpiZ]jZ]p͓Ɨ

    /** [r/w]ړpiY]j̊pxiړpiY]jɖt[Zpj */
    angvelo _angveloRyMv;
    /** [r/w]ړpiY]j̊px(ōl360,000) */
    angvelo _angveloRyTopMv;
    /** [r/w]ړpiY]j̊px(ōl-360,000) */
    angvelo _angveloRyBottomMv;
    /** [r/w]ړpiY]j̊pxipxɖt[Zlj */
    angacce _angacceRyMv;
    /** [r/w]ړpiY]j̊pxipxɖt[Zlj */
    angjerk _angjerkRyMv;
    /** [r/w]ڕẄړpiY]jLtO */
    bool _mv_ang_ry_target_flg;
    /** [r/w]ڕẄړpiY]j~@\LtO */
    bool _mv_ang_ry_target_stop_flg;
    /** [r/w]ڕWƂL̈ړpiY]j̕p(0`360,000) */
    angle _angTargetRyMv;
    /** [r/w]ڕẄړpiY]j~@\LɂȂi] */
    int _mv_ang_ry_target_allow_way; //TURN_CLOCKWISE or TURN_COUNTERCLOCKWISE or TURN_BOTH
    /** [r/w]ڕẄړpiY]j~@\LɂȂړppx */
    angvelo _mv_ang_ry_target_allow_velo;
    /** [r/w]O@\LtO */
    bool _relate_RyFaceAng_with_RyMvAng_flg;
    //true  : ړpiY]jύXƁAɔp]p(Y)ɂݒ肳
    //false : ړpiY]jY]p͓Ɨ

    bool _taget_face_ang_alltime_flg;
    GgafDxGeometricActor* _taget_face_ang_alltime_pActor;
    coord _taget_face_ang_alltime_tx;
    coord _taget_face_ang_alltime_ty;
    coord _taget_face_ang_alltime_tz;
    angvelo  _taget_face_ang_alltime_angVelo;
    angacce _taget_face_ang_alltime_angAcce;
    int _taget_face_ang_alltime_way;
    bool _taget_face_ang_alltime_optimize_ang;

public:
    /**
     * ړxݒ .
     * @param   prm_veloMv  ړx
     */
    void setMvVelo(velo prm_veloMv);

    /**
     * ړxZ .
     * @param prm_veloMv_Offset Zړx
     */
    void addMvVelo(velo prm_veloMv_Offset);

    /**
     * ړx̏ݒ肵Aړx͈̔͂𐧌 .
     * ̈ړxPAړxQ̑召͂ǂł܂ȂBiŔ肷j
     * @param prm_veloMv01  ړxP
     * @param prm_veloMv02  ړxQ
     */
    void forceMvVeloRange(velo prm_veloMv01, velo prm_veloMv02);

    /**
     * ړx̏ݒ肵Aړx͈̔͂𐧌 .
     * ĺA-prm_veloMv ` prm_veloMv ͈̔͂ɂȂB
     * @param prm_veloMv ړx
     */
    void forceMvVeloRange(velo prm_veloMv);

    /**
     * ݂̈ړx擾 .
     * @return ݂̈ړx
     */
    inline velo getMvVelo() {
        return _veloMv;
    }

    /**
     * ړx擾 .
     * @return ړx
     */
    inline velo getMvVeloTop() {
        return _veloTopMv;
    }

    /**
     * ړx擾 .
     * @return ړx
     */
    inline velo getMvVeloBottom() {
        return _veloBottomMv;
    }

    /**
     * ݂̈ړxړxɍXV .
     */
    inline void setMvVeloTop() {
        _veloMv = _veloTopMv;
    }

    /**
     * ݂̈ړxړxɍXV .
     */
    inline void setMvVeloBottom() {
        _veloMv = _veloBottomMv;
    }

    /**
     * ړxݒ .
     * @param prm_acceMove ړx
     */
    void setMvAcce(acce prm_acceMove);

    /**
     * ړxAu~ړvɂݒ肷 .
     * <pre><code>
     *
     *    x(v)
     *     ^       a:xi_accMv ɐݒ肳j
     *     |       D:~܂ł̈ړij
     *     |      V0:_̑xi= ݂ _veloMv gpj
     *   V0|      Te:~t[ i߂lj
     *     |_
     *     |  _
     *     |    _ Εӂ̌Xa
     *     |   D  _
     *     |        _
     *   --+----------_-----> (t)
     *   0 |          Te
     *
     * </code></pre>
     * }̂悤ȏԂz肵A̋(D)Ax(a)vZ _accMv ݒ肵ĂB<BR>
     * ~܂ł̃t[(Te)  (D) ɂω邽ߎwsB<BR>
     * @param prm_target_distance ~ړ(D)
     * @return KvȎԃt[(Te)BQllɂǂB
     */
    frame setMvAcceToStop(coord prm_target_distance);


    /**
     * ]p̊pxAu~̋pvɂݒ肷 .
     * @param prm_axis ](AXIS_X / AXIS_Y / AXIS_Z)
     * @param prm_target_angle_distance ~̈ړpx(D)
     * @return KvȎԃt[(Te)BQllɂǂB
     */
    frame setFaceAngAcceToStop(axis prm_axis, angle prm_target_angle_distance);


    /**
     * ړxAuڕWBxvuړ(B܂łɔ₷)vɂݒ .
     * <pre><code>
     *
     *    x(v)
     *     ^        a:xi_accMv ɐݒ肳j
     *     |        D:ړij
     *     |       V0:_̑xi= ݂ _veloMv gpj
     *     |       Vt:ڕWBxij
     *     |       Te:ڕWBxɒB̎ԁi߂lj
     *   Vt|........
     *     |      ^|
     *     |    ^  |
     *     |  ^    |   Εӂ̌Xa
     *     |^      |
     *   V0|    D   |
     *     |        |
     *   --+--------+---> (t)
     *   0 |        Te
     *
     * </code></pre>
     * }̂悤ȏԂz肵AڕWBx(Vt)ƁAړ(D)Ax(a)vZ _accMv ɐݒ肵ĂB<BR>
     * ڕWB܂ŕKvȃt[(Te) ̓p[^ɂω邽ߎwsB<BR>
     * ߑFsetMvAcceByD(0, D)  setMvAcceToStop(D) Ɠł
     * @param prm_target_distance  ڕWBxɒB܂łɔ₷(D)
     * @param prm_target_velo ڕWBx(Vt)
     * @return KvȎԃt[(Te)BQllɂǂB
     */
    frame setMvAcceByD(coord prm_target_distance, velo prm_target_velo);

    /**
     * ]p̊pxup(B܂łɔ₷)vuڕWBpxvɂݒ .
     * @param prm_axis ](AXIS_X / AXIS_Y / AXIS_Z)
     * @param prm_target_angle_distance ڕWBpxɒB܂łɔ₷](D)
     * @param prm_target_angvelo ڕWBpx(Vt)
     * @return KvȎԃt[(Te)BQllɂǂB
     */
    frame setFaceAngAcceByD(axis prm_axis, angle prm_target_angle_distance, angvelo prm_target_angvelo);

    /**
     * ړxAuڕWBxvu₷ԁvɂݒ .
     * <pre><code>
     *
     *    x(v)
     *     ^        a:xi_accMv ɐݒ肳)
     *     |        D:ړ i߂lj
     *     |       V0:_̑xi= ݂ _veloMv gpj
     *     |       Vt:ڕWBxij
     *     |       Te:ڕWBxɒB̎ԁij
     *   Vt|........
     *     |      ^|
     *     |    ^  |
     *     |  ^    |   Εӂ̌Xa
     *     |^      |
     *   V0|    D   |
     *     |        |
     *   --+--------+---> (tt[)
     *   0 |        Te
     *
     *    a = (Vt-V0) / Te
     * </code></pre>
     * }̂悤ȏԂz肵AڕWBx(Vt)ƁA̓B(Te) Ax(a)vZݒ肵ĂB<BR>
     * ړ(D)́Ap[^ɂω邽ߎwsB<BR>
     * @param prm_target_frames ₷(Te)
     * @param prm_target_velo   ڕWBx(Vt)
     * @return ړ(D)
     */
    coord setMvAcceByT(frame prm_target_frames, velo prm_target_velo);

    /**
     * ]p̊pxuڕWBpxvu₷ԁvɂݒ .
     * @param prm_axis ](AXIS_X / AXIS_Y / AXIS_Z)
     * @param prm_target_frames  ₷(Te)
     * @param prm_target_angvelo ڕWBx(Vt)
     * @return ړp(D)
     */
    angle setFaceAngAcceByT(axis prm_axis, frame prm_target_frames, angvelo prm_target_angvelo);

    /**
     * Actor̈ړpiZ]jݒB<BR>
     * Z̈ړpiZ]j͈͊Oi0`360,000 ȊOj̒lɂȂĂA 0`360,000 ͈͓̔̒lɍČvZ܂B<BR>
     * O@\L(_relate_RzFaceAng_with_RzMvAng_flg)̏ꍇA<BR>
     * ActořړpiZ]jƓ悤 setStopTargetFaceAng(int) s܂B<BR>
     *
     * @param   prm_ang ړpiZ]j(0`360,000)
     */
    void setRzMvAng(angle prm_ang);

    /**
     * ݂ Actor ̈ړpiZ]j։ZiŌZjB<BR>
     *
     * ɓn̂́AړpiZ]j̑łBActor̈ړpiZ]ji_angRzMvj𑊑Ύwł郁\bhłB<BR>
     * Z̈ړpiZ]j͈͊Oi0`360,000 ȊOj̒lɂȂĂAŏIIɂ setRzMvAng(int) Ăяo܂̂<BR>
     *  0`360,000 ͈͓̔̒lɍĐݒ肳܂B<BR>
     * łZiZjړpiZ]j́AZړx̏Ɖ̊Ԃ͈̔͂Ɍ܂B<BR>
     * ܂A̗LȔ͈͈͂ȉ̒ʂƂȂ܂B<BR>
     *
     *   _angveloRzBottomMv  ̓p  _angveloRzTopMv  łB<BR>
     *
     * ͈͊Ö̈ړpiZ]jw肵ꍇ́A߂͈͓̔̒lɋIɗ}A̒lZ܂B<BR>
     * ܂AO@\L(_relate_RzFaceAng_with_RzMvAng_flg)̏ꍇA<BR>
     * Z̈ړpiZ]j̒lAZ̖ڕW̎]pƂĐݒ肳܂BiőOɐݒ肳܂BAOAO0̃L̏ꍇłǁGj<BR>
     *
     * y⑫Fz<BR>
     * {\bht[s邱ƂXYʂ̉~^\ɂȂ܂B<BR>
     * ̈ړpiZ]jA 0 ɁA߂lZꍇ́Aɂ₩ȃJ[u`Ȃ]邱ƂӖ܂B<BR>
     * tɁÄړpiZ]jA0 A藣ꂽlZꍇ́AspIȃJ[u`Ȃ]邱ƂӖ܂B<BR>
     * ftHgZړx̏Ɖi_angveloRzBottomMvA_angveloRzTopMv)   -360000 , 360000<BR>
     * ƂȂĂ܂B͏uɁi1t[ŁjǂȈړpiZ]jɂς邱ƂӖ܂B<BR>
     *
     * @param   prm_angDistance ړpiZ]j(͈́F_angveloRzBottomMv ` _angveloRzTopMv)
     */
    void addRzMvAng(angle prm_angDistance);

    /**
     * Actor̖ڕẄړpiZ]j~@\L(ڕẄړpiZ]jݒ)<BR>
     * ɐݒ肳ꂽړpiZ]jɂȂ܂ŁAړpiZ]jZ(Z)𖈃t[s܂B<BR>
     * ZŹAړpiZ]j̊pxi_angveloRzMvj̐Ō肳܂B<BR>
     * <B>ړpiZ]j̊px 0 Ȃ΁AN܂B</B>삳ɂ́ApxKvłB<BR>
     * Iɂ́AaddRzMvAng(int) t[sdg݂łB(this->behave()Ŏs)<BR>
     * ڕẄړpiZ]jɓBȂ΁A̖ڕẄړpiZ]j~@\͉܂B<BR>
     *
     * @param   prm_angRzMv BڕẄړpiZ]j(-360,000`360,000)
     * @param   prm_way_allow  ~@\LɂȂi]
     * @param   prm_angveloAllowRyMv ~@\LɂȂړppx
     */
    void setStopTargetRzMvAng(angle prm_angRzMv,
                              int prm_way_allow = TURN_BOTH,
                              angvelo prm_angveloAllowRyMv = D180ANG);

    void setRzMvAngVelo(angvelo prm_angveloRzMv);

    void forceRzMvAngVeloRange(angvelo prm_angveloRzMv01, angvelo prm_angveloRzMv02);

    void setRzMvAngAcce(angacce prm_angacceRzMv);

    angle getRzMvAngDistanceTwd(coord prm_tx, coord prm_ty, int prm_way);

    /**
     * g̈ړpZ]p( _angRzMv )ƁA^[Qbg̉]pƂ̍擾.
     * TURN_COUNTERCLOCKWISE EEE]ōيp擾A̒lŕԂB
     * TURN_CLOCKWISE        EEE]Eōيp擾A̒lɕԂB
     * TURN_CLOSE_TO         EEE^[Qbg̉]pƋ߂̉]Ŏ擾A͕̒lɂȂB
     * TURN_ANTICLOSE_TO     EEE^[Qbg̉]pƋ̉]Ŏ擾A͕̒lɂȂB
     * @param prm_angTargetRzMv ^[Qbgp̒l
     * @param prm_way TURN_COUNTERCLOCKWISE/TURN_CLOCKWISE/TURN_CLOSE_TO/TURN_ANTICLOSE_TO
     * @return
     */
    angle getRzMvAngDistance(angle prm_angTargetRzMv, int prm_way);

    /**
     * Actor̈ړpiY]jݒB<BR>
     * Z̈ړpiY]j͈͊Oi0`360,000 ȊOj̒lɂȂĂA 0`360,000 ͈͓̔̒lɍČvZ܂B<BR>
     * O@\L(_relate_RyFaceAng_with_RyMvAng_flg)̏ꍇA<BR>
     * ActořړpiY]jƓ悤 setStopTargetFaceAng(int) s܂B<BR>
     * @param prm_ang ړpiY]j(0`360,000)
     */
    void setRyMvAng(angle prm_ang);

    /**
     * ݂ Actor ̈ړpiY]j։ZiŌZjB<BR>
     *
     * ɓn̂́AړpiY]j̑łBActor̈ړpiY]ji_angRyMvj𑊑Ύwł郁\bhłB<BR>
     * Z̈ړpiY]j͈͊Oi0`360,000 ȊOj̒lɂȂĂAŏIIɂ setRyMvAng(int) Ăяo܂̂<BR>
     *  0`360,000 ͈͓̔̒lɍĐݒ肳܂B<BR>
     * łZiZjړpiY]j́AYړx̏Ɖ̊Ԃ͈̔͂Ɍ܂B<BR>
     * ܂A̗LȔ͈͈͂ȉ̒ʂƂȂ܂B<BR>
     *
     *   _angveloRyBottomMv  ̓p  _angveloRyTopMv  łB<BR>
     *
     * ͈͊Ö̈ړpiY]jw肵ꍇ́A߂͈͓̔̒lɋIɗ}A̒lZ܂B<BR>
     * ܂AO@\L(_relate_RyFaceAng_with_RyMvAng_flg)̏ꍇA<BR>
     * Z̈ړpiY]j̒lAZ̖ڕW̎]pƂĐݒ肳܂BiőOɐݒ肳܂BAOAO0̃L̏ꍇłǁGj<BR>
     *
     * y⑫Fz<BR>
     * {\bht[s邱ƂXZʂ̉~^\ɂȂ܂B<BR>
     * ̈ړpiY]jA 0 ɁA߂lZꍇ́Aɂ₩ȃJ[u`Ȃ]邱ƂӖ܂B<BR>
     * tɁÄړpiY]jA0 A藣ꂽlZꍇ́AspIȃJ[u`Ȃ]邱ƂӖ܂B<BR>
     * ftHgYړx̏Ɖi_angveloRyBottomMvA_angveloRyTopMv) <BR>
     *
     *  -360,000  ̓p  360,000<BR>
     *
     * ƂȂĂ܂B͏uɁi1t[ŁjǂȈړpiY]jɂς邱ƂӖ܂B<BR>
     *
     * @param   prm_angDistance ړpiY]j(͈́F_angveloRyBottomMv ` _angveloRyTopMv)
     */
    void addRyMvAng(angle prm_angDistance);

    /**
     * Actor̖ڕWY]ړp̎~@\L .
     * ڕẄړpiY]jݒ肷B<BR>
     * ɐݒ肳ꂽړpiY]jɂȂ܂ŁAړpiY]jZ(Z)𖈃t[s܂B<BR>
     * ZŹAړpiY]j̊pxi_angveloRyMvj̐Ō肳܂B<BR>
     * <B>ړpiY]j̊px 0 Ȃ΁AN܂B</B>삳ɂ́ApxKvłB<BR>
     * Iɂ́AaddRyMvAng(int) t[sdg݂łB(this->behave()Ŏs)<BR>
     * ڕẄړpiY]jɓBȂ΁A̖ڕẄړpiY]j~@\͉܂B<BR>
     *
     * @param   prm_angRyMv BڕẄړpiY]j(-360,000`360,000)
     * @param   prm_mv_ang_ry_target_allow_way  ~@\LɂȂi]
     * @param   prm_angveloAllowRyMv ~@\LɂȂړppx
     */
    void setStopTargetRyMvAng(angle prm_angRyMv,
                              int prm_mv_ang_ry_target_allow_way = TURN_BOTH,
                              angvelo prm_angveloAllowRyMv = D180ANG);

    void setRyMvAngVelo(angvelo prm_angveloRyMv);

    void forceRyMvAngVeloRange(angvelo prm_angveloRyMv01, angvelo prm_angveloRyMv02);

    void setRyMvAngAcce(angacce prm_angacceRyMv);

    angle getRyMvAngDistanceTwd(coord prm_tx, coord prm_ty, int prm_way);

    angle getRyMvAngDistance(angle prm_angTargetRyMv, int prm_way);


    void forceRzRyMvAngVeloRange(angvelo prm_angveloRzRyMv01, angvelo prm_angveloRzRyMv02);

    void setRzRyMvAngVelo(angvelo prm_angveloRzMv, angvelo prm_angveloRyMv);

    void setRzRyMvAngAcce(angacce prm_angacceRzMv, angacce prm_angacceRyMv);


    /**
     * g̈ړpZY]p(_angRzMv, _angRyMv)ƁA^[Qbg̉]pƂ̍œKȍ擾 .
     * Ӗg RzRy ܂ł̋oA<BR>
     * BAȌȂ RzRy ̑gݍ킹̗pB<BR>
     * (ӁFɒnY]邽߁AŏAO͕KŒZɂ炸)<BR>
     * ]̕ɍŒZt[Ń^[Qbg邪A _angMvRz, _angMvRy <BR>
     * ̃^[QbgAOlƈvȂȂB(pقȂ\L)<BR>
     * vȂƂꍇ́AZYʂɋ߂ĉB<BR>
     * @param prm_target_angRz
     * @param prm_target_angRy
     * @param prm_way ^[Qbg邽߂́A]wB̂ꂩwB<BR>
     *                TURN_COUNTERCLOCKWISE/TURN_CLOCKWISE/TURN_CLOSE_TO/TURN_ANTICLOSE_TO
     * @param out_d_angRz
     * @param out_d_angRy
     */
    void getRzRyMvAngDistanceTwd(angle prm_target_angRz, angle prm_target_angRy,int prm_way,
                                 angle& out_d_angRz, angle& out_d_angRy);

    /**
     * g̎]pZY]p(_angFace[AXIS_Z], _angFace[AXIS_Y])ƁA^[Qbg̉]pƂ̍œKȍ擾 .
     * Ӗg RzRy ܂ł̋oA<BR>
     * BAȌȂ RzRy ̑gݍ킹̗pB<BR>
     * (ӁFɒnY]邽߁AŏAO͕KŒZɂ炸)<BR>
     * ]̕ɍŒZt[Ń^[Qbg邪A _angMvRz, _angMvRy <BR>
     * ̃^[QbgAOlƈvȂȂB(pقȂ\L)<BR>
     * vȂƂꍇ́AZYʂɋ߂ĉB<BR>
     * @param prm_target_angRz
     * @param prm_target_angRy
     * @param prm_way ^[Qbg邽߂́A]wB̂ꂩwB<BR>
     *                TURN_COUNTERCLOCKWISE/TURN_CLOCKWISE/TURN_CLOSE_TO/TURN_ANTICLOSE_TO
     * @param out_d_angRz
     * @param out_d_angRy
     */
    void getRzRyFaceAngDistanceTwd(angle prm_target_angRz, angle prm_target_angRy,int prm_way,
                                   angle& out_d_angRz, angle& out_d_angRy);
    /**
     * ړ(RzRy)ݒB.
     * @param prm_angRz
     * @param prm_angRy
     */
    void setRzRyMvAng(angle prm_angRz, angle prm_angRy);

    /**
     *  ړ(RzRy)ARyRzŐݒB
     * @param prm_angRy
     * @param prm_angRz
     */
    void setRzRyMvAng_by_RyRz(angle prm_angRy, angle prm_angRz);

    /**
     * ڕWW_Wwňړp(RzRy)ݒB.
     * xNgKōsȂB
     * @param prm_tx ڕWXW
     * @param prm_ty ڕWYW
     * @param prm_tz ڕWZW
     */
    void setMvAngTwd(coord prm_tx, coord prm_ty, coord prm_tz);

    /**
     * ڕWW_Wwňړp(RzRy)ݒB.
     * As(ZW)ČvZsB
     * xNgKōsȂB
     * @param prm_tx ڕWXW
     * @param prm_ty ڕWYW
     */
    inline void setMvAngTwd(coord prm_tx, coord prm_ty) {
        setMvAngTwd(prm_tx, prm_ty, _pActor->_z);
    }

    /**
     * ڕWW_wΏۃAN^[̍Wwňړp(RzRy)ݒB.
     * xNgKōsȂB
     * @param prm_pActor_Target ڕWΏۃAN^[
     */
    inline void setMvAngTwd(GgafDxGeometricActor* prm_pActor_Target) {
        setMvAngTwd(
            prm_pActor_Target->_x,
            prm_pActor_Target->_y,
            prm_pActor_Target->_z
        );
    }

    inline void setMvAngTwd(GgafDxGeoElem* prm_pGeoElem) {
        setMvAngTwd(
            prm_pGeoElem->x,
            prm_pGeoElem->y,
            prm_pGeoElem->z
        );
    }

    void reverseMvAng();

    void setStopTargetMvAngTwd(coord prm_tx, coord prm_ty, coord prm_tz);

    void setStopTargetMvAngTwd(GgafDxGeometricActor* prm_pActor_Target);

    /**
     * ]p(ZY)ڕWɃ^[QbgV[NGXs .
     * @param prm_angRz_Target ڕW]p(Z)
     * @param prm_angRy_Target ڕW]p(Y)
     * @param prm_angVelo ^[QbeBOsɉZpxA܂pxij
     * @param prm_angAcce pxij
     * @param prm_way ^[Qbg邽߂́A]wB̂ꂩwB<BR>
     *                TURN_COUNTERCLOCKWISE/TURN_CLOCKWISE/TURN_CLOSE_TO/TURN_ANTICLOSE_TO
     * @param prm_optimize_ang ^[QbgAOœK邩ǂwB
     *                         true:  prm_angRz_Target, prm_angRy_Target ܂ł̋ƁA<BR>
     *                               Ӗg RzRy ܂ł̋oA<BR>
     *                               Bt[̏Ȃ RzRy ̑gݍ킹̗pB<BR>
     *                               (ӁFɒnY]邽߁AŒZt[͕KŒZɂ炸)<BR>
     *                               ]̕ɍŒZt[Ń^[Qbg邪A _angMvRz, _angMvRy <BR>
     *                               ̃^[QbgAOlƈvȂȂB(pقȂ\L)<BR>
     *                         false: prm_angRz_Target, prm_angRy_Target ̂܂܃^[Q[gƂB<BR>
     */
    void turnRzRyFaceAngTo(angle prm_angRz_Target, angle prm_angRy_Target,
                           angvelo prm_angVelo, angacce prm_angAcce,
                           int prm_way, bool prm_optimize_ang);

    /**
     * ]pڕWɃ^[QbgV[NGXs .
     * @param prm_tx ڕWXW
     * @param prm_ty ڕWYW
     * @param prm_tz ڕWZW
     * @param prm_angVelo ^[QbeBOsɉZpxA܂pxij
     * @param prm_angAcce pxij
     * @param prm_way ^[Qbg邽߂́A]wB̂ꂩwB<BR>
     *                TURN_COUNTERCLOCKWISE/TURN_CLOCKWISE/TURN_CLOSE_TO/TURN_ANTICLOSE_TO<BR>
     * @param prm_optimize_ang ^[QbgAOœK邩ǂwB<BR>
     *                         true:  prm_angRz_Target, prm_angRy_Target ܂ł̋ƁA<BR>
     *                               Ӗg RzRy ܂ł̋oA<BR>
     *                               Bt[̏Ȃ RzRy ̑gݍ킹̗pB<BR>
     *                               ]̕ɍŒZt[Ń^[Qbg邪A _angMvRz, _angMvRy <BR>
     *                               ̃^[QbgAOlƈvȂȂB(pقȂ\L)<BR>
     *                               (ӁFɒnY]邽߁AŒZt[͕KŒZɂ炸)<BR>
     *                         false: prm_angRz_Target, prm_angRy_Target ̂܂܃^[Q[gƂB<BR>
     */
    void turnFaceAngTwd(coord prm_tx, coord prm_ty, coord prm_tz,
                        angvelo prm_angVelo, angacce prm_angAcce,
                        int prm_way, bool prm_optimize_ang);


    /**
     * ]p(ZY)ڕWɃ^[Qbg̕悤ȃV[NGXs
     * @param prm_pActor_Target ڕWIuWFNg
     * @param prm_angVelo ^[QbeBOsɉZpxA܂pxij
     * @param prm_angAcce pxij
     * @param prm_way ^[Qbg邽߂́A]wB̂ꂩwB
     *                TURN_COUNTERCLOCKWISE/TURN_CLOCKWISE/TURN_CLOSE_TO/TURN_ANTICLOSE_TO
     * @param prm_optimize_ang ^[QbgAOœK邩ǂwB<BR>
     *                         true:  prm_angRz_Target, prm_angRy_Target ܂ł̋ƁA<BR>
     *                               Ӗg RzRy ܂ł̋oA<BR>
     *                               Bt[̏Ȃ RzRy ̑gݍ킹̗pB<BR>
     *                               ]̕ɍŒZt[Ń^[Qbg邪A _angMvRz, _angMvRy <BR>
     *                               ̃^[QbgAOlƈvȂȂB(pقȂ\L)<BR>
     *                               (ӁFɒnY]邽߁AŒZt[͕KŒZɂ炸)<BR>
     *                         false: prm_angRz_Target, prm_angRy_Target ̂܂܃^[Q[gƂB<BR>
     */
    inline void turnFaceAngTwd(GgafDxGeometricActor* prm_pActor_Target,
                               angvelo prm_angVelo, angacce prm_angAcce,
                               int prm_way, bool prm_optimize_ang) {
        turnFaceAngTwd(
                prm_pActor_Target->_x,
                prm_pActor_Target->_y,
                prm_pActor_Target->_z,
                prm_angVelo,
                prm_angAcce,
                prm_way,
                prm_optimize_ang
        );
    }
    inline void turnFaceAngTwd(GgafDxGeoElem* prm_pGeoElem,
                               angvelo prm_angVelo, angacce prm_angAcce,
                               int prm_way, bool prm_optimize_ang) {
        turnFaceAngTwd(
                prm_pGeoElem->x,
                prm_pGeoElem->y,
                prm_pGeoElem->z,
                prm_angVelo,
                prm_angAcce,
                prm_way,
                prm_optimize_ang
        );
    }

    /**
     * ]pڕW̊p]V[NGXs .
     * @param prm_axis   (AXIS_X or AXIS_Y or AXIS_Z)
     * @param prm_angular_distance piFTURN_COUNTERCLOCKWISEAFTURN_CLOCKWISEj
     * @param prm_angVelo pxiprm_angular_distance̐Ɉˑj
     * @param prm_angAcce pxiprm_angular_distance̐Ɉˑj
     */
    void turnFaceAng(axis prm_axis,
                     angle prm_angular_distance,
                     angvelo prm_angVelo, angacce prm_angAcce);

    /**
     * ]p(Z)ڕWɃ^[QbgV[NGXs .
     * @param prm_angRz_Target ڕW]p(Z)
     * @param prm_angVelo ^[QbeBOsɉZpxA܂pxij
     * @param prm_angAcce pxij
     * @param prm_way ^[Qbg邽߂́A]wB̂ꂩwB
     *                TURN_COUNTERCLOCKWISE/TURN_CLOCKWISE/TURN_CLOSE_TO/TURN_ANTICLOSE_TO
     */
    void turnRzFaceAngTo(angle prm_angRz_Target,
                         angvelo prm_angVelo, angacce prm_angAcce,
                         int prm_way);

    /**
     * ]p(Y)ڕWɃ^[QbgV[NGXs .
     * @param prm_angRy_Target ڕW]p(Y)
     * @param prm_angVelo ^[QbeBOsɉZpxA܂pxij
     * @param prm_angAcce pxij
     * @param prm_way ^[Qbg邽߂́A]wB̂ꂩwB
     *                TURN_COUNTERCLOCKWISE/TURN_CLOCKWISE/TURN_CLOSE_TO/TURN_ANTICLOSE_TO
     */
    void turnRyFaceAngTo(angle prm_angRy_Target,
                         angvelo prm_angVelo, angacce prm_angAcce,
                         int prm_way);

    /**
     * ]p(X)ڕWɃ^[QbgV[NGXs .
     * @param prm_angRx_Target ڕW]p(X)
     * @param prm_angVelo ^[QbeBOsɉZpxA܂pxij
     * @param prm_angAcce pxij
     * @param prm_way ^[Qbg邽߂́A]wB̂ꂩwB
     *                TURN_COUNTERCLOCKWISE/TURN_CLOCKWISE/TURN_CLOSE_TO/TURN_ANTICLOSE_TO
     */
    void spinRxFaceAngTo(angle prm_angRx_Target,
                         angvelo prm_angVelo, angacce prm_angAcce,
                         int prm_way);

    /**
     * ړpڕWɃ^[QbgV[NGXs .
     * @param prm_angRz_Target ڕWړp(Z)
     * @param prm_angRy_Target ڕWړp(Y)
     * @param prm_angVelo ^[QbeBOsɉZpxA܂pxij
     * @param prm_angAcce pxij
     * @param prm_way ^[Qbg邽߂́A]wB̂ꂩwB<BR>
     *                TURN_COUNTERCLOCKWISE/TURN_CLOCKWISE/TURN_CLOSE_TO/TURN_ANTICLOSE_TO<BR>
     * @param prm_optimize_ang ^[QbgAOœK邩ǂwB<BR>
     *                         true:  prm_angRz_Target, prm_angRy_Target ܂ł̋ƁA<BR>
     *                               Ӗg RzRy ܂ł̋oA<BR>
     *                               Bt[̏Ȃ RzRy ̑gݍ킹̗pB<BR>
     *                               ]̕ɍŒZt[Ń^[Qbg邪A _angMvRz, _angMvRy <BR>
     *                               ̃^[QbgAOlƈvȂȂB(pقȂ\L)<BR>
     *                               (ӁFɒnY]邽߁AŒZt[͕KŒZɂ炸)<BR>
     *                         false: prm_angRz_Target, prm_angRy_Target ̂܂܃^[Q[gƂB<BR>
     */
    void turnRzRyMvAngTo(angle prm_angRz_Target, angle prm_angRy_Target,
                         angvelo prm_angVelo, angacce prm_angAcce,
                         int prm_way, bool prm_optimize_ang);


    /**
     * ړpڕWɃ^[QbgV[NGXs .
     * @param prm_tx ڕWXW
     * @param prm_ty ڕWYW
     * @param prm_tz ڕWZW
     * @param prm_angVelo ^[QbeBOsɉZpxA܂pxij
     * @param prm_angAcce pxij
     * @param prm_way ^[Qbg邽߂́A]wB̂ꂩwB<BR>
     *                TURN_COUNTERCLOCKWISE/TURN_CLOCKWISE/TURN_CLOSE_TO/TURN_ANTICLOSE_TO<BR>
     * @param prm_optimize_ang ^[QbgAOœK邩ǂwB<BR>
     *                         true:  prm_angRz_Target, prm_angRy_Target ܂ł̋ƁA<BR>
     *                               Ӗg RzRy ܂ł̋oA<BR>
     *                               Bt[̏Ȃ RzRy ̑gݍ킹̗pB<BR>
     *                               ]̕ɍŒZt[Ń^[Qbg邪A _angMvRz, _angMvRy <BR>
     *                               ̃^[QbgAOlƈvȂȂB(pقȂ\L)<BR>
     *                               (ӁFɒnY]邽߁AŒZt[͕KŒZɂ炸)<BR>
     *                         false: prm_angRz_Target, prm_angRy_Target ̂܂܃^[Q[gƂB<BR>
     */
    void turnMvAngTwd(coord prm_tx, coord prm_ty, coord prm_tz,
                      angvelo prm_angVelo, angacce prm_angAcce,
                      int prm_way, bool prm_optimize_ang);


    void keepOnTurningFaceAngTwd(coord prm_tx, coord prm_ty, coord prm_tz,
                                 angvelo prm_angVelo, angacce prm_angAcce,
                                 int prm_way, bool prm_optimize_ang) {
        turnFaceAngTwd(prm_tx, prm_ty, prm_tz,
                       prm_angVelo,  prm_angAcce,
                       prm_way, prm_optimize_ang );
        _taget_face_ang_alltime_flg = true;
        _taget_face_ang_alltime_pActor = nullptr;
        _taget_face_ang_alltime_tx = prm_tx;
        _taget_face_ang_alltime_ty = prm_ty;
        _taget_face_ang_alltime_tz = prm_tz;
        _taget_face_ang_alltime_angVelo = prm_angVelo;
        _taget_face_ang_alltime_angAcce = prm_angAcce;
        _taget_face_ang_alltime_way = prm_way;
        _taget_face_ang_alltime_optimize_ang = prm_optimize_ang;
    }


    void keepOnTurningFaceAngTwd(GgafDxGeometricActor* prm_pActor_Target,
                                 angvelo prm_angVelo, angacce prm_angAcce,
                                 int prm_way, bool prm_optimize_ang) {
        keepOnTurningFaceAngTwd(
                prm_pActor_Target->_x,
                prm_pActor_Target->_y,
                prm_pActor_Target->_z,
                prm_angVelo, prm_angAcce,
                prm_way, prm_optimize_ang);
        _taget_face_ang_alltime_pActor = prm_pActor_Target;
    }

    /**
     * ړpڕWɃ^[Qbg̍WɂV[NGXs
     * @param prm_pActor_Target ڕWIuWFNg
     * @param prm_angVelo ^[QbeBOsɉZpxA܂pxij
     * @param prm_angAcce pxij
     * @param prm_way ^[Qbg邽߂́A]wB̂ꂩwB<BR>
     *                TURN_COUNTERCLOCKWISE/TURN_CLOCKWISE/TURN_CLOSE_TO/TURN_ANTICLOSE_TO<BR>
     * @param prm_optimize_ang ^[QbgAOœK邩ǂwB<BR>
     *                         true:  prm_angRz_Target, prm_angRy_Target ܂ł̋ƁA<BR>
     *                               Ӗg RzRy ܂ł̋oA<BR>
     *                               Bt[̏Ȃ RzRy ̑gݍ킹̗pB<BR>
     *                               ]̕ɍŒZt[Ń^[Qbg邪A _angMvRz, _angMvRy <BR>
     *                               ̃^[QbgAOlƈvȂȂB(pقȂ\L)<BR>
     *                               (ӁFɒnY]邽߁AŒZt[͕KŒZɂ炸)<BR>
     *                         false: prm_angRz_Target, prm_angRy_Target ̂܂܃^[Q[gƂB<BR>
     */
    inline void turnMvAngTwd(GgafDxGeometricActor* prm_pActor_Target,
                             angvelo prm_angVelo, angacce prm_angAcce,
                             int prm_way, bool prm_optimize_ang) {
        turnMvAngTwd(
                prm_pActor_Target->_x,
                prm_pActor_Target->_y,
                prm_pActor_Target->_z,
                prm_angVelo,
                prm_angAcce,
                prm_way,
                prm_optimize_ang
        );
    }

    inline void turnMvAngTwd(GgafDxGeoElem* prm_pGeoElem,
                             angvelo prm_angVelo, angacce prm_angAcce,
                             int prm_way, bool prm_optimize_ang) {
        turnMvAngTwd(
                prm_pGeoElem->x,
                prm_pGeoElem->y,
                prm_pGeoElem->z,
                prm_angVelo,
                prm_angAcce,
                prm_way,
                prm_optimize_ang
        );
    }

    /**
     * ړp(Z)ڕW̊p]V[NGXs .
     * @param prm_angular_distance  ړp̉]p(Z)
     * @param prm_angVelo ^[Qbgֈړp]ړɓKppxiprm_angular_distance̐Ɉˑj
     * @param prm_angAcce pxiprm_angular_distance̐Ɉˑj
     */
    void turnRzMvAng(angle prm_angular_distance,
                     angvelo prm_angVelo, angacce prm_angAcce);

    /**
     * ړp(Y)ڕW̊p]V[NGXs .
     * @param prm_angular_distance  ړp̉]p(Y)
     * @param prm_angVelo ^[Qbgֈړp]ړɓKppxiprm_angular_distance̐Ɉˑj
     * @param prm_angAcce pxiprm_angular_distance̐Ɉˑj
     */
    void turnRyMvAng(angle prm_angular_distance,
                     angvelo prm_angVelo, angacce prm_angAcce);

    /**
     * ړp(Z)ڕWɃ^[QbgV[NGXs .
     * @param prm_angRz_Target ڕWړp(Z)
     * @param prm_angVelo ^[Qbgֈړp]ړɓKppxij
     * @param prm_angAcce pxij
     * @param prm_way ^[Qbg邽߂́A]wB̂ꂩwB<BR>
     *                TURN_COUNTERCLOCKWISE/TURN_CLOCKWISE/TURN_CLOSE_TO/TURN_ANTICLOSE_TO
     */
    void turnRzMvAngTo(angle prm_angRz_Target,
                       angvelo prm_angVelo, angacce prm_angAcce,
                       int prm_way);

    /**
     * ړp(Y)ڕWɃ^[QbgV[NGXs .
     * @param prm_angRy_Target ڕWړp(Y)
     * @param prm_angVelo ^[Qbgֈړp]ړɓKpڕWړp]ړpxij
     * @param prm_angAcce pxij
     * @param prm_way ^[Qbg邽߂́A]wB̂ꂩwB<BR>
     *                TURN_COUNTERCLOCKWISE/TURN_CLOCKWISE/TURN_CLOSE_TO/TURN_ANTICLOSE_TO
     */
    void turnRyMvAngTo(angle prm_angRy_Target,
                       angvelo prm_angVelo, angacce prm_angAcce,
                       int prm_way);

    void stopTurnMvAng();

    void stopTurnFaceAng();

    /**
     * ڕW]pɃ^[QbgV[NGXs .
     * @return true:s/false:słȂ
     */
    bool isTurningFaceAng();

    /**
     * ڕWړpɃ^[QbgV[NGXs .
     * @return true:s/false:słȂ
     */
    bool isTurningMvAng();

    /**
     * ړpɔĎ]pXV .
     * true ݒ肷ƁAIɈړp̕ɌςB<BR>
     * false ݒ肷ƁAړpƌ͓ƗAftHg͂B<BR>
     * @param prm_b true:ړpɔĎ]pXV/false:ړpƎ]p͓Ɨ
     */
    void relateFaceByMvAng(bool prm_b) {
        _relate_RyFaceAng_with_RyMvAng_flg = prm_b;
        _relate_RzFaceAng_with_RzMvAng_flg = prm_b;
    }


    /**
     * ߂̎dp .
     *  GgafDxKuroko IuWFNgԂgɈp .
     * @param prm_pKuroko p
     */
    void takeoverMvFrom(GgafDxKuroko* const prm_pKuroko);

    /**
     * ړ~܂B
     */
    void stopMv();

    /**
     * ߂U镑 .
     * ߋ@\𗘗pꍇ́Ã\bh𖈃t[ĂяosĂB<BR>
     * tɍ߂KvƂȂꍇ́Ã\bhĂяoȂƂŁAptH[}Xɉe^܂B<BR>
     */
    virtual void behave();

    virtual ~GgafDxKuroko();
};

}
#endif /*GGAFDXCORE_GGAFDXKUROKOA_H_*/

