#ifndef GGAFCORE_GGAFVALUEACCELERATOR_H_
#define GGAFCORE_GGAFVALUEACCELERATOR_H_
#include "jp/ggaf/core/GgafObject.h"
#include "jp/ggaf/core/util/GgafUtil.h"


namespace GgafCore {

/**
 * l̉ .
 * @version 1.00
 * @since 2013/12/05
 * @author Masatoshi Tsuge
 */
template<class VAL_TYPE>
class GgafValueAccelerator : public GgafObject {
public:


    class SmoothPrm {
     public:
         /** [r]Ȃ߂炩ړV[NGXstrue */
         bool _flg;
         /** [r]Ȃ߂炩ړV[NGXs̉xݒitrueFx0ɐݒ^false:x̂܂܂ɂĂj */
         bool _endacc_flg;
         /** [r]Ȃ߂炩ړV[NGXŐݒ肳ꂽgbvXs[hiړxj */
         VAL_TYPE _top_velo;
         /** [r]Ȃ߂炩ړV[NGXŐݒ肳ꂽȊx */
         VAL_TYPE _end_velo;
         /** [r]Ȃ߂炩ړV[NGXŐݒ肳ꂽڕWʒuB܂łɕKvȎ̈ړî݁B̈ړZꍇ̂dۂaj */
         VAL_TYPE _target_distance;
         /** [r]Ȃ߂炩ړV[NGXŐݒ肳ꂽڕWʒu܂ł̒iLj */
         VAL_TYPE _target_distance2;
         /** [r]Ȃ߂炩ړV[NGXō܂łɎړړvi܂ł̈ړx̐Βl̉Zvj */
         VAL_TYPE _moved;
         /** [r]Ȃ߂炩ړV[NGXō܂ł̈ړ̘ai܂ł̈ړxî܂܂̉Zvj */
         VAL_TYPE _moved2;
         /** [r]Ȃ߂炩ړV[NGXňړx𔽓]܂ł̐ݒ肳ꂽ񕜎x */
         VAL_TYPE _acce_a0;
         /** [r]Ȃ߂炩ړV[NGXŐݒ肳ꂽڕWړ̐ */
         int _target_sgn;
         /** [r]Ȃ߂炩ړV[NGXŐݒ肳ꂽڕW */
         int  _target_frames;
         /** [r]Ȃ߂炩ړV[NGXɊJn猻݂܂ł̌oߎ */
         int  _frame_of_spent;
         /** [r]Ȃ߂炩ړV[NGXŐݒ肳ꂽpx̐؂ւ|Cg */
         double  _p0;
         /** [r]Ȃ߂炩ړV[NGXŐݒ肳ꂽ`֐؂ւʒu */
         double  _p1;
         /** [r]Ȃ߂炩ړV[NGXŐݒ肳ꂽ`֐؂ւʒu */
         double  _p2;
         /** [r]Ȃ߂炩ړV[NGX̐i */
         int  _progress;
     public:
         SmoothPrm() {
             _flg = false;
             _endacc_flg = true;
             _top_velo = 0;
             _end_velo = 0;
             _target_distance = 0;
             _target_distance2 = 0;
             _moved = 0;
             _moved2 = 0;
             _acce_a0 = 0;
             _target_sgn = 1;
             _target_frames = 0;
             _frame_of_spent = 0;
             _p0 = 0;
             _p1 = 0;
             _p2 = 0;
             _progress = -1;
         }
    };
    VAL_TYPE _value;
    VAL_TYPE _velo;
    VAL_TYPE _acce;
    SmoothPrm _prm;
public:
    GgafValueAccelerator() {
        _value = 0;
        _velo = 0;
        _acce = 0;
    }

    void accelerateByDt(VAL_TYPE prm_target_value_distance,
                        frame prm_target_frames,
                        double prm_p1, double prm_p2, VAL_TYPE prm_end_velo,
                        bool prm_endacc_flg) {
        int s_d = SGN(prm_target_value_distance);
        int sgn_W0 = SGN(_velo);
        if (ZEROd_EQ(prm_target_value_distance)) {
            //0Ȃ̂őI
            _velo = ABS(prm_end_velo) * s_d;
            if (prm_endacc_flg) {
                _acce = (VAL_TYPE)0.0;
            }
            _prm._progress = -9;
            _prm._endacc_flg = false;
            return;
        }
        //_TRACE_("GgafValueAccelerator::accelerateByDt COME!");
        //_TRACE_("prm_target_value_distance="<<prm_target_value_distance);
        //_TRACE_("prm_target_frames="<<prm_target_frames);
        //_TRACE_("prm_p1="<<prm_p1);
        //_TRACE_("prm_p2="<<prm_p2);
        //_TRACE_("prm_end_velo="<<prm_end_velo);
        //_TRACE_("prm_endacc_flg="<<prm_endacc_flg);

        if (sgn_W0 == 0 || s_d == sgn_W0) {  //v
            //gbvXs[h(Vt) vZ
            //
            //    x(v)
            //     ^
            //     |                          D:ڕWړ
            //     |                         V0:_̑x
            //     |                         Vt:gbvXs[h
            //     |                         Ve:ŏIx
            //   Vt|....QQQQQ           Te:ڕWԁit[j
            //     |   /:         :_        p1:gbvXs[hɒB鎞ƂȂ悤ȁATeɑ΂銄
            //   Ve|../.:.........:.._      p2:JnƂȂ悤ȁATeɑ΂銄
            //     | /  :         :    |        (0.0 < p1 < p2 < 1.0)
            //     |/   :         :    |
            //   V0|    :    D    :    |
            //     |    :         :    |
            //   --+----+---------+----+-----> (t:t[)
            //   0 |    T1        T2   Te
            //
            // ړD́Ȃ`{̒`{Ȇ` ̖ʐςłA
            // D = (1/2)*(V0+Vt)*T1 + Vt*(T2-T1)  +  (1/2)*(Ve+Vt)*(Te-T2);
            // Vtɂĉ
            // Vt=-(T1*V0-Ve*T2-2*D+Te*Ve)/(T2-T1+Te)
            double V0 = _velo;
            double Ve = ABS(prm_end_velo) * s_d;
            double T1 = prm_target_frames*prm_p1;
            double T2 = prm_target_frames*prm_p2;
            double Te = prm_target_frames;
            double D  = prm_target_value_distance;
            double Vt = -(T1*V0-Ve*T2-2.0*D+Te*Ve)/(T2-T1+Te);


            //_TRACE_("V0="<<V0);
            //_TRACE_("Ve="<<Ve);
            //_TRACE_("T1="<<T1);
            //_TRACE_("T2="<<T2);
            //_TRACE_("Te="<<Te);
            //_TRACE_("D="<<D);
            //_TRACE_("Vt="<<Vt);

            _prm._flg = true;
            _prm._target_distance = ABS(D);
            _prm._target_distance2 = D;
            _prm._moved = 0;
            _prm._moved2 = 0;
            _prm._target_sgn = s_d;
            _prm._p1 = T1;
            _prm._p2 = T2;
            _prm._top_velo = Vt;
            _prm._end_velo = Ve;
            _prm._target_frames = Te;
            _prm._frame_of_spent = 0;
            _prm._endacc_flg = prm_endacc_flg;
            _prm._progress = 0;


        } else {
            //        x(v)
            //         ^
            //         |                                   D2-D1:ڕWړ
            //         |                                      V0:_̑x
            //         |                                      Vt:gbvXs[h
            //         |                                      Ve:ŏIx
            //       Vt|................QQQQQQ          Te:ڕWԁit[j
            //         |               /:  |       :_        p1:gbvXs[hɒB鎞ƂȂ悤ȁATeɑ΂銄
            //       Ve|............../.:..|.......:.._      p2:JnƂȂ悤ȁATeɑ΂銄
            //         |             /  :  |       :    |        (0.0 < p1 < p2 < 1.0)
            //         |         a  /   :  |       :    |
            //         |           /    s  |  D    :    |
            //         |          /     :  |       :    |
            //       --+---------/------+--+-------+----+-----> (t:t[)
            //       0 |        /Ts    T1         T2   Te
            //         |   -s  /
            //         |      /
            //         |     /
            //         |    /
            //         |   /
            //         |  /
            //         | /
            //       V0|/
            //         |
            //
            //     t  0 ` T1 ̊px w Ƃ
            //     V = a*t + V0 
            //    t = T1 ̎  V = Vt  ł̂
            //    Vt = a*T1 + V0
            //    a = -(V0-Vt)/T1 EEE(1)
            //
            //    t = Ts ̎  V = 0  ł̂
            //    0 = a*Ts + V0  EEE(2)
            //    (1)(2)֑
            //    0 = (-(V0-Vt)/T1)*Ts + V0
            //    Ts = (T1*V0)/(V0-Vt) EEE(3)
            //
            //    s
            //    s = (1/2)*Ts*-V0
            //    (3)
            //    s = (1/2)*( (T1*V0)/(V0-Vt) )*-V0
            //    s = -(T1*V0^2)/(2*(V0-Vt))  EEE(4)
            //
            //    Vt߂
            //    D+s = ̎Op`{̒`{Ȇ` ̖ʐςłA
            //    D+s =  ( (1/2)*(T1-Ts)*Vt )  +  ( (T2-T1) * Vt )  +  ( (1/2)*(Vt+Ve)*(Te-T2) )   EEE(5)
            //    (3)(4)(5)֑
            //    D+(-(T1*V0^2)/(2*(V0-Vt))) =  ( (1/2)*(T1-((T1*V0)/(V0-Vt)))*Vt )  +  ( (T2-T1) * Vt )  +  ( (1/2)*(Vt+Ve)*(Te-T2) )
            //    Vtɂĉ
            //    Vt=-(T1*V0-Ve*T2-2*D+Te*Ve)/(T2-T1+Te)
            double V0 = _velo;
            double Ve = ABS(prm_end_velo) * s_d;
            double T1 = prm_target_frames*prm_p1;
            double T2 = prm_target_frames*prm_p2;
            double Te = prm_target_frames;
            double D = prm_target_value_distance;
            double Vt = -(T1*V0-Ve*T2-2.0*D+Te*Ve)/(T2-T1+Te);
            double Ts = (T1*V0)/(V0-Vt);
            double s = (1.0/2.0)*Ts*-V0;

            //_TRACE_("V0="<<V0);
            //_TRACE_("Ve="<<Ve);
            //_TRACE_("T1="<<T1);
            //_TRACE_("T2="<<T2);
            //_TRACE_("Te="<<Te);
            //_TRACE_("D="<<D);
            //_TRACE_("Vt="<<Vt);
            //_TRACE_("Ts="<<Ts);
            //_TRACE_("s="<<s);
            _prm._flg = true;
            _prm._p0 = Ts;
            _prm._p1 = T1;
            _prm._p2 = T2;
            _prm._target_distance = ABS(s)+ ABS(s) + ABS(D);
            _prm._target_distance2 = D;
            _prm._target_sgn = s_d;
            _prm._moved = 0;
            _prm._moved2 = 0;
            _prm._top_velo = Vt;
            _prm._end_velo = Ve;
            _prm._target_frames = Te;
            _prm._frame_of_spent = 0;
            _prm._endacc_flg = prm_endacc_flg;
            _prm._progress = 0;
        }


        //_TRACE_("_prm._flg ="<<_prm._flg);
        //_TRACE_("_prm._p0 ="<<_prm._p0);
        //_TRACE_("_prm._p1 ="<<_prm._p1);
        //_TRACE_("_prm._p2 ="<<_prm._p2);
        //_TRACE_("_prm._target_distance ="<<_prm._target_distance);
        //_TRACE_("_prm._target_distance2 ="<<_prm._target_distance2);
        //_TRACE_("_prm._target_sgn ="<<_prm._target_sgn);
        //_TRACE_("_prm._moved ="<<_prm._moved);
        //_TRACE_("_prm._moved2 ="<<_prm._moved2);
        //_TRACE_("_prm._top_velo ="<<_prm._top_velo);
        //_TRACE_("_prm._end_velo ="<<_prm._end_velo);
        //_TRACE_("_prm._target_frames ="<<_prm._target_frames);
        //_TRACE_("_prm._frame_of_spent ="<<_prm._frame_of_spent);
        //_TRACE_("_prm._progress ="<<_prm._progress);

    }

    void accelerateByVd(VAL_TYPE prm_top_velo,
                        VAL_TYPE prm_target_value_distance,
                        double prm_p1, double prm_p2, VAL_TYPE prm_end_velo,
                        bool prm_endacc_flg) {
        //_TRACE_("prm_target_value_distance="<<prm_target_value_distance<<" _velo="<<_velo);
        int s_d = SGN(prm_target_value_distance);
        int sgn_W0 = SGN(_velo);
        if (ZEROd_EQ(prm_target_value_distance)) {
            //0Ȃ̂őI
            _velo = ABS(prm_end_velo) * s_d;
            if (prm_endacc_flg) {
                _acce = (VAL_TYPE)0.0;
            }
            _prm._progress = -9;
            _prm._endacc_flg = false;
            return;
        }
        //_TRACE_("s_d="<<s_d<<" sgn_W0="<<sgn_W0);
        if (sgn_W0 == 0 || s_d == sgn_W0) {  //v
            //
            //        px(V)                        V0:_̑x     (_veloMv)
            //         ^                               Vt:gbvXs[h   (prm_top_angvelo)
            //         |                               Ve:ŏIx         (prm_end_angvelo)
            //         |                                D:ڕW]pD  (D1+D2+D3)                     EEE vZċ߂
            //         |                               p1:gbvXs[hɒBpƂȂ悤ȁAp(D)ɑ΂銄
            //         |       D=D1+D2+D3                   ܂    D1 = D*p1 ƂȂ悤 p1 (0.0`1.0)
            //       Vt|....___________                p2:JnƂȂ悤ȁA(D)ɑ΂銄
            //         |   /|         |_                   ܂ D1+D2 = D*p2 ƂȂ悤 p2 (0.0`1.0)
            //       Ve|../.|.........|.._            T1: D1    = D*p1 ɔ₳Kvԃt[     EEE vZċ߂
            //         | /  |         |    |           T2: D1+D2 = D*p2 ɔ₳Kvԃt[     EEE vZċ߂
            //         |/   |         |    |           Te:₳Kvԃt[                     EEE vZċ߂
            //       V0| D1 |    D2   | D3 |
            //         |    |         |    |
            //       --+----+---------+----+-----> (t:t[)
            //       0 |    T1        T2   Te
            double V0 = _velo;
            double Vt = ABS(prm_top_velo) * s_d;
            double Ve = ABS(prm_end_velo) * s_d;
            //_TRACE_("V0 = "<<V0);
            //_TRACE_("Vt = "<<Vt);
            //_TRACE_("Ve = "<<Ve);
            _prm._flg = true;
            _prm._top_velo = Vt;
            _prm._end_velo = Ve;
            _prm._target_distance = ABS(prm_target_value_distance);
            _prm._target_distance2 = prm_target_value_distance;
            _prm._moved = 0;
            _prm._moved2 = 0;
            _prm._target_sgn = s_d;
            _prm._target_frames = -1; //Ԗgp
            _prm._frame_of_spent = 0;
            _prm._p0 = 0; //gp
            _prm._p1 = ABS(_prm._target_distance) * prm_p1;
            _prm._p2 = ABS(_prm._target_distance) * prm_p2;
            _prm._endacc_flg = prm_endacc_flg;
            _prm._progress = 2; //񕜃tF[Y΂
        } else {
            //                                                       V0:_̑x      (_veloMv)
            //        x(v)                                        Vt:gbvXs[h    (prm_top_angvelo)
            //        ^                                              Ve:ŏIx          (prm_end_angvelo)
            //        |                                               D:X^[g_̊px̖ڕW]p                     EEE vZċ߂
            //        |                                              Dp:pxOɂȂĂ̖ڕW]p(Dp1 + Dp2 + Dp3)   EEE vZċ߂
            //        |                                               s:pxOɂȂ܂ł̋t]                             EEE vZċ߂
            //        |                                              p1:gbvXs[hɒBpƂȂ悤ȁAp(D)ɑ΂銄
            //        |           D  = (Dp1-s) + Dp2 + Dp3                 ܂ Dp1 = Dp*p1 ƂȂ悤 p1 (0.0`1.0)    
            //        |           Dp = Dp1 + Dp2 + Dp3               p2:JnƂȂ悤ȁA(D)ɑ΂銄
            //      Vt|...............___________                          ܂ Dp1+Dp2 = Dp*p2 ƂȂ悤 p2 (0.0`1.0)  
            //        |            A /|         |_B                 T0: pxOɂȂ܂łɔ₳Kvԃt[  EEE vZċ߂
            //        |             / |         |  _                T1: Dp1     = Dp*p1 ɔ₳Kvԃt[  EEE vZċ߂
            //        |            /  |         |    _              T2: Dp1+Dp2 = Dp*p2 ɔ₳Kvԃt[  EEE vZċ߂
            //        |           /   |         |      _            Te:₳Kvԃt[                        EEE vZċ߂
            //        |          / Dp1|    Dp2  |  Dp3   _
            //        |         /:    |         |          _
            //      Ve|......../.:....|.........|............_  C
            //        |       /  :    |         |             |
            //        |      / s :    |         |             |
            //   -----+-----+----+----+---------+-------------+----------> (t:t[)
            //      0 | s^ Ts       T1        T2            Te
            //        |^
            //      V0| ^    <-s-><------------D-------------->
            //        | |
            //        | |    <---------------Dp--------------->
            //        | |
            //        | |    <---Dp1--><---Dp2--><-----Dp3---->
            //        | |
            //        | 񕜊px(a0)Œ
            //
            //         t  0 ` Ts ̊px V Ƃ
            //         V = a0*t + V0     (񕜊px(a0)͒萔)
            //        t = Ts ̎  V = 0  ł̂
            //        0 = a0*Ts + V0
            //        Ts = -V0/a0  EEE(1)
            //        ܂
            //        s = (1/2) * Ts * -V0       (Op`̖ʐ)
            //        (1)
            //        s = (1/2) * (-V0/a0) * -V0
            //        s = V0^2/(2*a0)  EEE(2)
            //        ܂
            //
            //        D + s =  Dp = (Dp1 + Dp2 + Dp3) EEE(3)
            //        
            //        Dp = D + (V0^2/(2*a0))  EEE(4)
            double V0 = _velo;
            double Vt = ABS(prm_top_velo) * s_d;
            double Ve = ABS(prm_end_velo) * s_d;
            double a0 = ABS(prm_top_velo)*0.05 * -sgn_W0;
            double s  = (V0*V0)/(2.0*a0);
            double Dp = s + prm_target_value_distance;
            //_TRACE_("V0 = "<<V0);
            //_TRACE_("Vt = "<<Vt);
            //_TRACE_("Ve = "<<Ve);
            //_TRACE_("a0 = "<<a0);
            //_TRACE_("s  = "<<s );
            //_TRACE_("Dp = "<<Dp);

            _prm._flg = true;
            _prm._top_velo = Vt;
            _prm._end_velo = Ve;
            _prm._target_distance = ABS(s) + ABS(Dp);
            _prm._target_distance2 = prm_target_value_distance;
            _prm._moved = 0;
            _prm._moved2 = 0;
            _prm._acce_a0 = a0;
            _prm._target_sgn = s_d;
            _prm._target_frames = -1; //Ԗgp
            _prm._frame_of_spent = 0;
            _prm._p0 = ABS(s);
            _prm._p1 = prm_p1;
            _prm._p2 = prm_p2;
            _prm._endacc_flg = prm_endacc_flg;
            _prm._progress = 0; //񕜃tF[Y

        }


        //_TRACE_("_prm._flg ="<<_prm._flg);
        //_TRACE_("_prm._p0 ="<<_prm._p0);
        //_TRACE_("_prm._p1 ="<<_prm._p1);
        //_TRACE_("_prm._p2 ="<<_prm._p2);
        //_TRACE_("_prm._target_distance ="<<_prm._target_distance);
        //_TRACE_("_prm._target_distance2 ="<<_prm._target_distance2);
        //_TRACE_("_prm._target_sgn ="<<_prm._target_sgn);
        //_TRACE_("_prm._moved ="<<_prm._moved);
        //_TRACE_("_prm._moved2 ="<<_prm._moved2);
        //_TRACE_("_prm._top_velo ="<<_prm._top_velo);
        //_TRACE_("_prm._end_velo ="<<_prm._end_velo);
        //_TRACE_("_prm._target_frames ="<<_prm._target_frames);
        //_TRACE_("_prm._frame_of_spent ="<<_prm._frame_of_spent);
        //_TRACE_("_prm._progress ="<<_prm._progress);
    }

    bool isAcce() {
        return _prm._flg;
    }

    void behave() {
        //Ȃ߂炩ړV[NGXN
        if (_prm._flg) {
            //_TRACE_(_prm._target_frames<<":_prm._progress="<<_prm._progress);
            //_TRACE_(_prm._target_frames<<":before _value="<<_value<<" _velo="<<_velo<<" _acce="<<_acce<<" _prm._moved="<<_prm._moved<<" _prm._moved2="<<_prm._moved2<<"");
            if (_prm._progress == -9) {
                _prm._flg = false; //܂
            } else {

                if (_prm._target_frames < 0) {
                    //ڕWw̏ꍇ
                    if (_prm._progress == 0) {
                        //񕜃tF[Y
                        _acce = _prm._acce_a0;
                        _prm._progress++;
                    }
                    if (_prm._progress == 1) {
                        //񕜒
                        if (_prm._moved >= _prm._p0) {
                            //ݒ
                            _acce = 0.0;
                            _velo = 0.0;
                            //Đݒ
                            _prm._target_distance = _prm._target_distance - _prm._moved;
                            _prm._moved = 0.0;
                            _prm._p1 = _prm._target_distance * _prm._p1;
                            _prm._p2 = _prm._target_distance * _prm._p2;
                            _prm._progress++;
                        }
                    }
                    if (_prm._progress == 2) {
                        if (!ZEROd_EQ(_prm._p1)) {
                            VAL_TYPE acc = UTIL::getAcceByVd(_velo, _prm._top_velo, _prm._p1*_prm._target_sgn);
                            _acce = acc;
                            if (ABS(_acce) > ABS(_prm._target_distance2)) {
                                _acce = _prm._target_distance2;
                            } else if (ABS(_acce) > ABS(_prm._top_velo)) {
                                _acce = _prm._top_velo;
                            }
                            _prm._progress++;
                        } else {
                            _acce = 0;
                            _velo = _prm._top_velo;
                            _prm._progress+=2; //XLbv
                        }
                    }
                    if (_prm._progress == 3) {
                        //
                        if (_prm._moved >= _prm._p1) {
                            //p1 ɓB 
                            _acce = 0;
                            _velo = _prm._top_velo;
                            VAL_TYPE diff_to_end = _prm._target_distance2 - _prm._moved2;
                            if (ABS(_velo) > ABS(diff_to_end)) {
                                _velo = diff_to_end;
                            }
                            _prm._progress++;
                        }
                    }
                    if (_prm._progress == 4) {
                        //_TRACE_("");
                        //
                        if (_prm._moved >= _prm._p2) {
                            //p2 ɓB t[猸
                            //_TRACE_("p2 ɓB t[猸");
                            VAL_TYPE diff_to_end = _prm._target_distance2 - _prm._moved2;
                            if (!ZEROd_EQ(diff_to_end)) {
                                //_TRACE_("diff_to_end="<<diff_to_end<<" x߂");
                                VAL_TYPE acc = UTIL::getAcceByVd(_velo, _prm._end_velo, diff_to_end);
                                _acce = acc;
                                //_TRACE_("x _acce="<<acc<<" ????");
                                if (ABS(_velo)+ABS(acc) > ABS(diff_to_end)) {
                                    _acce = diff_to_end-_velo;
                                }
                                //_TRACE_("x ␳ _acce="<<acc<<" ????");
                            }
                            _prm._progress++;
                        }
                    }
                    if (_prm._progress == 5) {
                         //_TRACE_("");
                        //
                        VAL_TYPE diff_to_end = _prm._target_distance2 - _prm._moved2;
                        //Te=(2*D)/(V0+Vt)

                        //double t = (2.0*diff_to_end)/(_velo+_prm._end_velo); //ct[    //Rg
                        //_TRACE_("double t = (2.0*diff_to_end)/(_velo+_prm._end_velo); //ct[");
                        //_TRACE_("double t = (2.0*"<<diff_to_end<<")/("<<_velo<<"+"<<_prm._end_velo<<"); //ct[");
                        //_TRACE_("double t = ("<<2.0*diff_to_end<<")/("<<_velo+_prm._end_velo<<"); //ct[");
                        //_TRACE_("ct[ t="<<t<<" H");
                        //_TRACE_("ABS(_velo) < 2.0*ABS(_acce) = "<<ABS(_velo)<<" < "<<2.0*ABS(_acce));
                        if (ABS(_velo) < 2.0*ABS(_acce)) {
                            //_TRACE_("␳Ȃ i_velo܂ɂ߁At B̉xݒ肳Ă܂߁j");
                            //t = 1;
                            //␳Ȃ(_velo܂ɂ߁At )
                        } else {
                            if (_prm._frame_of_spent % 2U == 0) {
        //                      if (t > 3 && ABS(diff_to_end) > ABS(_prm._top_velo)*0.0001 && _prm._frame_of_spent % 4U == 0) {
                                //_TRACE_("t="<<t<<" ĂȂ̂ŁA␳E␳E␳");
                                //␳E␳E␳
                                if (!ZEROd_EQ(diff_to_end)) {
                                    VAL_TYPE acc = UTIL::getAcceByVd(_velo, _prm._end_velo, diff_to_end);
                                    _acce = acc;
                                    //_TRACE_("xĐݒ _acce="<<acc<<" ????");
                                    if (ABS(_velo)+ABS(acc) > ABS(diff_to_end)) {
                                        _acce = diff_to_end-_velo;
                                    }
                                    //_TRACE_("xĐݒ ␳ _acce="<<acc<<" ????");
                                }
                            }
                        }
                        VAL_TYPE end_velo = _prm._end_velo;

                        if ( ZEROd_EQ(diff_to_end)  ||
                             ABS(diff_to_end) <=  ABS(_prm._top_velo)*0.0001 ||
                             (ZEROd_EQ(_prm._top_velo)  || (_prm._top_velo > 0 && diff_to_end <= 0) || (_prm._top_velo < 0  && diff_to_end >= 0) ) || //ʂz
                             (ZEROd_EQ(_velo+end_velo)  || (_velo+end_velo > 0 && _velo+end_velo+_acce < 0 ) || (_velo+end_velo <  0 && _velo+end_velo+_acce > 0) ) //͂]
                        ) {
                            //ڕW֓B
                            //_TRACE_("ڕW֓B");
                            //_TRACE_("ABS(_prm._target_distance2 - _prm._moved2) <=  ABS(_prm._top_velo)*0.00001");
                            //_TRACE_(""<<ABS(_prm._target_distance2 - _prm._moved2)<<" <= "<<ABS(_prm._top_velo)*0.00001<<" ??");
                            //_TRACE_("(ZEROd_EQ(_prm._top_velo)  || (_prm._top_velo > 0  && diff_to_end <= 0) || (_prm._top_velo < 0  && diff_to_end >= 0) ) || //ʂz");
                            //_TRACE_("_prm._top_velo="<<_prm._top_velo<<" diff_to_end="<<diff_to_end<<"");
                            //_TRACE_("(ZEROd_EQ(_velo+end_velo)  || (_velo+end_velo  >  0 && _velo +end_velo + _acce < 0 ) || (_velo+end_velo  <  0 && _velo +end_velo+_acce > 0) ) //͂]");
                            //_TRACE_("_velo="<<_velo<<" end_velo="<<end_velo<<" _velo+end_velo="<<_velo+end_velo<<" _acce="<<_acce<<" _velo +end_velo+_acce="<<_velo +end_velo + _acce <<"");
                            //_TRACE_("܂ȕ͋C");
                            _velo = _prm._end_velo;
                            if (_prm._endacc_flg) {
                                _acce = (VAL_TYPE)0.0;
                            }
                            if (ZEROd_EQ(end_velo)) {
                                //ŏIx0̏ꍇAob`킹݂B
                                if (ZEROd_EQ(diff_to_end)) {
                                    //Ƀob`Ă܂
                                    //_TRACE_("Ƀob`Ă܂");
                                    //_TRACE_("܂11I!!");
                                    _velo = (VAL_TYPE)0.0;
                                    _prm._flg = false; //܂
                                } else {
                                    //Ă̂łPt[撣ăob`킹
                                    _velo = diff_to_end;   //ob`킹
                                    //_TRACE_("ob`킹_velo="<<_prm._target_distance2<<"-"<<_prm._moved2<<"="<<_velo);
                                    _prm._progress++; //Pt[
                                }
                            } else {
                                //ŏIx0ł͂ȂB̂܂܏I
                                //_TRACE_("܂22");
                                _prm._flg = false; //܂
                            }
                        }
                    } else if (_prm._progress == 6) {
                        //_TRACE_("悵ob`킹Ă܂");
                        _velo = (VAL_TYPE)0.0;
                        _prm._flg = false; //܂
                    }
                } else {
                    //ڕWԎw̏ꍇ
                    if (_prm._progress == 0) {
                        if (ZEROd_EQ(_prm._p1)) {
                            _acce = 0;
                            _prm._progress++;
                        } else {
                            //ݒ
                            VAL_TYPE acc = UTIL::getAcceByTv(_prm._p1, _velo, _prm._top_velo);
                            _acce = acc;
                            _prm._progress++;
                        }
                    }
                    if (_prm._progress == 1) {
                        //
                        if (_prm._frame_of_spent >= (int)(_prm._p1)) {
                            //p1 ɓB 
                            _acce = 0;
                            _velo = _prm._top_velo;
                            _prm._progress++;
                        }
                    }
                    if (_prm._progress == 2) {
                        //_TRACE_(" _prm._frame_of_spent="<<_prm._frame_of_spent<<" _prm._p2="<<_prm._p2);
                        //
                        if (_prm._frame_of_spent >= (int)(_prm._p2)) {
                            //_TRACE_("p2 ɓB t[猸 _prm._frame_of_spent="<<_prm._frame_of_spent<<" _prm._p2="<<_prm._p2);
                            //p2 ɓB t[猸
                            VAL_TYPE acc = UTIL::getAcceByTv(_prm._target_frames - _prm._frame_of_spent, _velo, _prm._end_velo);
                            _acce = acc;
                            //_TRACE_("x _acce="<<_acce);
                            _prm._progress++;
                        }
                    }
                    if (_prm._progress == 3) {
                        //
                        //_TRACE_("");
                        if (_prm._frame_of_spent % 2U == 0) {
                            //_TRACE_("␳E␳E␳");
                            //␳E␳E␳
                            //Ō̑`␳
                            //D = (1/2)*(V+Ve)*Te
                            double Ve = _prm._end_velo;
                            double Te = _prm._target_frames - _prm._frame_of_spent;
                            //_TRACE_("Ve = "<<Ve);
                            //_TRACE_("Te = "<<Te);
                            if (Te > 0) {
                                double D = _prm._target_distance2 - _prm._moved2;
                                double V =(2.0*D-Te*Ve)/Te;
                                //_TRACE_("D = "<<D);
                                //_TRACE_("V = "<<V);
                                _velo = V;
                                //_TRACE_("x _velo = "<<_velo<<" ɕ␳");
                                VAL_TYPE acc = UTIL::getAcceByTv(_prm._target_frames - _prm._frame_of_spent, _velo, _prm._end_velo);
                                _acce = acc;
                                //_TRACE_("x _acce = "<<_acce<<" ɕ␳");
                            }
                        }
                        //_TRACE_("_prm._frame_of_spent="<<_prm._frame_of_spent<< " _prm._target_frames="<<_prm._target_frames);
                        if (_prm._frame_of_spent >= _prm._target_frames) {
                            //_TRACE_("_prm._frame_of_spent >= _prm._target_frames A܂ȕ͋C");
                            _velo = _prm._end_velo;
                            if (_prm._endacc_flg) {
                                _acce = (VAL_TYPE)0.0;
                            }
                            if (ZEROd_EQ(_prm._end_velo)) {
                                //ŏIx0̏ꍇAob`킹݂B
                                if (ZEROd_EQ(_prm._target_distance2 - _prm._moved2)) {
                                    //Ƀob`Ă܂
                                    //_TRACE_("Ƀob`Ă܂");
                                    //_TRACE_("܂1I");
                                    _velo = (VAL_TYPE)0.0;
                                    _prm._flg = false; //܂
                                } else {
                                    //ĂB
                                    _velo = (_prm._target_distance2 - _prm._moved2); //ob`킹āAPt[
                                    //_TRACE_("ob`킹_velo="<<_prm._target_distance2<<"-"<<_prm._moved2<<"="<<_velo);
                                    _prm._progress++;
                                }
                            } else {
                                //ŏIx0ł͂ȂB̂܂܏I
                                //_TRACE_("܂2");
                                _prm._flg = false; //܂
                            }
                        }
                    } else if (_prm._progress == 4) {
                        //_TRACE_("ob`킹Ă܂");
                        _velo = (VAL_TYPE)0.0;
                        _prm._flg = false; //܂
                    }
                }
            }

            _velo += _acce;
            _value += _velo;

            _prm._moved += ABS(_velo);
            _prm._moved2 += _velo;

            //_TRACE_(_prm._target_frames<<":after _value="<<_value<<" _velo="<<_velo<<" _acce="<<_acce<<" _prm._moved="<<_prm._moved<<" _prm._moved2="<<_prm._moved2<<"");
            _prm._frame_of_spent++;
        } else {
            _prm._progress = -1;
        }
#ifdef MY_DEBUG
        if (_prm._frame_of_spent > 60*60*10) {
            throwGgafCriticalException("GgafValueAccelerator::behave() 10ȏ㊊ςȂȂłI");
        }
#endif

    }

    virtual ~GgafValueAccelerator() {
    }
};

}
#endif /*GGAFCORE_GGAFVALUEACCELERATOR_H_*/

