#ifndef GGAFCORE_GGAFDEPOSITORYFORMATION_H_
#define GGAFCORE_GGAFDEPOSITORYFORMATION_H_
#include "jp/ggaf/core/actor/ex/GgafFormation.h"

#include "jp/ggaf/core/util/GgafLinkedListRing.hpp"

namespace GgafCore {

/**
 * f|WgǗ̃tH[[VǗ[NX .
 * ґo[͎g񂷃tH[[VB
 * gpꍇ́A{NXpA
 * setFormationMember(GgafActorDepository*) ɂ
 * ґo[̃f|WgIuWFNgo^ĂB
 * processFinal() ς݂ł̂ŁAI[o[Chꍇ͒ӂĉB
 * @version 1.00
 * @since 2008/08/08
 * @author Masatoshi Tsuge
 */
class GgafDepositoryFormation : public GgafFormation {

public:
    /** [r]ґvfƂĊǗĂAN^[̃Xg */
    GgafCore::GgafLinkedListRing<GgafActor> _listFollower;
    bool _can_call_up;
    /** [r]\o[̃XgbJ[inullptȑꍇ\o[͔zAN^[̂͂j */
    GgafCore::GgafActorDepository* _pDepo;

public:
    /**
     * RXgN^ .
     * @param prm_name
     * @param prm_offset_frames_end tH[[VI̗P\t[
     * @return
     */
    GgafDepositoryFormation(const char* prm_name, frame prm_offset_frames_end);

    /**
     * ґ\o[XgbNꂽf|Wgݒ肷 .
     * o[ɂ́Ap\bh callUpMember() gpB
     * o[ÍAsayonara() gpB
     * @param prm_pDepo
     */
    void setFormationMember(GgafCore::GgafActorDepository* prm_pDepo);

    /**
     * ґo[SĔ񊈓Ȃ΁A{tH[[VIuWFNg .
     * \o[S sayonara() ŁAf|Wgɖ߂ꍇA
     * {tH[[VIuWFNg悤ɂ邽߂̎dg݂B
     * ʂ processFinal() ̏Kvȏꍇ́A
     * I[o[ChāȀł̉
     * <code>
     * GgafTreeFormation::processFinal();
     * </code>
     * ĂяoĂA
     */
    virtual void processFinal() override;

    /**
     * f|WgAN^[{tH[[Vo[ƂĐݒ肵擾iWj .
     * setFormationMembersitory() ̎OsKvB<BR>
     * {\bhĂяoƁAf|WgɊǗꂽo[ dispatch() ܂B( activate() )
     * f|Wg̃o[ׂĊŁA͊Ăꍇ nullptr Ԃ܂B<BR>
     * ܂A prm_formation_sub_num ͍őґ\vŁA̐ȏ̌Ăяoł nullptr Ԃ܂B<BR>
     * xł nullptr ԂƁAtO _can_call_up  false ɂȂAȍ~{tH[[VIuWFNg
     * o[ĂяołȂ悤ɂȂ܂BƓ(_can_call_up==false󂯂)processFinal() ł́A
     * SĂ̕ґo[񊈓A{tH[[VIuWFNgI sayonara(_offset_frames_end) s悤ɂȂ܂B<BR>
     * yn}Pz[ callUpMember ĂяoŁAf|WgXgbN͊ɂAȂnullptrԂꍇA
     * _can_call_up = false ɂȂ܂BāA{tH[[VIuWFNǵAȂ sayonara(_offset_frames_end) sIB
     * ƂɂȂ܂B\o[mۂłȂꍇlĉB<BR>
     * yn}QzcallUpMember() Ď擾o[ sayonara() (Iɂinactive()) 邱ƂɂAґ痣EƂɂȂ܂B
     * ]āAcallUpMember() o[Ainactive() āAꎞۗLmۂ邱Ƃ́ȀuԂɕґ痣EƓӂɂȂ܂̂ŁA
     * ł܂B̂悤ɂꍇ GgafTreeFormation g܂B<BR>
     * @param prm_formation_sub_num {tH[[V̍őґ\v
     * @return ґ\ṽAN^[B
     *         őґ\vI[o[ČĂяoꍇA
     *         f|Wgɍ\vȂꍇ nullptr
     */
    GgafActor* callUpMember(int prm_formation_sub_num = INT_MAX);

    /**
     * ܂Aґmۂs\ŁAcallUpMember() ]n邩ǂB .
     * @return trueF]n^falseF]nȂ
     */
    bool canCallUp();

    /**
     * o[cĂΉ܂B
     * păI[o[Chꍇ́A
     * GgafDepositoryFormation::onEnd() ĂяoĉB
     */
    virtual void onEnd() override;

    /**
     * f|Wg[hǗ̕ґSĂ sayonara() sB
     */
    virtual void sayonaraFollwer();

    /**
     * ґɏAN^[SĂȂ(sayonara()Ăяoꂽ)ꍇR[obN郁\bh .
     * KvɉĉʂŃI[o[ChĉB
     */
    virtual void onSayonaraAll() override {
    }

    virtual ~GgafDepositoryFormation();
};

}
#endif /*GGAFCORE_GGAFDEPOSITORYFORMATION_H_*/
