#ifndef GGAFCORE_GGAFXPM_H_
#define GGAFCORE_GGAFXPM_H_
#include "jp/ggaf/core/GgafObject.h"

#include <map>
#include <vector>

namespace GgafCore {

/**
 * ȈXPM(Pixmap)xNX .
 * @version 1.00
 * @since 2013/07/16
 * @author Masatoshi Tsuge
 */
class GgafXpm : public GgafCore::GgafObject {
public:
    /** [r]sNZ */
    int _width;
    /** [r]sNZ */
    int _height;
    /** [r]F */
    int _colors;
    /** [r]Fł͖sNZ̐ */
    int _num_color_pixels;
    /** [r]sNZ̕ */
    char _c_px_non;

    int _char_on_pixel;

    /** [r]sNZF̔̕z */
    std::vector<char> _vecColorChar;
    /** [r]sNZF̕ɑΉAۂRGBl */
    std::map<char, GgafCore::GgafRgb*> _mapCharRgb;
    const char** _xpm_hd;
    const char** _pixels;
public:
    /**
     * RXgN^ .
     * @param prm_xpm Pixmapւ̃|C^BlێȂ̂ŃXR[vɒӁB(static Ȃǂz)
     */
    GgafXpm(const char** prm_xpm);

    /**
     * Pixmap̗񐔂擾 .
     * @return 
     */
    inline int getWidth() {
        return _width;
    }

    /**
     * Pixmap̍s擾 .
     * @return s
     */
    inline int getHeight() {
        return _height;
    }

    /**
     * Pixmap̂ĂF̐擾 .
     * @return F̐
     */
    inline int getColorNum() {
        return _colors;
    }

    /**
     * Pixmap̃sNZ̐(F)擾 .
     * @return
     */
    inline int getPixelNum() {
        return _num_color_pixels;
    }

    /**
     * Pixmap̎w̃sNZ̐F擾 .
     * @param prm_row sڂw
     * @param prm_col ڂw
     * @return F
     */
    inline GgafCore::GgafRgb* getColor(int prm_row, int prm_col) {
        return _mapCharRgb[_pixels[prm_row][prm_col]];
    }

    /**
     * Pixmap̎w̃sNZ̐FFۂ擾 .
     * @param prm_row sڂw
     * @param prm_col ڂw
     * @return true:F / false:FȊO
     */
    inline bool isNonColor(int prm_row, int prm_col) {
        if (_pixels[prm_row][prm_col] == _c_px_non) {
            return true;
        } else {
            return false;
        }
    }

    virtual ~GgafXpm();
};
}
#endif /*GGAFCORE_GGAFXPM_H_*/
