package jp.sourceforge.pdt_tools.variables;

import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class SelectedLineUtil {

	protected static ITextSelection getTextSelection() {
		IWorkbenchWindow window = PlatformUI.getWorkbench()
				.getActiveWorkbenchWindow();
		if (window != null) {
			IWorkbenchPage page = window.getActivePage();
			if (page != null) {
				IEditorPart part = page.getActiveEditor();
				if (part != null) {
					IEditorSite site = part.getEditorSite();
					if (site != null) {
						ISelectionProvider selectionProvider = site
								.getSelectionProvider();
						if (selectionProvider != null) {
							ISelection selection = selectionProvider
									.getSelection();
							if (selection instanceof ITextSelection) {
								return (ITextSelection) selection;
							}
						}
					}
				}
			}
		}
		return null;
	}

}
