package jp.sourceforge.pdt_tools.debug.starter.handlers;

import jp.sourceforge.pdt_tools.debug.starter.Activator;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.State;
import org.eclipse.php.internal.debug.daemon.DaemonPlugin;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.handlers.RegistryToggleState;

@SuppressWarnings("restriction")
public class ToggleDebugDaemon extends AbstractHandler {

	public ToggleDebugDaemon() {
	}

	public Object execute(ExecutionEvent event) throws ExecutionException {
		Command command = event.getCommand();
		State state = command.getState(RegistryToggleState.STATE_ID);
		if (state == null) {
			state = new State();
			state.setValue(Boolean.TRUE);
			command.addState(RegistryToggleState.STATE_ID, state);
		}
		if (HandlerUtil.toggleCommandState(command)) {
			DaemonPlugin.getDefault().stopDaemons(null);
			Activator.setStarted(false);
		} else {
			if (!Activator.isStarted()) {
				DaemonPlugin.getDefault().startDaemons(null);
				Activator.setStarted(true);
			}
		}
		return null;
	}

}
