#ifndef THLCDOUTPUT_H
#define THLCDOUTPUT_H

#define DAQDRIVER_INSTALLED 1

#if DAQDRIVER_INSTALLED
#include <NIDAQmxBase.h>
#endif

#include <QThread>
#include <QQueue>

typedef struct StEventData {
    int id; // Event ID
    QString param; // param data, LCD output string
} EventData;

class ThLCDOutput : public QThread
{
    Q_OBJECT
public:
    explicit ThLCDOutput(QObject *parent = 0);
    ~ThLCDOutput();
    void stop();

    void sendEvent_Init();
    void sendEvent_Clear();
    void sendEvent_OutputText(QString text);

signals:
    void notify_dio_ready(int status); // dio ready signal.

public slots:

protected:
    void run();

private:
    volatile bool stopped;

    // Event ID
    enum {
        Ev_Nop = 0,
        Ev_Init,
        Ev_Clear,
        Ev_OutputString
    };
    QQueue<EventData> *EvtQue; // EventQueue

#if DAQDRIVER_INSTALLED
    TaskHandle taskHandle;
#endif

    int dio_init();
    int dio_write(unsigned char data);
    void dio_final();

    int lcd_output(unsigned char d, unsigned char rs);
    int lcd_init();
    void lcd_clear();
    void lcd_locate(unsigned char line, unsigned char col);
    void lcd_putchar(unsigned char d);
    void lcd_putstr(unsigned char *str);

};

#endif // THLCDOUTPUT_H
