#include "mainwindow.h"
#include "ui_mainwindow.h"

#include <QDebug>

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);

    ThLCDOut = new ThLCDOutput(this);
    ThLCDOut->start();
}

MainWindow::~MainWindow()
{
    ThLCDOut->stop();
    ThLCDOut->wait();
    delete ThLCDOut;

    delete ui;
}

void MainWindow::on_pushButton_Enter_clicked()
{
    if (ui->lineEdit_LCDOutputText->text().isEmpty()) {
        ;
    } else {
        // enq command SetOutputText
        qDebug() << "Send Text is " << ui->lineEdit_LCDOutputText->text();
        ThLCDOut->sendEvent_OutputText(ui->lineEdit_LCDOutputText->text());
    }
}

void MainWindow::on_pushButton_Clear_clicked()
{
    ThLCDOut->sendEvent_Clear();
}
