#ifndef SAVEDATATHREAD_H
#define SAVEDATATHREAD_H

#include <QThread>
#include <QQueue>

class SaveDataThread : public QThread
{
    Q_OBJECT
public:
    explicit SaveDataThread(QObject *parent = 0);
    ~SaveDataThread();
    void stop();

signals:


public slots:


protected:
    void run();

private:
    volatile bool stopped;

    // State Machine, state Id
    enum { State_IDLE = 0,
           State_EXEC // SaveData Executing
         } state;
    // State Machine, event Id
    enum { Ev_Nop = 0,
           Ev_Save_Start, // start SaveData to File
           Ev_Save_Stop   // stop  SaveData to File
         };

    QQueue<int> *EvtQue; // EventQue
};

#endif // SAVEDATATHREAD_H
