#ifndef DAQTHREAD_H
#define DAQTHREAD_H

#include <QThread>
#include <QQueue>
#include <QString>

#include "NIDAQmxBase.h"

class DAQThread : public QThread
{
    Q_OBJECT
public:
    explicit DAQThread(QObject *parent = 0);
    ~DAQThread();
    void stop();

    void startAIAcq();
    void stopAIAcq();

public slots:

signals:
    void daqmxbase_ready();
    void daqmxbase_final();
    void daqmxbase_error(QString errmsg);

protected:
    void run();

private:
    volatile bool stopped;

    TaskHandle  taskHandle; // Daqmxbase task handle

    // State Machine, state Id
    enum { State_IDLE = 0,
           State_EXEC // AI Acquisition
         } state;
    // State Machine, event Id
    enum { Ev_Nop = 0,
           Ev_AI_Start, // start AI Acquisition
           Ev_AI_Stop   // stop  AI Acquisition
         };

    QQueue<int> *EvtQue; // EventQue
};

#endif // DAQTHREAD_H
