#ifndef SAPPHIER_LISP_INTERPRETER_IO_H
#define SAPPHIER_LISP_INTERPRETER_IO_H

/* Copyright (c) 2020 AlaskanEmily
 *
 * This software is provided 'as-is', without any express or implied warranty.
 * In no event will the authors be held liable for any damages arising from
 * the use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not
 *   claim that you wrote the original software. If you use this software in a
 *   product, an acknowledgment in the product documentation would be
 *   appreciated but is not required.
 * 2. Altered source versions must be plainly marked as such, and must not be
 *   misrepresented as being the original software.
 * 3. This notice may not be removed or altered from any source distribution.
 */

/*****************************************************************************/
/*
 * SL_I_RUNTIME_LIBC_DECL and SL_I_RUNTIME_LIBC_SETUP can be used to get the
 * file functions for libc easily.
 * See also SL_I_RUNTIME_NULL_DECL and SL_I_RUNTIME_NULL_SETUP.
 */
#define SL_I_RUNTIME_LIBC_DECL \
SL_S_FUNC(void) *SL_I_OpenReadC(const char *path) { \
    return fopen(path, "rb"); \
} \
SL_S_FUNC(void) *SL_I_OpenWriteC(const char *path) { \
    return fopen(path, "wb"); \
} \
SL_S_FUNC(unsigned) SL_I_ReadC(void *file, void *to, unsigned len) { \
    return fread(to, 1, len, (FILE*)file); \
} \
SL_S_FUNC(unsigned) SL_I_WriteC(void *file, const void *from, unsigned len) { \
    return fwrite(from, 1, len, (FILE*)file); \
} \
SL_S_FUNC(void) SL_I_SeekCurC(void *file, int i) { \
    fseek((FILE*)file, i, SEEK_CUR); \
} \
SL_S_FUNC(void) SL_I_SeekSetC(void *file, int i) { \
    fseek((FILE*)file, i, SEEK_SET); \
} \
SL_S_FUNC(int) SL_I_IsEOFC(void *file) { \
    return feof((FILE*)file); \
} \
SL_S_FUNC(void) SL_I_CloseC(void *file) { \
    fclose((FILE*)file); \
}

#define SL_I_RUNTIME_LIBC_SETUP(OPS) do{ \
    (OPS)->x_stdin = stdin; \
    (OPS)->x_stdout = stdout; \
    (OPS)->x_stderr = stderr; \
    (OPS)->open_read = SL_I_OpenReadC; \
    (OPS)->open_write = SL_I_OpenReadC; \
    (OPS)->read = SL_I_ReadC; \
    (OPS)->write = SL_I_WriteC; \
    (OPS)->seek_cur = SL_I_SeekCurC; \
    (OPS)->seek_set = SL_I_SeekSetC; \
    (OPS)->is_eof = SL_I_IsEOFC; \
    (OPS)->close = SL_I_CloseC; \
}while(0)

/*****************************************************************************/
/* Totally dummies out the IO system of the runtime. */
#define SL_I_RUNTIME_NULL_DECL \
SL_S_FUNC(void) *SL_I_OpenNULL(const char *path) { \
    (void)path; \
    return (void*)0; \
} \
SL_S_FUNC(unsigned) SL_I_ReadNULL(void *file, void *to, unsigned len) { \
    (void)file; (void)to; (void)len; \
    return 0; \
} \
SL_S_FUNC(unsigned) SL_I_WriteNULL(void *file, \
    const void *from, \
    unsigned len) { \
     \
    (void)file; (void)from; (void)len; \
    return 0; \
} \
SL_S_FUNC(void) SL_I_SeekCurNULL(void *file, int i) { \
    (void)file; (void)i; \
} \
SL_S_FUNC(void) SL_I_SeekSetNULL(void *file, int i) { \
    (void)file; (void)i; \
} \
SL_S_FUNC(int) SL_I_IsEOFNULL(void *file) { \
    return 1; \
} \
SL_S_FUNC(void) SL_I_CloseNULL(void *file) { \
    (void)file; \
}

#define SL_I_OpenReadNULL SL_I_OpenNULL
#define SL_I_OpenWriteNULL SL_I_OpenNULL

#define SL_I_RUNTIME_NULL_SETUP(OPS) do{ \
    (OPS)->stdin = (void*)0; \
    (OPS)->stdout = (void*)0; \
    (OPS)->stderr = (void*)0; \
    (OPS)->open_read = SL_I_OpenReadNULL; \
    (OPS)->open_write = SL_I_OpenWriteNULL; \
    (OPS)->read = SL_I_ReadNULL; \
    (OPS)->write = SL_I_WriteNULL; \
    (OPS)->seek_cur = SL_I_SeekCurNULL; \
    (OPS)->seek_set = SL_I_SeekSetNULL; \
    (OPS)->close = SL_I_CloseNULL; \
}while(0)

/*****************************************************************************/

#endif /* SAPPHIER_LISP_INTERPRETER_IO_H */
