/* Copyright (c) 2020 AlaskanEmily
 *
 * This software is provided 'as-is', without any express or implied warranty.
 * In no event will the authors be held liable for any damages arising from
 * the use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not
 *   claim that you wrote the original software. If you use this software in a
 *   product, an acknowledgment in the product documentation would be
 *   appreciated but is not required.
 * 2. Altered source versions must be plainly marked as such, and must not be
 *   misrepresented as being the original software.
 * 3. This notice may not be removed or altered from any source distribution.
 */

#include "sl_s.h"
#include "sl_s_parse.h"
#include "sl_i.h"
#include "sl_x.h"
#include "sl_x_io.h"

#include <string.h>
#include <stdio.h>

SL_I_RUNTIME_LIBC_DECL

int main(int argc, char *argv[]){
    struct SL_I_Runtime rt;
    struct SL_S_Atom path, *src;
    struct SL_S_List *code, **dest;
    void *data;
    unsigned i;
    if(argc < 2){
        fputs("Usage: sli <script>\n", stderr);
        return 1;
    }
    
    path.ref = ~(sl_s_ref_t)0;
    path.len = strlen(argv[1]);
    path.text = argv[1];
    
    SL_I_RUNTIME_LIBC_SETUP(&(rt.io));
    SL_I_InitRuntime(&rt);
    
    src = SL_X_BufferFile(&(rt.io), &path);
    if(src == SL_S_NIL){
        fputs("Could not open file ", stderr);
        fputs(path.text, stderr);
        fputc('\n', stderr);
        return 1;
    }
    
    dest = &code;
    i = 0;
    if(SL_S_PARSE(src, &i, &data) != 0)
        return 0;
    do{
        if(SL_S_IS_LIST(data)){
            *dest = SL_S_Malloc(sizeof(struct SL_S_List));
            (*dest)->head = data;
            dest = &((*dest)->tail);
        }
    }while(SL_S_PARSE(src, &i, &data) == 0);
    
    *dest = SL_S_NIL;
    SL_I_Run(&rt, code);
    if(rt.pending_error){
        fputs(rt.pending_error, stderr);
        fputc('\n', stderr);
        if(rt.error_free_ptr != SL_S_NIL)
            SL_S_Free(rt.error_free_ptr);
        return 1;
    }
    else{
        return 0;
    }
}
