#ifndef SAPPHIRE_LISP_INTERPRETER_BUILTIN_H
#define SAPPHIRE_LISP_INTERPRETER_BUILTIN_H

/* Copyright (c) 2020 AlaskanEmily
 *
 * This software is provided 'as-is', without any express or implied warranty.
 * In no event will the authors be held liable for any damages arising from
 * the use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not
 *   claim that you wrote the original software. If you use this software in a
 *   product, an acknowledgment in the product documentation would be
 *   appreciated but is not required.
 * 2. Altered source versions must be plainly marked as such, and must not be
 *   misrepresented as being the original software.
 * 3. This notice may not be removed or altered from any source distribution.
 */

#include "sl_i_builtin.h"

#include "sl_s.h"

/*****************************************************************************/

#ifdef __cplusplus
extern "C"{
#endif

/*****************************************************************************/

struct SL_I_Runtime;

/*****************************************************************************/

const extern struct SL_S_Atom sl_i_print_name;
SL_S_FUNC(void) *SL_I_Print(struct SL_I_Runtime *rt,
    const struct SL_S_List *args);

/*****************************************************************************/

const extern struct SL_S_Atom sl_i_atom_length_name;
SL_S_FUNC(void) *SL_I_AtomLength(struct SL_I_Runtime *rt,
    const struct SL_S_List *args);

/*****************************************************************************/

const extern struct SL_S_Atom sl_i_open_name;
SL_S_FUNC(void) *SL_I_Open(struct SL_I_Runtime *rt,
    const struct SL_S_List *args);

/*****************************************************************************/

const extern struct SL_S_Atom sl_i_close_name;
SL_S_FUNC(void) *SL_I_Close(struct SL_I_Runtime *rt,
    const struct SL_S_List *args);

/*****************************************************************************/

const extern struct SL_S_Atom sl_i_read_name;
SL_S_FUNC(void) *SL_I_Read(struct SL_I_Runtime *rt,
    const struct SL_S_List *args);

/*****************************************************************************/

const extern struct SL_S_Atom sl_i_write_name;
SL_S_FUNC(void) *SL_I_Write(struct SL_I_Runtime *rt,
    const struct SL_S_List *args);

/*****************************************************************************/

const extern struct SL_S_Atom sl_i_write_atom_name;
SL_S_FUNC(void) *SL_I_WriteAtom(struct SL_I_Runtime *rt,
    const struct SL_S_List *args);

/*****************************************************************************/

#ifdef __cplusplus
} // extern "C"
#endif

/*****************************************************************************/

#endif /* SAPPHIRE_LISP_INTERPRETER_BUILTIN_H */

