#ifndef SAPPHIER_LISP_INTERPRETER_H
#define SAPPHIER_LISP_INTERPRETER_H

/* Copyright (c) 2020 AlaskanEmily
 *
 * This software is provided 'as-is', without any express or implied warranty.
 * In no event will the authors be held liable for any damages arising from
 * the use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not
 *   claim that you wrote the original software. If you use this software in a
 *   product, an acknowledgment in the product documentation would be
 *   appreciated but is not required.
 * 2. Altered source versions must be plainly marked as such, and must not be
 *   misrepresented as being the original software.
 * 3. This notice may not be removed or altered from any source distribution.
 */

#include "sl_s.h"
#include "sl_x.h"

/*****************************************************************************/

#ifdef __cplusplus
extern "C"{
#endif

/*****************************************************************************/

struct SL_I_Runtime;

/*****************************************************************************/

#define SL_I_VARIADIC (~(sl_s_len_t)0)

/*****************************************************************************/

struct SL_I_Bind{
    const struct SL_S_Atom *name;
    const struct SL_S_Atom *hint;
    union {
        SL_S_FUNC_PTR(void*, native)(
            struct SL_I_Runtime *rt,
            const struct SL_S_List *args);
        const struct SL_S_List *lisp;
    } bind;
    sl_s_len_t arity;
    struct SL_X_FuncArg *args;
    unsigned char is_native;
};

/*****************************************************************************/

struct SL_I_Frame{
    struct SL_X_Def *defs;
    sl_s_len_t num_defs;
    sl_s_len_t cap_defs;
    struct SL_I_Frame *next;
};

/*****************************************************************************/

struct SL_I_Runtime{
    /* NULL-terminated. */
    const char **import_paths;
    struct SL_I_Bind *binds;
    sl_s_len_t num_binds;
    sl_s_len_t cap_binds;
    struct SL_X_Record *recs;
    sl_s_len_t num_recs;
    sl_s_len_t cap_recs;
    struct SL_X_ProtocolType *protocols;
    sl_s_len_t num_protocols;
    sl_s_len_t cap_protocols;
    struct SL_I_Frame global, *frames;
    const char *pending_error;
    void *error_free_ptr;
    
    /* Handled specially. */
    struct SL_S_Pointer stdin_ptr, stdout_ptr, stderr_ptr;
    struct SL_X_FileOps io;
};

/*****************************************************************************/

SL_S_FUNC(void) SL_I_InitRuntime(struct SL_I_Runtime *rt);

/*****************************************************************************/
/* Executes a script at top-level. */
SL_S_FUNC(int) SL_I_Run(struct SL_I_Runtime *rt, const struct SL_S_List *code);

/*****************************************************************************/
/* The result must be DECREF'ed.
 * If opt_out_hint is not SL_S_NIL, then the return-type hint (if one exists)
 * will be placed into the destination.
 */
SL_S_FUNC(void) *SL_I_Execute(struct SL_I_Runtime *rt,
    const void *value,
    const struct SL_S_Atom **opt_out_hint);

/*****************************************************************************/
/* Args reversed form of SL_I_Execute. */
SL_S_FUNC(void) *SL_I_Execute2(const void *value, void *rt);

/*****************************************************************************/
/* Executes a bind. This will NOT reduce its arguments.
 * The result must be DECREF'ed
 */
SL_S_FUNC(void) *SL_I_Call(struct SL_I_Runtime *rt,
    const struct SL_I_Bind *bind,
    const struct SL_S_List *args);

/*****************************************************************************/

#ifdef __cplusplus
} // extern "C"
#endif

/*****************************************************************************/

#endif /* SAPPHIER_LISP_INTERPRETER_H */
