# Any copyright of this file is dedicated to the Public Domain.
# http://creativecommons.org/publicdomain/zero/1.0/

all: libsl_s.a sli

TESTERS=test_sl_s_parse test_sl_s

check: check_build
	for TESTER in $(TESTERS) ; do "./$$TESTER" ; done

check_build: $(TESTERS)

# sl_s_parse tester
test_sl_s_parse.o: test_sl_s_parse.c sl_s_parse.h sl_s.h yyy_test.h
	$(CC) $(CFLAGS) $(COMPILEFLAG) test_sl_s_parse.c $(COUT)test_sl_s_parse.o

test_sl_s_parse: test_sl_s_parse.o libsl_s.a
	$(LD) $(LDFLAGS) test_sl_s_parse.o libsl_s.a $(LDOUT)test_sl_s_parse

# sl_s tester
test_sl_s.o: test_sl_s.c test_memcpy.c sl_s_parse.h sl_s.h yyy_test.h
	$(CC) $(CFLAGS) $(COMPILEFLAG) test_sl_s.c $(COUT)test_sl_s.o

test_sl_s: test_sl_s.o libsl_s.a
	$(LD) $(LDFLAGS) test_sl_s.o libsl_s.a $(LDOUT)test_sl_s

# Library
OBJECTS=sl_s.o sl_s_parse.o

sl_s.o: sl_s.c sl_s.h
	$(CC) $(CFLAGS) $(COMPILEFLAG) sl_s.c $(COUT)sl_s.o

sl_s_parse.o: sl_s_parse.c sl_s_parse.h sl_s.h
	$(CC) $(CFLAGS) $(COMPILEFLAG) sl_s_parse.c $(COUT)sl_s_parse.o

libsl_s.a: $(OBJECTS)
	$(AR) $(ARFLAGS) $(AROUT)libsl_s.a $(OBJECTS)
	if test ! -z '$(RANLIB)' ; then $(RANLIB) $(RANLIBFLAGS) libsl_s.a ; fi

# Kinda janky.
relink:
	$(AR) $(ARFLAGS) $(AROUT)libsl_s.a $(OBJECTS)
	if test ! -z '$(RANLIB)' ; then $(RANLIB) $(RANLIBFLAGS) libsl_s.a ; fi

IOBJECTS=sl_i.o sl_i_builtin.o sl_x.o sl_i_main.o

sl_x.o: sl_x.c sl_x.h sl_s.h
	$(CC) $(CFLAGS) $(COMPILEFLAG) sl_x.c $(COUT)sl_x.o

sl_i.o: sl_i.c sl_i.h sl_x.h sl_s.h
	$(CC) $(CFLAGS) $(COMPILEFLAG) sl_i.c $(COUT)sl_i.o

sl_i_builtin.o: sl_i_builtin.c sl_i_builtin.h sl_i.h sl_s.h
	$(CC) $(CFLAGS) $(COMPILEFLAG) sl_i_builtin.c $(COUT)sl_i_builtin.o

sl_i_main.o: sl_i_main.c sl_i.h sl_s.h sl_s_parse.h sl_x.h sl_x_io.h
	$(CC) $(CFLAGS) $(COMPILEFLAG) sl_i_main.c $(COUT)sl_i_main.o

sli: $(IOBJECTS) libsl_s.a
	$(LD) $(LDFLAGS) $(IOBJECTS) libsl_s.a $(LDOUT)sli

clean:
	rm *.a *.o $(TESTERS) sli slc
