#============================================================================================================
#
#	t@C샆[eBeBW[
#
#============================================================================================================
package	EARENDIL;

use strict;
use warnings;

#------------------------------------------------------------------------------------------------------------
#
#	t@CRs[
#	-------------------------------------------------------------------------------------
#	@param	$src	Rs[t@CpX
#	@param	$dst	Rs[t@CpX
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub Copy
{
	my ($src, $dst) = @_;
	
	if (open(my $fh_s, '<', $src) && open(my $fh_d, (-f $dst ? '+<' : '>'), $dst)) {
		flock($fh_s, 2);
		flock($fh_d, 2);
		seek($fh_d, 0, 0);
		binmode($fh_s);
		binmode($fh_d);
		print $fh_d (<$fh_s>);
		truncate($fh_d, tell($fh_d));
		close($fh_s);
		close($fh_d);
		
		# p[~bVݒ
		chmod((stat $src)[2], $dst);
		return 1;
	}
	
	return 0;
}

#------------------------------------------------------------------------------------------------------------
#
#	t@Cړ
#	-------------------------------------------------------------------------------------
#	@param	$src	ړt@CpX
#	@param	$dst	ړt@CpX
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub Move
{
	my ($src, $dst) = @_;
	
	if (Copy($src, $dst)) {
		unlink $src;	# Rs[폜
	}
}

#------------------------------------------------------------------------------------------------------------
#
#	fBNgċA폜
#	-------------------------------------------------------------------------------------
#	@param	$path	폜pX
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub DeleteDirectory
{
	my ($path) = @_;
	
	# t@C擾
	my %fileList = ();
	GetFileInfoList($path, \%fileList);
	
	foreach my $file (keys %fileList) {
		if ($file ne '.' && $file ne '..') {
			my (undef, undef, $attr) = split(/<>/, $fileList{$file}, -1);
			if ($attr & 1) {						# fBNgȂ
				DeleteDirectory("$path/$file");		# ċAĂяo
			}
			else {									# t@CȂ
				unlink "$path/$file";				# ̂܂܍폜
			}
		}
	}
	rmdir $path;
}

#------------------------------------------------------------------------------------------------------------
#
#	t@Cꗗ擾
#	-------------------------------------------------------------------------------------
#	@param	$Path	ꗗ擾pX
#	@param	$pList	ꗗi[nbV̎Q
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub GetFileInfoList
{
	my ($Path, $pList) = @_;
	
	my @arFiles = ();
	if (opendir(my $dh, $Path)) {
		@arFiles = readdir($dh);
		closedir($dh);
	}
	
	# fBNg̑St@C𑖍
	foreach my $file (@arFiles) {
		my $Full = "$Path/$file";
		my $Attr = 0;
		my $Size = -s $Full;									# TCY擾
		my $Perm = substr(sprintf('%o', (stat $Full)[2]), -4);	# p[~bV擾
		$Attr |= 1 if (-d $Full);								# fBNgH
		$Attr |= 2 if (-T $Full);								# eLXgt@CH
		$pList->{$file} = "$Size<>$Perm<>$Attr";
	}
}

#------------------------------------------------------------------------------------------------------------
#
#	wt@Cꗗ擾
#	-------------------------------------------------------------------------------------
#	@param	$path	ꗗ擾pX
#	@param	$pList	ꗗi[z̎Q
#	@param	$opt	oIvV(K\)
#	@return	t@C
#
#------------------------------------------------------------------------------------------------------------
sub GetFileList
{
	my ($path, $pList, $opt) = @_;
	
	my @files = ();
	if (opendir(my $dh, $path)) {
		@files = readdir($dh);
		closedir($dh);
	}
	
	my $num = 0;
	foreach my $file (@files) {
		# fBNgȂovzɃvbV
		if (! -d "$path/$file") {
			if ($file =~ /$opt/) { # $opt͐K\
				push @$pList, $file;
				$num++;
			}
		}
	}
	return $num;
}

#------------------------------------------------------------------------------------------------------------
#
#	fBNg쐬
#	-------------------------------------------------------------------------------------
#	@param	$path	쐬pX
#	@param	$perm	fBNg̃p[~bV
#	@return	쐬ɐ1Ԃ
#
#------------------------------------------------------------------------------------------------------------
sub CreateDirectory
{
	my ($path, $perm) = @_;
	
	if (! -e $path) {
		return mkdir($path, $perm);
	}
	return 0;
}

#-------------------------------------------------------------------------------------------------------------
#
#	fBNg쐬
#	------------------------------------------------------------------
#	@param	$path	pX
#	@return	Ȃ
#
#-------------------------------------------------------------------------------------------------------------
sub CreateFolderHierarchy
{
	my ($path, $perm) = @_;
	
	while (1) {
		if (-d $path) {
			return;
		}
		else {
			if (mkdir($path, $perm)) {
				return;
			}
			# fBNg쐬s͍ċAI1̊Kw쐬
			else {
				my $upath = $path;
				$upath =~ s|[\\\/][^\\\/]*$||;
				CreateFolderHierarchy($upath, $perm);
			}
		}
	}
}

#------------------------------------------------------------------------------------------------------------
#
#	fBNg
#	-------------------------------------------------------------------------------------
#	@param	$path	pX
#	@param	$pHash	ʊi[pnbV
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub GetFolderHierarchy
{
	my ($path, $pHash) = @_;
	
	my @elements = ();
	if (opendir(my $dh, $path)) {
		@elements = readdir($dh);
		closedir($dh);
	}
	
	foreach my $elem (sort @elements) {
		# fBNgċAIɒT
		if (-d "$path/$elem" && $elem ne '.' && $elem ne '..') {
			my %folders = ();
			GetFolderHierarchy("$path/$elem", \%folders);
			if (scalar(keys(%folders)) > 0) {
				$pHash->{$elem} = \%folders;
			}
			else {
				$pHash->{$elem} = undef; # don't delete
			}
		}
	}
}

#------------------------------------------------------------------------------------------------------------
#
#	fBNgXg擾
#	GetFolderHierarchyŎ擾nbVfBNgꗗ̔z擾
#	-------------------------------------------------------------------------------------
#	@param	$pHash	GetFolderHierarchyŎ擾nbV
#	@param	$pList	ʊi[pz
#	@param	$base	x[XpX
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub GetFolderList
{
	my ($pHash, $pList, $base) = @_;
	
	foreach my $key (keys %$pHash) {
		push @$pList, "$base/$key";
		if (defined $pHash->{$key}) {
			GetFolderList($pHash->{$key}, $pList, "$base/$key");
		}
	}
}

#============================================================================================================
#	Module END
#============================================================================================================
1;
