#============================================================================================================
#
#	XbhǗW[
#	-------------------------------------------------------------------------------------
#	̃W[̓XbhǗ܂B
#	ȉ2̃pbP[Wɂč\܂
#
#	BILBO	: sXbhǗ
#	FRODO	: v[XbhǗ
#
#============================================================================================================

#============================================================================================================
#
#	XbhǗpbP[W
#
#============================================================================================================
package	BILBO;

use strict;
use warnings;

#------------------------------------------------------------------------------------------------------------
#
#	RXgN^
#	-------------------------------------------------------------------------------------
#	@param	Ȃ
#	@return	W[IuWFNg
#
#------------------------------------------------------------------------------------------------------------
sub new
{
	my $class = shift;
	
	my $obj = {
		'SUBJECT'	=> undef,
		'RES'		=> undef,
		'SORT'		=> undef,
		'NUM'		=> undef,
		'HANDLE'	=> undef,
		'ATTR'		=> undef,
	};
	bless $obj, $class;
	
	return $obj;
}

#------------------------------------------------------------------------------------------------------------
#
#	fXgN^
#	-------------------------------------------------------------------------------------
#	@param	Ȃ
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub DESTROY
{
	my $this = shift;
	
	my $handle = $this->{'HANDLE'};
	if ($handle) {
		close($handle);
	}
	$this->{'HANDLE'} = undef;
}

#------------------------------------------------------------------------------------------------------------
#
#	I[v
#	-------------------------------------------------------------------------------------
#	@param	$Sys	MELKOR
#	@return	t@Cnh
#
#------------------------------------------------------------------------------------------------------------
sub Open
{
	my $this = shift;
	my ($Sys) = @_;
	
	my $path = $Sys->Get('BBSPATH') . '/' .$Sys->Get('BBS') . '/subject.txt';
	my $fh = undef;
	
	if ($this->{'HANDLE'}) {
		$fh = $this->{'HANDLE'};
		seek($fh, 0, 0);
	}
	else {
		chmod($Sys->Get('PM-TXT'), $path);
		if (open($fh, (-f $path ? '+<' : '>'), $path)) {
			flock($fh, 2);
			binmode($fh);
			seek($fh, 0, 0);
			$this->{'HANDLE'} = $fh;
		}
		else {
			warn "can't load subject: $path";
		}
	}
	
	return $fh;
}

#------------------------------------------------------------------------------------------------------------
#
#	N[Y
#	-------------------------------------------------------------------------------------
#	@param	Ȃ
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub Close
{
	my $this = shift;
	
	my $handle = $this->{'HANDLE'};
	if ($handle) {
		close($handle);
	}
	$this->{'HANDLE'} = undef;
}

#------------------------------------------------------------------------------------------------------------
#
#	Xbhǂݍ
#	-------------------------------------------------------------------------------------
#	@param	$Sys	MELKOR
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub Load
{
	my $this = shift;
	my ($Sys) = @_;
	
	$this->{'SUBJECT'} = {};
	$this->{'RES'} = {};
	$this->{'SORT'} = [];
	
	my $fh = $this->Open($Sys) or return;
	my @lines = <$fh>;
	map { s/[\r\n]+\z// } @lines;
	
	my $num = 0;
	foreach (@lines) {
		next if ($_ eq '');
		
		if ($_ =~ /^(.+?)\.dat<>(.*?) ?\(([0-9]+)\)$/) {
			$this->{'SUBJECT'}->{$1} = $2;
			$this->{'RES'}->{$1} = $3;
			push @{$this->{'SORT'}}, $1;
			$num++;
		}
		else {
			warn "invalid line";
			next;
		}
	}
	$this->{'NUM'} = $num;
	
	$this->LoadAttr($Sys);
}

#------------------------------------------------------------------------------------------------------------
#
#	Xbhۑ
#	-------------------------------------------------------------------------------------
#	@param	$Sys	MELKOR
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub Save
{
	my $this = shift;
	my ($Sys) = @_;
	
	my $fh = $this->Open($Sys) or return;
	my $subject = $this->{'SUBJECT'};
	
	$this->CustomizeOrder();
	
	foreach (@{$this->{'SORT'}}) {
		next if (!defined $subject->{$_});
		print $fh "$_.dat<>$subject->{$_} ($this->{'RES'}->{$_})\n";
	}
	
	truncate($fh, tell($fh));
	
	$this->Close();
	my $path = $Sys->Get('BBSPATH') . '/' .$Sys->Get('BBS') . '/subject.txt';
	chmod($Sys->Get('PM-TXT'), $path);
	
	$this->SaveAttr($Sys);
}

#------------------------------------------------------------------------------------------------------------
#
#	If}hXXV
#	-------------------------------------------------------------------------------------
#	@param	$Sys	MELKOR
#	@param	$id		XbhID
#	@param	$val	X
#	@param	$age	ageȂ1
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub OnDemand
{
	my $this = shift;
	my ($Sys, $id, $val, $age) = @_;
	
	my $subject = {};
	$this->{'SUBJECT'} = $subject;
	$this->{'RES'} = {};
	$this->{'SORT'} = [];
	
	my $fh = $this->Open($Sys) or return;
	my @lines = <$fh>;
	map { s/[\r\n]+\z// } @lines;
	
	my $num = 0;
	foreach (@lines) {
		next if ($_ eq '');
		
		if ($_ =~ /^(.+?)\.dat<>(.*?) ?\(([0-9]+)\)$/) {
			$subject->{$1} = $2;
			$this->{'RES'}->{$1} = $3;
			push @{$this->{'SORT'}}, $1;
			$num++;
		}
		else {
			warn "invalid line";
			next;
		}
	}
	$this->{'NUM'} = $num;
	
	# XXV
	if (exists $this->{'RES'}->{$id}) {
		$this->{'RES'}->{$id} = $val;
	}
	
	$this->AGE($id) if ($age);
	$this->CustomizeOrder();
	
	# subject
	seek($fh, 0, 0);
	
	foreach (@{$this->{'SORT'}}) {
		next if (!defined $subject->{$_});
		print $fh "$_.dat<>$subject->{$_} ($this->{'RES'}->{$_})\n";
	}
	
	truncate($fh, tell($fh));
	
	$this->Close();
	my $path = $Sys->Get('BBSPATH') . '/' .$Sys->Get('BBS') . '/subject.txt';
	chmod($Sys->Get('PM-TXT'), $path);
}

#------------------------------------------------------------------------------------------------------------
#
#	XbhIDZbg擾
#	-------------------------------------------------------------------------------------
#	@param	$kind	('ALL'̏ꍇׂ)
#	@param	$name	[h
#	@param	$pBuf	IDZbgi[obt@
#	@return	L[Zbg
#
#------------------------------------------------------------------------------------------------------------
sub GetKeySet
{
	my $this = shift;
	my ($kind, $name, $pBuf) = @_;
	
	my $n = 0;
	
	if ($kind eq 'ALL') {
		$n += push @$pBuf, @{$this->{'SORT'}};
	}
	else {
		foreach my $key (keys %{$this->{$kind}}) {
			if ($this->{$kind}->{$key} eq $name || $kind eq 'ALL') {
				$n += push @$pBuf, $key;
			}
		}
	}
	
	return $n;
}

#------------------------------------------------------------------------------------------------------------
#
#	Xbh擾
#	-------------------------------------------------------------------------------------
#	@param	$kind		
#	@param	$key		XbhID
#	@param	$default	ftHg
#	@return	Xbh
#
#------------------------------------------------------------------------------------------------------------
sub Get
{
	my $this = shift;
	my ($kind, $key, $default) = @_;
	
	my $val = $this->{$kind}->{$key};
	
	return (defined $val ? $val : (defined $default ? $default : undef));
}

#------------------------------------------------------------------------------------------------------------
#
#	Xbhǉ
#	-------------------------------------------------------------------------------------
#	@param	$id			XbhID
#	@param	$subject	Xbh^Cg
#	@param	$res		X
#	@return	XbhID
#
#------------------------------------------------------------------------------------------------------------
sub Add
{
	my $this = shift;
	my ($id, $subject, $res) = @_;
	
	$this->{'SUBJECT'}->{$id} = $subject;
	$this->{'RES'}->{$id} = $res;
	unshift @{$this->{'SORT'}}, $id;
	$this->{'NUM'}++;
	
	return $id;
}

#------------------------------------------------------------------------------------------------------------
#
#	Xbhݒ
#	-------------------------------------------------------------------------------------
#	@param	$id		XbhID
#	@param	$kind	
#	@param	$val	ݒl
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub Set
{
	my $this = shift;
	my ($id, $kind, $val) = @_;
	
	if (exists $this->{$kind}->{$id}) {
		$this->{$kind}->{$id} = $val;
	}
}

#------------------------------------------------------------------------------------------------------------
#
#	Xbh폜
#	-------------------------------------------------------------------------------------
#	@param	$id		폜XbhID
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub Delete
{
	my $this = shift;
	my ($id) = @_;
	
	delete $this->{'SUBJECT'}->{$id};
	delete $this->{'RES'}->{$id};
	# for pool
	#delete $this->{'ATTR'}->{$id};
	
	my $sort = $this->{'SORT'};
	for (my $i = 0; $i < scalar(@$sort); $i++) {
		if ($id eq $sort->[$i]) {
			splice @$sort, $i, 1;
			$this->{'NUM'}--;
			last;
		}
	}
}

#------------------------------------------------------------------------------------------------------------
#
#	Xbhǂݍ
#	-------------------------------------------------------------------------------------
#	@param	$Sys	MELKOR
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub LoadAttr
{
	my $this = shift;
	my ($Sys) = @_;
	
	$this->{'ATTR'} = {};
	
	my $path = $Sys->Get('BBSPATH') . '/' .$Sys->Get('BBS') . '/info/attr.cgi';
	
	if (open(my $fh, '<', $path)) {
		flock($fh, 2);
		my @lines = <$fh>;
		close($fh);
		map { s/[\r\n]+\z// } @lines;
		
		foreach (@lines) {
			next if ($_ eq '');
			
			my @elem = split(/<>/, $_, -1);
			if (scalar(@elem) < 2) {
				warn "invalid line in $path";
				next;
			}
			
			my $id = $elem[0];
			# for pool, don't skip
			#next if (!defined $this->{'SUBJECT'}->{$id});
			
			my $hash = {};
			foreach (split /[&;]/, $elem[1]) {
				my ($key, $val) = split(/=/, $_, 2);
				$key =~ tr/+/ /;
				$key =~ s/%([0-9a-f][0-9a-f])/pack('C', hex($1))/egi;
				$val =~ tr/+/ /;
				$val =~ s/%([0-9a-f][0-9a-f])/pack('C', hex($1))/egi;
				$hash->{$key} = $val if ($val ne '');
			}
			
			$this->{'ATTR'}->{$id} = $hash;
		}
	}
}

#------------------------------------------------------------------------------------------------------------
#
#	Xbhۑ
#	-------------------------------------------------------------------------------------
#	@param	$Sys	MELKOR
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub SaveAttr
{
	my $this = shift;
	my ($Sys) = @_;
	
	my $path = $Sys->Get('BBSPATH') . '/' .$Sys->Get('BBS') . '/info/attr.cgi';
	
	chmod($Sys->Get('PM-ADM'), $path);
	if (open(my $fh, (-f $path ? '+<' : '>'), $path)) {
		flock($fh, 2);
		binmode($fh);
		seek($fh, 0, 0);
		
		my $Attr = $this->{'ATTR'};
		foreach my $id (keys %$Attr) {
			my $hash = $Attr->{$id};
			next if (!defined $hash);
			
			my $attrs = '';
			while (my ($key, $val) = each %$hash) {
				next if (!defined $val || $val eq '');
				$key =~ s/([^\w])/'%'.unpack('H2', $1)/eg;
				$val =~ s/([^\w])/'%'.unpack('H2', $1)/eg;
				$attrs .= "$key=$val&";
			}
			
			next if ($attrs eq '');
			
			my $data = join('<>',
				$id,
				$attrs,
			);
			
			print $fh "$data\n";
		}
		
		truncate($fh, tell($fh));
		close($fh);
	}
	chmod($Sys->Get('PM-ADM'), $path);
}

#------------------------------------------------------------------------------------------------------------
#
#	Xbh擾
#	-------------------------------------------------------------------------------------
#	@param	$key		XbhID
#	@param	$attr		
#	@return	Xbh
#
#------------------------------------------------------------------------------------------------------------
sub GetAttr
{
	my $this = shift;
	my ($key, $attr) = @_;
	
	if (!defined $this->{'ATTR'}) {
		warn "Attr info is not loaded.";
		return;
	}
	my $Attr = $this->{'ATTR'};
	
	my $val = undef;
	$val = $Attr->{$key}->{$attr} if (defined $Attr->{$key});
	
	# undef => empty string
	return (defined $val ? $val : '');
}

#------------------------------------------------------------------------------------------------------------
#
#	Xbhݒ
#	-------------------------------------------------------------------------------------
#	@param	$key		XbhID
#	@param	$attr		
#	@param	$val		l
#
#------------------------------------------------------------------------------------------------------------
sub SetAttr
{
	my $this = shift;
	my ($key, $attr, $val) = @_;
	
	if (!defined $this->{'ATTR'}) {
		warn "Attr info is not loaded.";
		return;
	}
	my $Attr = $this->{'ATTR'};
	
	$Attr->{$key} = {} if (!defined $Attr->{$key});
	$Attr->{$key}->{$attr} = $val;
}

#------------------------------------------------------------------------------------------------------------
#
#	Xbh폜
#	-------------------------------------------------------------------------------------
#	@param	$key		XbhID
#
#------------------------------------------------------------------------------------------------------------
sub DeleteAttr
{
	my $this = shift;
	my ($key) = @_;
	
	if (!defined $this->{'ATTR'}) {
		warn "Attr info is not loaded.";
		return;
	}
	my $Attr = $this->{'ATTR'};
	
	delete $Attr->{$key};
}

#------------------------------------------------------------------------------------------------------------
#
#	Xbh擾
#	-------------------------------------------------------------------------------------
#	@param	Ȃ
#	@return	Xbh
#
#------------------------------------------------------------------------------------------------------------
sub GetNum
{
	my $this = shift;
	
	return $this->{'NUM'};
}

#------------------------------------------------------------------------------------------------------------
#
#	Ō̃XbhID擾
#	-------------------------------------------------------------------------------------
#	@param	Ȃ
#	@return	XbhID
#
#------------------------------------------------------------------------------------------------------------
sub GetLastID
{
	my $this = shift;
	
	my $sort = $this->{'SORT'};
	return $sort->[$#$sort];
}

#------------------------------------------------------------------------------------------------------------
#
#	Xbh
#	-------------------------------------------------------------------------------------
#	@param	Ȃ
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub CustomizeOrder
{
	my $this = shift;
	
	my @float = ();
	my @sort = ();
	
	foreach my $id (@{$this->{'SORT'}}) {
		if ($this->GetAttr($id, 'float')) {
			push @float, $id;
		} else {
			push @sort, $id;
		}
	}
	
	$this->{'SORT'} = [@float, @sort];
}

#------------------------------------------------------------------------------------------------------------
#
#	Xbh
#	-------------------------------------------------------------------------------------
#	@param	XbhID
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub AGE
{
	my $this = shift;
	my ($id) = @_;
	
	my $sort = $this->{'SORT'};
	for (my $i = 0; $i < scalar(@$sort); $i++) {
		if ($id eq $sort->[$i]) {
			splice @$sort, $i, 1;
			unshift @$sort, $id;
			last;
		}
	}
}

#------------------------------------------------------------------------------------------------------------
#
#	Xbh
#	-------------------------------------------------------------------------------------
#	@param	XbhID
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub DAME
{
	my $this = shift;
	my ($id) = @_;
	
	my $sort = $this->{'SORT'};
	for (my $i = 0; $i < scalar(@$sort); $i++) {
		if ($id eq $sort->[$i]) {
			splice @$sort, $i, 1;
			push @$sort, $id;
			last;
		}
	}
}

#------------------------------------------------------------------------------------------------------------
#
#	XbhXV
#	-------------------------------------------------------------------------------------
#	@param	$Sys	MELKOR
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub Update
{
	my $this = shift;
	my ($Sys) = @_;
	
	my $base = $Sys->Get('BBSPATH') . '/' . $Sys->Get('BBS') . '/dat';
	
	$this->CustomizeOrder();
	
	foreach my $id (@{$this->{'SORT'}}) {
		if (open(my $fh, '<', "$base/$id.dat")) {
			flock($fh, 2);
			my $n = 0;
			$n++ while (<$fh>);
			close($fh);
			$this->{'RES'}->{$id} = $n;
		}
		else {
			warn "can't open file: $base/$id.dat";
		}
	}
}

#------------------------------------------------------------------------------------------------------------
#
#	Xbh񊮑SXV
#	-------------------------------------------------------------------------------------
#	@param	$Sys	MELKOR
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub UpdateAll
{
	my $this = shift;
	my ($Sys) = @_;
	
	my $psort = $this->{'SORT'};
	$this->{'SORT'} = [];
	$this->{'SUBJECT'} = {};
	$this->{'RES'} = {};
	my $idhash = {};
	my @dirSet = ();
	
	my $base = $Sys->Get('BBSPATH') . '/' . $Sys->Get('BBS') . '/dat';
	my $num	= 0;
	
	# fBNgꗗ擾
	if (opendir(my $fh, $base)) {
		@dirSet = readdir($fh);
		closedir($fh);
	}
	else {
		warn "can't open dir: $base";
		return;
	}
	
	foreach my $el (@dirSet) {
		if ($el =~ /^(.*)\.dat$/ && open(my $fh, '<', "$base/$el")) {
			flock($fh, 2);
			my $id = $1;
			my $n = 1;
			my $first = <$fh>;
			$n++ while (<$fh>);
			close($fh);
			$first =~ s/[\r\n]+\z//;
			
			my @elem = split(/<>/, $first, -1);
			$this->{'SUBJECT'}->{$id} = $elem[4];
			$this->{'RES'}->{$id} = $n;
			$idhash->{$id} = 1;
			$num++;
		}
	}
	$this->{'NUM'} = $num;
	
	foreach my $id (@$psort) {
		if (defined $idhash->{$id}) {
			push @{$this->{'SORT'}}, $id;
			delete $idhash->{$id};
		}
	}
	foreach my $id (sort keys %$idhash) {
		unshift @{$this->{'SORT'}}, $id;
	}
	
	$this->CustomizeOrder();
}

#------------------------------------------------------------------------------------------------------------
#
#	Xbhʒu擾
#	-------------------------------------------------------------------------------------
#	@param	$id	XbhID
#	@return	XbhʒuB擾łȂꍇ-1
#
#------------------------------------------------------------------------------------------------------------
sub GetPosition
{
	my $this = shift;
	my ($id) = @_;
	
	my $sort = $this->{'SORT'};
	for (my $i = 0; $i < scalar(@$sort); $i++) {
		if ($id eq $sort->[$i]) {
			return $i;
		}
	}
	
	return -1;
}


#============================================================================================================
#
#	v[XbhǗpbP[W
#
#============================================================================================================
package	FRODO;

use strict;
use warnings;

#------------------------------------------------------------------------------------------------------------
#
#	RXgN^
#	-------------------------------------------------------------------------------------
#	@param	Ȃ
#	@return	W[IuWFNg
#
#------------------------------------------------------------------------------------------------------------
sub new
{
	my $class = shift;
	
	my $obj = {
		'SUBJECT'	=> undef,
		'RES'		=> undef,
		'SORT'		=> undef,
		'NUM'		=> undef,
		'ATTR'		=> undef,
	};
	bless $obj, $class;
	
	return $obj;
}

#------------------------------------------------------------------------------------------------------------
#
#	Xbhǂݍ
#	-------------------------------------------------------------------------------------
#	@param	$Sys	MELKOR
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub Load
{
	my $this = shift;
	my ($Sys) = @_;
	
	$this->{'SUBJECT'} = {};
	$this->{'RES'} = {};
	$this->{'SORT'} = [];
	
	my $path = $Sys->Get('BBSPATH') . '/' .$Sys->Get('BBS') . '/pool/subject.cgi';
	
	if (open(my $fh, '<', $path)) {
		flock($fh, 2);
		my @lines = <$fh>;
		close($fh);
		map { s/[\r\n]+\z// } @lines;
		
		my $num = 0;
		for (@lines) {
			next if ($_ eq '');
			
			if ($_ =~ /^(.+?)\.dat<>(.*?) ?\(([0-9]+)\)$/) {
				$this->{'SUBJECT'}->{$1} = $2;
				$this->{'RES'}->{$1} = $3;
				push @{$this->{'SORT'}}, $1;
				$num++;
			}
			else {
				warn "invalid line in $path";
				next;
			}
		}
		$this->{'NUM'} = $num;
	}
	
	$this->LoadAttr($Sys);
}

#------------------------------------------------------------------------------------------------------------
#
#	Xbhۑ
#	-------------------------------------------------------------------------------------
#	@param	$Sys	MELKOR
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub Save
{
	my $this = shift;
	my ($Sys) = @_;
	
	my $path = $Sys->Get('BBSPATH') . '/' .$Sys->Get('BBS') . '/pool/subject.cgi';
	
	chmod($Sys->Get('PM-ADM'), $path);
	if (open(my $fh, (-f $path ? '+<' : '>'), $path)) {
		flock($fh, 2);
		seek($fh, 0, 0);
		binmode($fh);
		
		my $subject = $this->{'SUBJECT'};
		foreach (@{$this->{'SORT'}}) {
			next if (!defined $subject->{$_});
			print $fh "$_.dat<>$subject->{$_} ($this->{'RES'}->{$_})\n";
		}
		
		truncate($fh, tell($fh));
		close($fh);
	}
	else {
		warn "can't save subject: $path";
	}
	chmod($Sys->Get('PM-ADM'), $path);
	
	$this->SaveAttr($Sys);
}

#------------------------------------------------------------------------------------------------------------
#
#	XbhIDZbg擾
#	-------------------------------------------------------------------------------------
#	@param	$kind	('ALL'̏ꍇׂ)
#	@param	$name	[h
#	@param	$pBuf	IDZbgi[obt@
#	@return	L[Zbg
#
#------------------------------------------------------------------------------------------------------------
sub GetKeySet
{
	my $this = shift;
	my ($kind, $name, $pBuf) = @_;
	
	my $n = 0;
	
	if ($kind eq 'ALL') {
		$n += push @$pBuf, @{$this->{'SORT'}};
	}
	else {
		foreach my $key (keys %{$this->{$kind}}) {
			if ($this->{$kind}->{$key} eq $name || $kind eq 'ALL') {
				$n += push @$pBuf, $key;
			}
		}
	}
	
	return $n;
}

#------------------------------------------------------------------------------------------------------------
#
#	Xbh擾
#	-------------------------------------------------------------------------------------
#	@param	$kind		
#	@param	$key		XbhID
#	@param	$default	ftHg
#	@return	Xbh
#
#------------------------------------------------------------------------------------------------------------
sub Get
{
	my $this = shift;
	my ($kind, $key, $default) = @_;
	
	my $val = $this->{$kind}->{$key};
	
	return (defined $val ? $val : (defined $default ? $default : undef));
}

#------------------------------------------------------------------------------------------------------------
#
#	Xbhǉ
#	-------------------------------------------------------------------------------------
#	@param	$id			XbhID
#	@param	$subject	Xbh^Cg
#	@param	$res		X
#	@return	XbhID
#
#------------------------------------------------------------------------------------------------------------
sub Add
{
	my $this = shift;
	my ($id, $subject, $res) = @_;
	
	$this->{'SUBJECT'}->{$id} = $subject;
	$this->{'RES'}->{$id} = $res;
	unshift @{$this->{'SORT'}}, $id;
	$this->{'NUM'}++;
	
	return $id;
}

#------------------------------------------------------------------------------------------------------------
#
#	Xbhݒ
#	-------------------------------------------------------------------------------------
#	@param	$id		XbhID
#	@param	$kind	
#	@param	$val	ݒl
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub Set
{
	my $this = shift;
	my ($id, $kind, $val) = @_;
	
	if (exists $this->{$kind}->{$id}) {
		$this->{$kind}->{$id} = $val;
	}
}

#------------------------------------------------------------------------------------------------------------
#
#	Xbh폜
#	-------------------------------------------------------------------------------------
#	@param	$id		폜XbhID
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub Delete
{
	my $this = shift;
	my ($id) = @_;
	
	delete $this->{'SUBJECT'}->{$id};
	delete $this->{'RES'}->{$id};
	
	my $sort = $this->{'SORT'};
	for (my $i = 0; $i < scalar(@$sort); $i++) {
		if ($id eq $sort->[$i]) {
			splice @$sort, $i, 1;
			$this->{'NUM'}--;
			last;
		}
	}
}

#------------------------------------------------------------------------------------------------------------
#
#	Xbh擾
#	-------------------------------------------------------------------------------------
#	@param	Ȃ
#	@return	Xbh
#
#------------------------------------------------------------------------------------------------------------
sub GetNum
{
	my $this = shift;
	
	return $this->{'NUM'};
}

#------------------------------------------------------------------------------------------------------------
#
#	Xbh֘A
#
#------------------------------------------------------------------------------------------------------------
sub LoadAttr
{
	return BILBO::LoadAttr(@_);
}

sub SaveAttr
{
	return BILBO::SaveAttr(@_);
}

sub GetAttr
{
	return BILBO::GetAttr(@_);
}

sub SetAttr
{
	return BILBO::SetAttr(@_);
}

sub DeleteAttr
{
	return BILBO::DeleteAttr(@_);
}

#------------------------------------------------------------------------------------------------------------
#
#	XbhXV
#	-------------------------------------------------------------------------------------
#	@param	$Sys	MELKOR
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub Update
{
	my $this = shift;
	my ($Sys) = @_;
	my ($id, $base, $n);
	
	$base = $Sys->Get('BBSPATH') . '/' . $Sys->Get('BBS') . '/pool';
	
	foreach my $id (@{$this->{'SORT'}}) {
		if (open(my $fh, '<', "$base/$id.cgi")) {
			flock($fh, 2);
			my $n = 0;
			$n++ while (<$fh>);
			close($fh);
			$this->{'RES'}->{$id} = $n;
		}
		else {
			warn "can't open file: $base/$id.dat";
		}
	}
}

#------------------------------------------------------------------------------------------------------------
#
#	Xbh񊮑SXV
#	-------------------------------------------------------------------------------------
#	@param	$Sys	MELKOR
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub UpdateAll
{
	my $this = shift;
	my ($Sys) = @_;
	
	$this->{'SORT'} = [];
	$this->{'SUBJECT'} = {};
	$this->{'RES'} = {};
	my @dirSet = ();
	
	my $base = $Sys->Get('BBSPATH') . '/' . $Sys->Get('BBS') . '/pool';
	my $num = 0;
	
	# fBNgꗗ擾
	if (opendir(my $fh, $base)) {
		@dirSet = readdir($fh);
		closedir($fh);
	}
	else {
		warn "can't open dir: $base";
		return;
	}
	
	foreach my $el (@dirSet) {
		if ($el =~ /^(.*)\.cgi$/ && open(my $fh, '<', "$base/$el")) {
			flock($fh, 2);
			my $id = $1;
			my $n = 1;
			my $first = <$fh>;
			$n++ while (<$fh>);
			close($fh);
			$first =~ s/[\r\n]+\z//;
			
			my @elem = split(/<>/, $first, -1);
			$this->{'SUBJECT'}->{$id} = $elem[4];
			$this->{'RES'}->{$id} = $n;
			push @{$this->{'SORT'}}, $id;
			$num++;
		}
	}
	$this->{'NUM'} = $num;
}

#============================================================================================================
#	Module END
#============================================================================================================
1;
