enchant();
//////////////////////////////////////
//global
var ctl = null;
var mangIcon = null;
var mangTouch = null;
var mangLabel = null;
var mangMsg = null;
var LabelGroup = enchant.Class.mixClasses(Label, Group,true);
var net = new Net();
//////////////////////////////////////
//define
//////////////////////////////////////
var PALYER_INIT_X = 100;
var PALYER_INIT_Y = 100;
var CHARA_WIDTH = 64;
var CHARA_HEIGHT = 64;
var GAME_WIDTH = 800;
var GAME_HEIGHT = 600;
var FPS = 20;
var BASE_FPS = 20;
var HUNGRY_MAX = 100;

var EResPath = {
	YUKKURI_BASE : './data/yukkuri_base.png',
	YUKKURI_BODY_DEAD : './data/yukkuri_dead.png',
	YUKKURI_UNUN : './data/unun.png',
	YUKKURI_SHADOW : './data/shadow.png',
	MARISA_FACE_NORMAL : './data/marisa/face_normal1.png',
	MARISA_FACE_TIRED : './data/marisa/face_tired1.png',
	MARISA_FACE_ANGRY : './data/marisa/face_angry1.png',
	MARISA_FACE_CRY1 : './data/marisa/face_cry1.png',
	MARISA_FACE_CRY2 : './data/marisa/face_cry2.png',
	MARISA_FACE_EAT1 : './data/marisa/face_eat1.png',
	MARISA_FACE_EAT2 : './data/marisa/face_eat2.png',
	MARISA_FACE_HAPPY1 : './data/marisa/face_happy1.png',
	MARISA_FACE_HAPPY2 : './data/marisa/face_happy2.png',
	MARISA_FACE_SLEEP : './data/marisa/face_sleep1.png',
	MARISA_HEAR : './data/marisa/hear1.png',
	OBJECT : './data/object.png',
	MAP0 : './data/map0.png',
	COMMAND : './data/command.png',
	OKAZARI : './data/okazari.png',
};
var EFace = {
	NORMAL:0,
	TIRED:1,
	ANGRY:2,
	CRY1:3,
	CRY2:4,
	EAT1:5,
	EAT2:6,
	HAPPY1:7,
	HAPPY2:8,
	SLEEP:9,
};
var EBody = {
	NORMAL: 0,
	DEAD: 1,
};

var ECommand = {
	WORLD_CURSOR: 0,
	WORLD_TARGET: 1,
	WORLD_APPLE: 2,
};

var EMenuPos = {
	X : 600,
	Y : 0,
	WIDTH : 200,
	HEIGHT : GAME_HEIGHT,
};
var EFieldPos = {
	X : 0,
	Y : 0,
	WIDTH: GAME_WIDTH - EMenuPos.WIDTH,
	HEIGHT: GAME_HEIGHT,
};
var EAction = {
	WAIT : 0,
	HUNT : 3,
	THINK : 4,
	WALK : 5,
	DEAD: 6,
	EAT_START : 8,
	EAT_WAIT : 9,
	MOVE_TO_EAT_START: 10,
	MOVE_TO_EAT_UNDERWAY: 11,
	MOVE_TO_COMMAND: 12,
	UNUN_START : 13,
	UNUN_WAIT : 14,
	UNUN_SMELL_START : 15,
	UNUN_SMELL_WAIT : 16,
	SLEEP_START : 17,
	SLEEP_WAIT : 18,
	NONE: 9999
};
var EDirection = {
	LEFT : 0,
	RIGHT: 1,
};
var EMsg = {
	WALK: 0,
	SLEEP: 1,
	EAT: 2,
	GET_UP: 3,
	DEAD: 4,
	UNUN: 5,
	UNUN_END: 6,
	UNUN_SMELL_START: 7,
	SEARCH_FOOD: 8,
};
include("./lang/ja.js");
window.onload = function(){

	//init game
	var def = new Object();
	var foodGroup = new Group();
	var SpriteGroup = enchant.Class.mixClasses(Sprite, Group,true);
	var menuBg = new SpriteGroup(EMenuPos.WIDTH, EMenuPos.HEIGHT);
	var fieldBg = new enchant.Sprite(EFieldPos.WIDTH, EFieldPos.HEIGHT);
	var game = new Game(GAME_WIDTH, GAME_HEIGHT);
	game.fps = FPS;
	var _loadArr = [];
	var i=0;
	for(var _v in EResPath){
		_loadArr[i] = EResPath[_v];
		i++;
	}
	game.preload(_loadArr);
	var MapGroup = enchant.Class.mixClasses(Map, Group,true);
	var backgroundMap = new MapGroup(16, 16);
	include("./class.js");
	include("./ctrl.js");
	ctl = new Ctrl();
	ctl.init(game);
	ctl.setBackgroundMap(backgroundMap);
	var Action = enchant.Class.create({
		initialize: function (yukkuri){
			this.status = EAction.THINK;
			this.yukkuri = yukkuri;
			this.isMoving = false;
			this.targetNode = null;
		},
		getStatus: function(){
			return this.status;
		},
		setStatus: function(eaction){
			this.status = eaction;
		},
		observe: function(){
			if(this.yukkuri.isDead()){
				this.status = EAction.DEAD;
			}
			// else if(this.yukkuri.isSleep()){
			// 	this.status = EAction.SLEEP;
			// }

		},
		act : function(){
			this.observe();
			switch(this.status){
				case EAction.WAIT:

				break;
				case EAction.THINK:
					if(this.yukkuri.age%2 === 0){
						if(this.yukkuri.isSleep()){
							this.setStatus(EAction.SLEEP_START);
						}
						else if(this.yukkuri.getUnun() >= 80){
							this.setStatus(EAction.UNUN_START);
						}else{
							// this.yukkuri.param.yukkuri -= 1;
							this.yukkuri.changeFace();
							this.search();
						}

					}
				break;
				case EAction.MOVE_TO_EAT_START:
					this.move_to_eat_start();
				break;
				case EAction.MOVE_TO_EAT_UNDERWAY:
				break;
				//Random Walk
				case EAction.WALK:
					this.walk(0);
				break;
				case EAction.SLEEP_START:
					this.sleep_start();
				break;
				case EAction.SLEEP_WAIT:
				break;
				case EAction.DEAD:
					this.dead();
				break;
				case EAction.EAT_START:
					this.eat_start();
				break;
				case EAction.EAT_WAIT:
				break;
				case EAction.UNUN_START:
					this.unun_start();
				break;
				case EAction.UNUN_WAIT:
				break;
				case EAction.MOVE_TO_COMMAND:
					this.move_to_command();
				break;
				case EAction.UNUN_SMELL_START:
					this.unun_smell_start();
				break;
			}
		},

		move_to_eat_start : function(){
			new MoveToEatEvent({
				"type": 'food',
				"targetNode": this.targetNode,
				"action": this,
				"myYukkuri": this.yukkuri
			});
		},
		walk : function(retryCounter){
			if(retryCounter > 15){
				retryCounter = 0;
				this.status = EAction.NONE;
				console.log("retryCount over");
				return;
			}
			if(this.yukkuri.imgGroup.tl.queue.length === 0){
				var frame = 200;
				if(this.isMoving){
					this.isMoving = false;
					this.status = EAction.THINK;
					this.yukkuri.vx = 0;
					this.yukkuri.vy = 0;
				}else{
					// this.isMoving = true;
					var xpos = 150 + rand(40) - (retryCounter * 10);
					var ypos = 150 + rand(40) - (retryCounter * 10);
					if(rand(8) === 0){
						this.yukkuri.vx = 0;
						this.yukkuri.vy = -ypos;
					}
					else if(rand(8) == 1){
						this.yukkuri.vx = xpos;
						this.yukkuri.vy = -ypos;
						this.yukkuri.direction = EDirection.RIGHT;
					}
					else if(rand(8) == 2){
						this.yukkuri.vx = xpos;
						this.yukkuri.vy = 0;
						this.yukkuri.direction = EDirection.RIGHT;
					}
					else if(rand(8) == 3){
						this.yukkuri.vx = xpos;
						this.yukkuri.vy = ypos;
						this.yukkuri.direction = EDirection.RIGHT;
					}
					else if(rand(8) == 4){
						this.yukkuri.vx = 0;
						this.yukkuri.vy = ypos;
					}
					else if(rand(8) == 5){
						this.yukkuri.vx = -xpos;
						this.yukkuri.vy = ypos;
						this.yukkuri.direction = EDirection.LEFT;
					}
					else if(rand(8) == 6){
						this.yukkuri.vx = -xpos;
						this.yukkuri.vy = 0;
						this.yukkuri.direction = EDirection.LEFT;
					}
					else if(rand(8) == 7){
						this.yukkuri.vx = -xpos;
						this.yukkuri.vy = -ypos;
						this.yukkuri.direction = EDirection.LEFT;
					}
					if (this.yukkuri.vx || this.yukkuri.vy) {
						var map = ctl.backgroundMap;
						// var x = this.yukkuri.x + (this.yukkuri.moveX ? this.yukkuri.moveX / Math.abs(this.yukkuri.moveX) * 16 : 0) + 16;
						// var y = this.yukkuri.y + (this.yukkuri.moveY ? this.yukkuri.moveY / Math.abs(this.yukkuri.moveY) * 16 : 0) + 16;
						var x = this.yukkuri.imgGroup.x + this.yukkuri.vx;
						var y = this.yukkuri.imgGroup.y + this.yukkuri.vy + this.yukkuri.height / 2;
						if (0 <= x && x < map.width && 0 <= y && y < map.height && !map.hitTest(x, y)) {
							// console.log("あたってないよ:"+ this.yukkuri.imgGroup.x + ":" + this.yukkuri.imgGroup.y);
							// console.log("X:" + this.yukkuri.moveX);
							// console.log("Y:" + this.yukkuri.moveY);
							this.isMoving = true;
							this.yukkuri.reverse();
							this.yukkuri.moveBy(this.yukkuri.vx, this.yukkuri.vy, frame);
							mangMsg.output(this.yukkuri,EMsg.WALK);
							//うんうんくさい対策
							this.targetNode = null;
						}else{
							// console.log("HIT:"+ this.yukkuri.imgGroup.x + ":" + this.yukkuri.imgGroup.y);
							this.walk(retryCounter+1);
						}
					}
				}
			}
		},
		sleep_start: function(){
			new SleepEvent({
				"action": this,
				"myYukkuri": this.yukkuri
			});
		},
		dead : function(){
			console.log("dead");
			mangMsg.output(this.yukkuri, EMsg.DEAD);
			this.yukkuri.imgBody.tl.clear();
			this.yukkuri.imgBody.tl.pause();
			this.yukkuri.imgGroup.tl.clear();
			this.yukkuri.imgGroup.tl.pause();
			this.yukkuri.setBodyImage(EBody.DEAD);
		},
		eat_start: function(){
			new EatEvent({
				"type": 'eat',
				"targetNode": this.targetNode,
				"action": this,
				"myYukkuri": this.yukkuri
			});

		},
		unun_start: function(){
			new UnunEvent({
				"action": this,
				"myYukkuri": this.yukkuri
			});
		},
		unun_smell_start: function(){
			new UnunSmellEvent({
				"action": this,
				"myYukkuri": this.yukkuri
			});
		},
		move_to_command: function(){

		},
		search : function(){
			var nodes = ctl.getObjs();
			l = nodes.length;
			var ununFlg = false;

			for (var key in nodes) {
				var node = nodes[key];
				if (!ununFlg
					&& node instanceof Unun
					&& !(this.targetNode instanceof Unun)
					&& this.yukkuri.within(node, this.yukkuri.getRange() / 2)) {
					ununFlg = true;
					this.targetNode = node;
					this.setStatus(EAction.UNUN_SMELL_START);
					return;
				}
				else if (node instanceof Food) {
					if(this.yukkuri.isKuhuku() && this.yukkuri.within(node, this.yukkuri.getRange())){

						//A yukkuri to go to the food area
						this.targetNode = node;
						this.setStatus(EAction.MOVE_TO_EAT_START);

						return;
					}else{
						//not hunbry or not food.
					}
				}
			}
			this.status =  EAction.WALK;
		}
	});
	var Event = enchant.Class.create({
		initialize: function (_data){
		},
		onactionstart:function(self){
			return function(e){
				if(typeof e === "undefined")return;
			};
		},
		onactiontick:function(self){
			return function(e){
				if(typeof e === "undefined")return;
			};
		},
		onactionend:function(self){
			return function(e){
				if(typeof e === "undefined")return;
			};
		}
	});
	var SleepEvent = enchant.Class.create(Event,{
		initialize: function (_data){
			this.data = _data;
			this.yukkuri = _data.myYukkuri;
			this.action = _data.action;

			mangMsg.output(this.yukkuri, EMsg.SLEEP);
			this.action.setStatus(EAction.SLEEP_WAIT);
			this.yukkuri.setFaceImage(EFace.SLEEP);
			this.yukkuri.tlPause();
			var sec = FPS * 3;
			// this.yukkuri.enterframe(function(){
			// 	console.log("enterfmrae");
			// });
			var self = this;
			this.yukkuri.addEventListener('enterframe', function() {
				var yukkuri = self.yukkuri;
				if(yukkuri.age%2 === 0 && yukkuri.age !== 0)yukkuri.param.sleep--;
				if(yukkuri.param.sleep <= 0){
					yukkuri.param.sleep = 0;
					self.action.setStatus(EAction.WAIT);
					mangMsg.output(self.yukkuri, EMsg.GET_UP);
					self.yukkuri.setFaceImage(EFace.NORMAL);
					yukkuri.tlResume();
					this.removeEventListener("enterframe",arguments.callee);
					self.action.setStatus(EAction.THINK);
				}
			});
		},
		onactionstart:function(self){
			return function(e){
				if(typeof e === "undefined")return;
				console.log("astart");
			};
		},
		onactiontick:function(self){
			return function(e){
				if(typeof e === "undefined")return;
			};
		},
		onactionend:function(self){
			return function(e){
				if(typeof e === "undefined")return;
				console.log("enddd");
			};
		}

		// initialize: function (_data){
		// 	console.log("init");
		// 	this.data = _data;
		// 	this.yukkuri = _data.myYukkuri;
		// 	this.action = _data.action;
		// 	this.action.setStatus(EAction.SLEEP_WAIT);
		// 	mangMsg.output(this.yukkuri, EMsg.SLEEP);
		// 	this.yukkuri.setFaceImage(EFace.SLEEP);
		// 	this.yukkuri.tlPause();

		// 	var sec = BASE_FPS * 1;
		// 	console.log("sec:"+ sec);
		// 	this.yukkuri.wait(sec, {
		// 		"onactionstart": this.onactionstart(this),
		// 		"onactiontick": this.onactiontick(this),
		// 		"onactionend": this.onactionend(this)
		// 	});
		// },
		// onactionstart:function(self){
		// 	return function(e){
		// 		console.log("start");
		// 		if(typeof e === "undefined")return;
		// 	};
		// },
		// onactiontick:function(self){
		// 	return function(e){
		// 		if(typeof e === "undefined")return;
		// 		console.log("tick");
		// 		var yukkuri = self.yukkuri;
		// 		if(yukkuri.age%4 === 0 && yukkuri.age !== 0)yukkuri.param.sleep--;
		// 		if(yukkuri.param.sleep <= 0){
		// 			yukkuri.param.sleep = 0;
		// 		}
		// 	};
		// },
		// onactionend:function(self){
		// 	return function(e){
		// 		if(typeof e === "undefined")return;
		// 		self.action.setStatus(EAction.WAIT);
		// 		self.yukkuri.setFaceImage(EFace.NORMAL);
		// 		mangMsg.output(self.yukkuri, EMsg.GET_UP);
		// 		yukkuri.tlResume();
		// 		new WaitEvent({
		// 			"waitframe": FPS * 1.5,
		// 			"action": self.action,
		// 			"myYukkuri": self.yukkuri
		// 		});
		// 	};
		// }
	});

	var UnunEvent = enchant.Class.create(Event,{
		initialize: function (_data){
			this.data = _data;
			this.yukkuri = _data.myYukkuri;
			this.action = _data.action;
			this.action.setStatus(EAction.UNUN_WAIT);
			mangMsg.output(this.yukkuri, EMsg.UNUN);
			this.yukkuri.setFaceImage(EFace.HAPPY2);
			var sec = FPS * 3;

			this.yukkuri.wait(sec, {
				"onactionstart": this.onactionstart(this),
				"onactiontick": this.onactiontick(this),
				"onactionend": this.onactionend(this)
			});
		},
		onactionstart:function(self){
			return function(e){
				if(typeof e === "undefined")return;
			};
		},
		onactiontick:function(self){
			return function(e){
				if(typeof e === "undefined")return;
			};
		},
		onactionend:function(self){
			return function(e){
				if(typeof e === "undefined")return;
				self.yukkuri.unun();
				self.action.setStatus(EAction.WAIT);
				mangMsg.output(self.yukkuri, EMsg.UNUN_END);
				new WaitEvent({
					"waitframe": FPS * 1.5,
					"action": self.action,
					"myYukkuri": self.yukkuri
				});
			};
		}
	});
	var WaitEvent = enchant.Class.create(Event,{
		initialize: function (_data){
			this.data = _data;
			this.yukkuri = _data.myYukkuri;
			this.action = _data.action;
			this.waitframe = _data.waitframe;
			this.yukkuri.wait(this.waitframe, {
				"onactionstart": this.onactionstart(this),
				"onactiontick": this.onactiontick(this),
				"onactionend": this.onactionend(this)
			});
		},
		onactionend:function(self){
			return function(e){
				if(typeof e === "undefined")return;
				self.action.setStatus(EAction.THINK);
			};
		}
	});
	var UnunSmellEvent = enchant.Class.create(Event,{
		initialize: function (_data){
			this.data = _data;
			this.yukkuri = _data.myYukkuri;
			this.action = _data.action;
			this.action.setStatus(EAction.UNUN_SMELL_WAIT);
			mangMsg.output(this.yukkuri, EMsg.UNUN_SMELL);
			this.yukkuri.setFaceImage(EFace.CRY1);
			var sec = FPS * 3;
			this.yukkuri.setYukkuri(this.yukkuri.getYukkuri() - 3);
			this.yukkuri.wait(sec, {
				"onactionstart": this.onactionstart(this),
				"onactiontick": this.onactiontick(this),
				"onactionend": this.onactionend(this)
			});
		},
		onactionend:function(self){
			return function(e){
				if(typeof e === "undefined")return;
				self.action.setStatus(EAction.THINK);
			};
		}
	});

	var EatEvent = enchant.Class.create(Event,{
		initialize: function (_data){
			this.data = _data;
			this.yukkuri = _data.myYukkuri;
			this.food = _data.targetNode;
			this.action = _data.action;
			this.action.setStatus(EAction.EAT_WAIT);
			mangMsg.output(this.yukkuri, EMsg.EAT);
			this.yukkuri.setFaceImage(EFace.EAT2);

			// var sec = FPS * (this.yukkuri.param.hungry/10 + 3);
			var sec = FPS * 3;

			this.yukkuri.wait(sec, {
				"onactionstart": this.onactionstart(this),
				"onactiontick": this.onactiontick(this),
				"onactionend": this.onactionend(this)
			});
		},
		onactionstart:function(self){
			return function(e){
				if(typeof e === "undefined")return;
				self.yukkuri.eat(self.food);
			};
		},
		onactiontick:function(self){
			return function(e){
				if(typeof e === "undefined")return;
			};
		},
		onactionend:function(self){
			return function(e){
				if(typeof e === "undefined")return;
				if(self.food.getAmount() <= 0 || self.yukkuri.isManpuku()){
					self.action.setStatus(EAction.THINK);
					self.yukkuri.setFaceImage(EFace.NORMAL);
				}else{
					self.action.setStatus(EAction.EAT_START);
				}
			};
		}
	});
	/**
	 * Move Event
	 * -When yukkuri find Food.
	 * @param  _data
	 * type: "food"
	 * targetNode: enchant.Node
	 * action:Action
	 * myYukkuri:Yukkuri
	 */
	var MoveToEatEvent = enchant.Class.create(Event,{
		initialize: function (_data){
			this.data = _data;
			this.yukkuri = this.data.myYukkuri;
			this.action = this.data.action;

			var yukkuri = this.yukkuri;
			var node = this.data.targetNode;
			//food distance
			if(this.data.type == "food"){
				this.action.status = EAction.MOVE_TO_EAT_UNDERWAY;
				yukkuri.vx = node.x - yukkuri.getX();
				yukkuri.vy = node.y - yukkuri.getY();
				var distance = (Math.abs(yukkuri.vx) + Math.abs(yukkuri.vy)) / 2;
				var frame = distance + distance/5 + 1;
				yukkuri.direction = yukkuri.vx > 0 ? EDirection.RIGHT : EDirection.LEFT;

				yukkuri.moveBy(yukkuri.vx, yukkuri.vy, frame, {
					"onactionstart": this.onactionstart(this),
					"onactiontick": this.onactiontick(this),
					"onactionend": this.onactionend(this)
				});
			}
		},
		onactionstart:function(self){
			return function(e){
				if(typeof e === "undefined")return;
				self.yukkuri.tweet("ゆゆ？？\nたべものさん\nはっけんなのぜ！");
			};
		},
		onactiontick:function(self){
			return function(e){
				if(typeof e === "undefined")return;
			};
		},
		onactionend:function(self){
			return function(e){
				if(typeof e === "undefined")return;
				self.action.setStatus(EAction.EAT_START);
			};
		}
	});
	var MoveCommandEvent = enchant.Class.create(Event,{
		initialize: function (_data){
			this.data = _data;
			this.yukkuri = this.data.myYukkuri;
			this.action = this.data.action;
			this.vx = this.data.vx;
			this.vy = this.data.vy;

			var yukkuri = this.yukkuri;
			this.action.status = EAction.MOVE_TO_EAT_UNDERWAY;
			yukkuri.vx = node.x - yukkuri.getX();
			yukkuri.vy = node.y - yukkuri.getY();
			var distance = (Math.abs(yukkuri.vx) + Math.abs(yukkuri.vy)) / 2;
			var frame = distance + 1;
			yukkuri.moveBy(yukkuri.vx, yukkuri.vy, frame, {
				"onactionstart": this.onactionstart(this),
				"onactiontick": this.onactiontick(this),
				"onactionend": this.onactionend(this)
			});
		},
		onactionstart:function(self){
			return function(e){
				if(typeof e === "undefined")return;
			};
		},
		onactiontick:function(self){
			return function(e){
				if(typeof e === "undefined")return;
			};
		},
		onactionend:function(self){
			return function(e){
				if(typeof e === "undefined")return;
				self.action.setStatus(EAction.THINK);
			};
		}
	});

	var ObjSprite = enchant.Class.create(enchant.Sprite,{
		initialize: function (w, h){
			enchant.Sprite.call(this, w, h);
			this.id = guid();
			ctl.addObj(this);
		},
		removeAll: function(){
			this.remove();
			ctl.removeObj(this);
		}
	});

	var Food = enchant.Class.create(ObjSprite,{
		initialize: function (type, x, y){
			this.classname = "Food";
			ObjSprite.call(this,16,16);
			this.image = game.assets[EResPath.OBJECT];
			this.frame = 15;
			this.x = x;
			this.y = y;
			//一つにつきgiveの値分、hunguryを減少させられる
			this.give = 40;
			this.amount = 3;
			foodGroup.addChild(this);
			this.addEventListener('enterframe', function(){
				if(this.amount <= 0){
					this.removeAll();
				}
			});
		},
		getAmount: function(){
			return this.amount;
		},
		getGive: function(){
			return this.give;
		}
	});
	var Unun = enchant.Class.create(ObjSprite,{
		initialize: function (x, y){
			this.classname = "Unun";
			ObjSprite.call(this,32,32);
			this.image = game.assets[EResPath.YUKKURI_UNUN];
			this.x = x;
			this.y = y;
			backgroundMap.addChild(this);
		}
	});
	var Okazari = enchant.Class.create(enchant.Sprite,{
		initialize: function(){
			this.classname = "Okazari";
			enchant.Sprite.call(this, 64, 64);
			this.image = game.assets[EResPath.OKAZARI];
			this.x = -CHARA_WIDTH / 2;
			this.y = -12 - CHARA_HEIGHT / 2;
		}
	});
	var Yukkuri = enchant.Class.create(ObjSprite,{
		initialize: function(x, y){
			ObjSprite.call(this, 64, 64);
			this.classname = "Yukkuri";
			this.imgGroup = new SpriteGroup();
			this.imgBody = new SpriteGroup();
			this.imgGroup.id = guid();
			this.imgBody.id = guid();
			this.x = -CHARA_WIDTH / 2;
			this.y = -CHARA_HEIGHT / 2;
			this.vx = 0;
			this.vy = 0;
			this.image = game.assets[EResPath.YUKKURI_BASE];
			this.direction = EDirection.RIGHT;
			this.addEventListener('enterframe', this.runEnterframe);
			this.isSleeping = false;
			this.bodyStatus ={};
			this.bodyStatus[EBody.NORMAL] = EResPath.YUKKURI_BASE;
			this.bodyStatus[EBody.DEAD] = EResPath.YUKKURI_BODY_DEAD;
		},
		runEnterframe:function(){
			this.act();
			if(this.isDead())return;
			this.runYukkuri();
			this.runHungry();
			this.runUnun();
			this.runSleep();
		},
		reverse:function(){
			if(this.direction == EDirection.RIGHT){
				this.imgBody.scaleX = 1;
			}
			else if(this.direction == EDirection.LEFT){
				this.imgBody.scaleX = -1;
			}
		},
		tweet:function(text){
			this._tweet.text(text, this.x - this._tweet.width/4, this.y - this._tweet.height);
		},
		moveTo:function(x, y, time){
			this.imgGroup.tl.moveTo(x, y, time, enchant.Easing.SIN_EASEINOUT);
		},
		moveBy:function(x, y, time, eventFunctions){
			var self = this;
			var params = {
				x: function() {
					return self.imgGroup.x + x;
				},
				y: function() {
					return self.imgGroup.y + y;
				},
				time: time,
				easing: enchant.Easing.SIN_EASEINOUT
			};
			//-Event register [onactionstart,onactiontick,onactionend]
			if(eventFunctions !== undefined){
				for(var key in eventFunctions){
					params[key] = eventFunctions[key];
				}
			}
			this.imgGroup.tl.tween(params);

		},
		wait:function(frame, eventFunctions){
			this.moveBy(0,1,frame,eventFunctions);
		},
		act: function(){
			this.action.act();
		},
		animation: function(){
			this.imgBody.tl.moveBy(0, -5, 10, enchant.Easing.SWING).moveBy(0, 5, 10, enchant.Easing.SWING).loop();
			// this.tl.moveBy(0, -5, 10, enchant.Easing.SWING).moveBy(0, 5, 10, enchant.Easing.SWING).loop();
			// this.okazari.tl.moveBy(0, -5, 10, enchant.Easing.SWING).moveBy(0, 5, 10, enchant.Easing.SWING).loop();
			// this.face.tl.moveBy(0, -5, 10, enchant.Easing.SWING).moveBy(0, 5, 10, enchant.Easing.SWING).loop();
			// this.hear.tl.moveBy(0, -5, 10, enchant.Easing.SWING).moveBy(0, 5, 10, enchant.Easing.SWING).loop();
		},
		getWidth: function(){
			return this.width;
		},
		getHeight: function(){
			return this.height;
		},
		getX: function(){
			return this.imgGroup.x;
		},
		getY: function(){
			return this.imgGroup.y;
		},
		moveX: function(x){
			this.imgGroup.x += x;
			// this.x += x;
			// this.shadow.x += x;
			// this._tweet.x += x;
		},
		moveY: function(y){
			this.imgGroup.y += y;
			// this.y += y;
			// this.shadow.y += y;
			// this._tweet.y += y;
		},
		// changeFace: function(erespath){
		// 	this.face.image = game.assets[erespath];
		// },
		loadParamsXML: function(url){
			var http = new JKL.ParseXML( url );
			return http.parse();
		},
		runYukkuri: function(){
			if(this.param.hungry > 70){
				if(this.age%(50 - this.param.hungry - 70) === 0 && this.age !== 0){
					this.param.yukkuri -= 1;
				}
			}
			else if(this.param.hungry < 10){
				if(this.age%50 === 0 && this.age !== 0) this.param.yukkuri += 1;
			}

			if(this.param.yukkuri <= 0)this.param.yukkuri = 0;
			else if(this.param.yukkuri >= this.param.maxYukkuri)this.param.yukkuri = this.param.maxYukkuri;
		},
		runHungry: function(){
			if(this.age%50 === 0 && this.age !== 0)this.param.hungry++;
			if(this.param.hungry >= 100)this.param.hungry = 100;
		},
		runUnun: function(){
			if(this.age%50 === 0 && this.age !== 0)this.param.unun++;
			if(this.param.unun >= 100)this.param.unun = 100;
		},
		runSleep: function(){
			if(this.action.getStatus() != EAction.SLEEP_START && this.action.getStatus() != EAction.SLEEP_WAIT){
				if(this.age%80 === 0 && this.age !== 0)this.param.sleep++;
				if(this.param.sleep >= 100){
					this.param.sleep = 100;
				}
			}
		},
		changeFace: function(){
			if(this.param.yukkuri >= 80){
				this.setFaceImage(EFace.HAPPY1);
			}
			else if(this.param.yukkuri >= 50){
				this.setFaceImage(EFace.NORMAL);
			}
			else if(this.param.yukkuri >= 30){
				this.setFaceImage(EFace.TIRED);
			}
			else if(this.param.yukkuri >= 10){
				this.setFaceImage(EFace.CRY1);
			}
			else if(this.param.yukkuri >= 1){
				this.setFaceImage(EFace.CRY2);
			}
		},
		getRange: function(){
			return this.param.range;
		},
		isSleep: function(){
			return this.param.sleep >= 100;
		},
		isDead: function(){
			return this.param.yukkuri <= 0;
		},
		isManpuku: function(){
			return this.param.hungry <= 20;
		},
		isKuhuku: function(){
			return this.param.hungry >= 40;
		},
		getYukkuri: function(){
			return this.param.yukkuri;
		},
		setYukkuri: function(yukkuri){
			this.param.yukkuri = yukkuri;
			if(this.param.yukkuri < 0)this.param.yukkuri = 0;
		},
		getHungry: function(){
			return this.param.hungry;
		},
		setHungry: function(hungry){
			this.param.hungry = hungry;
			if(this.param.hungry < 0)this.param.hungry = 0;
		},
		getUnun: function(){
			return this.param.unun;
		},
		setUnun: function(unun){
			this.param.unun = unun;
			if(this.param.unun < 0)this.param.unun = 0;
		},

		eat:function(food){
			food.amount--;
			this.setHungry(this.param.hungry - food.getGive());
			this.setUnun(this.getUnun() + food.getGive() / 4);
			this.setYukkuri(this.getYukkuri() + 5);
		},
		unun:function(){
			if(this.direction == EDirection.RIGHT){
				new Unun(this.getX(), this.getY() + this.getHeight()/5 );
			}else{
				new Unun(this.getX() -  this.getWidth()/5, this.getY() + this.getHeight()/5 );
			}
			this.setUnun(0);
		},
		setBodyImage: function(ebody){
			var path = this.bodyStatus[ebody];
			this.image = game.assets[path];
		},
		tlPause:function(){
			this.imgBody.tl.pause();
			this.imgGroup.tl.pause();
			this.imgBody.tl.clear();
			this.imgGroup.tl.clear();
		},
		tlResume: function(){
			this.imgBody.tl.resume();
			this.imgGroup.tl.resume();
			this.animation();
		},
		destruct: function(){

		}
	});
	var Marisa = enchant.Class.create(Yukkuri,{
		initialize: function(x, y){
			Yukkuri.call(this,x,y);
			this.classname = "Marisa";


			// var xml = this.loadParamsXML("./data/marisa/params.xml");
			var json = net.load("./data/marisa/params.json");
			this.param = json.root.param;
			this.shadow = new enchant.Sprite(64, 64);
			this.shadow.image = game.assets[EResPath.YUKKURI_SHADOW];
			this.shadow.x = 0 + this.x;
			this.shadow.y = CHARA_HEIGHT / 16 + this.x;
			this.shadow.image._element.style.zIndex = 2;

			this._style.zIndex = 5;

			this.face = new enchant.Sprite(64, 64);
			this.face.image = game.assets[EResPath.MARISA_FACE_NORMAL];
			this.face.x = -CHARA_WIDTH / 2;
			this.face.y = -CHARA_HEIGHT / 2;
			this.face._style.zIndex = 0;

			this.faceStatus ={};
			this.faceStatus[EFace.NORMAL] = EResPath.MARISA_FACE_NORMAL;
			this.faceStatus[EFace.CRY1] = EResPath.MARISA_FACE_CRY1;
			this.faceStatus[EFace.CRY2] = EResPath.MARISA_FACE_CRY2;
			this.faceStatus[EFace.ANGRY] = EResPath.MARISA_FACE_ANGRY;
			this.faceStatus[EFace.HAPPY1] = EResPath.MARISA_FACE_HAPPY1;
			this.faceStatus[EFace.HAPPY2] = EResPath.MARISA_FACE_HAPPY2;
			this.faceStatus[EFace.EAT1] = EResPath.MARISA_FACE_EAT1;
			this.faceStatus[EFace.EAT2] = EResPath.MARISA_FACE_EAT2;
			this.faceStatus[EFace.TIRED] = EResPath.MARISA_FACE_TIRED;
			this.faceStatus[EFace.SLEEP] = EResPath.MARISA_FACE_SLEEP;


			this.hear = new enchant.Sprite(64, 64);
			this.hear.image = game.assets[EResPath.MARISA_HEAR];
			this.hear.x = -CHARA_WIDTH / 2;
			this.hear.y = -CHARA_HEIGHT / 2;
			this.hear._style.zIndex = 0;

			this.okazari = new Okazari();
			this.okazari.image._element.style.zIndex = 1;

			// this.imgGroup._style.zIndex = 1;

			this.imgGroup.addChild(this.shadow);
			this.imgBody.addChild(this);
			this.imgBody.addChild(this.face);
			this.imgBody.addChild(this.hear);
			this.imgBody.addChild(this.okazari);
			this.imgGroup.addChild(this.imgBody);
			backgroundMap.addChild(this.imgGroup);
			this._tweet = new TTweet(148, 64);
			this._tweet.image._element.style.zIndex = 20;

			this.imgGroup.addChild(this._tweet);
			this.imgGroup.x = x;
			this.imgGroup.y = y;
			this.animation();
			this.action = new Action(this);
			this.id = guid();
			ctl.addObj(this);
		},
		setFaceImage: function(eface){
			var path = this.faceStatus[eface];
			this.face.image = game.assets[path];
		}
	});
	var Player = enchant.Class.create(Marisa,{
		initialize: function(x, y){
			// this.runEnterframe = function(){
			// },
			Marisa.call(this, x, y);
			this.classname = "Player";
			ctl.setPlayer(this);
			// this.removeEventListener('enterframe',this.runEnterframe);
			this.addEventListener('enterframe', function(){
				if(this.age%10 === 0 && this.age !== 0){
					// console.log("palyer:" + this.age);
				}
				this.act();

				///////////////////////////////////////////////
				//Action pattern for debug
				if(game.input.left){
					// this.changeFace(EResPath.MARISA_FACE_TIRED);
					this.moveX(-10);
					this.direction = EDirection.LEFT;
				}
				if(game.input.right){
					this.moveX(10);
					this.direction = EDirection.RIGHT;
				}
				if(game.input.up){
					this.moveY(-10);
					this.tweet("ゆっくりしていってね！");
				}
				if(game.input.down){
					this.moveY(10);
				}
				///////////////////////////////////////////////
				this.reverse();
				// if(ctl.backgroundMap.hitTest(this.imgGroup.x, this.imgGroup.y + this.height / 2)){
				//	console.log("hit:" + this.imgGroup.x + ":" +  (this.imgGroup.y + this.height/2) );
				// }else{
				//	console.log("not:" + this.imgGroup.x + ":" +  (this.imgGroup.y + this.image.height/2));
				// }
				//- Display the circle of search range.
				// fieldBg.image.clear();
				// fieldBg.image.context.beginPath();
				// fieldBg.image.context.fillStyle = '#ff0000';
				// fieldBg.image.context.arc(this.imgGroup.x + this.width/2, this.imgGroup.y + this.height/2, this.range, Math.PI * 2, false);
				// fieldBg.image.context.fill();
			});
		}
	});
	game.onload = function(){
		def.Food = Food;
		mangTouch = new MangTouch(ctl);
		mangMsg = new MangMsg(ctl);
		ctl.setDefined(def);
		backgroundMap.image = game.assets[EResPath.MAP0];
		backgroundMap.loadData(_mapData);
		backgroundMap.collisionData = _collisionData;

		var menuSurface = new enchant.Surface(EMenuPos.WIDTH, EMenuPos.HEIGHT);
		var fieldSurface = new enchant.Surface(EFieldPos.WIDTH, EFieldPos.HEIGHT);
		fieldBg.image = fieldSurface;
		fieldBg.x = 0;
		fieldBg.y = 0;

		menuSurface.context.fillStyle = '#000';
		menuSurface.context.fillRect(0, 0, EMenuPos.WIDTH, EMenuPos.HEIGHT);
		menuBg.image = menuSurface;
		menuBg.x = EMenuPos.X;
		menuBg.y = EMenuPos.Y;

		backgroundMap.addChild(fieldBg);
		mangIcon = new MangIcon(ctl, menuBg);

		game.rootScene.addChild(backgroundMap);
		game.rootScene.addChild(menuBg);

		// var labelGroup = new LabelGroup();
		mangLabel = new MangLabel(ctl, menuBg);
		// var info = new Label("ゆっくり");
		// info.color = "#ffffff";
		// info.font = "14px 'Times New Roman'";
		// info.x = 4;
		// info.y = GAME_HEIGHT / 2;
		// labelGroup.addChild(info);
		// menuBg.addChild(labelGroup);


		// var food = new def.Food("apple", 200, 250);
		backgroundMap.addChild(foodGroup);
		var player = new Player(PALYER_INIT_X, PALYER_INIT_Y);
		// new Marisa(PALYER_INIT_X + 200, PALYER_INIT_Y);
		var touchX = 0;

		game.rootScene.addEventListener('touchstart', function (e) {
			game.touched = true;
			var mang = mangTouch.get(ctl.getCurrentCommand());
			mang.touchstart(e);
		});
		game.rootScene.addEventListener('touchmove', function (e) {
			var mang = mangTouch.get(ctl.getCurrentCommand());
			mang.touchmove(e);
		});
		game.rootScene.addEventListener('touchend', function (e) {
			var mang = mangTouch.get(ctl.getCurrentCommand());
			mang.touchend(e);
			game.touched = false;
		});


		game.rootScene.addEventListener('enterframe', function(){
		//main frame
			mangLabel.draw(player);
		});

		this.addEventListener('enterframe', function(){
			//The priority processing of display instead of z-index
			backgroundMap.childNodes.sort(
				function(a,b){
					if(typeof a.id === "undefined" && typeof b.id === "undefined"){
						return 0;
					}
					else if(typeof a.id === "undefined"){
						return -1;
					}
					else if(typeof b.id === "undefined"){
						return 1;
					}
					if(a.y < b.y)return -1;
					if(a.y > b.y)return 1;
					return 0;
				}
			);
		});

	};
	game.start();
};
