/**
 * The MIT License
 * 
 * Copyright (c) 2009 kyozi0x7c00@gmail.com
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package jp.sourceforge.hhcp.statement;

import java.util.List;

import jp.sourceforge.hhcp.statement.impl.ExpressionStatement;
import jp.sourceforge.hhcp.statement.impl.IfStatement;
import jp.sourceforge.hhcp.statement.impl.LoopStatement;
import jp.sourceforge.hhcp.statement.impl.MethodDeclaration;
import jp.sourceforge.hhcp.statement.impl.MethodStatement;
import jp.sourceforge.hhcp.statement.impl.TryStatement;

import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IMethodBinding;

public class StatementFactory {

	public IMethodDeclaration newMethodDeclaration(List<IStatement> statement) {
		return new MethodDeclaration(statement);
	}

	public IStatement newMethodStatement(IMethodBinding binding) {
		return new MethodStatement(binding);
	}

	public IStatement newIfStatement(ExpressionStatement expression, List<IStatement> thenStmt,	List<IStatement> elseStmt) {
		return new IfStatement(expression, thenStmt, elseStmt);
	}

	public IStatement newLoopStatement(ExpressionStatement expression, List<IStatement> statement) {
		return new LoopStatement(expression, statement);
	}

	public IStatement newTryStatement(List<IStatement> statement) {
		return new TryStatement(statement);
	}
	
	public IStatement newExpressionStatement(Expression expression) {
		return new ExpressionStatement(expression);
	}

	public IStatement newConstructor() {
		return ReservedWord.CONSTRUCTOR;
	}

	public IStatement newEndConstructor() {
		return ReservedWord.END_CONSTRUCTOR;
	}

	public IStatement newMethod() {
		return ReservedWord.METHOD;
	}

	public IStatement newEndMethod() {
		return ReservedWord.END_METHOD;
	}

	public IStatement newIf() {
		return ReservedWord.IF;
	}

	public IStatement newElse() {
		return ReservedWord.ELSE;
	}

	public IStatement newEndIf() {
		return ReservedWord.END_IF;
	}

	public IStatement newLoop() {
		return ReservedWord.LOOP;
	}

	public IStatement newEndLoop() {
		return ReservedWord.END_LOOP;
	}

	public IStatement newTry() {
		return ReservedWord.TRY;
	}

	public IStatement newEndTry() {
		return ReservedWord.END_TRY;
	}

	public IStatement newCatch() {
		return ReservedWord.CATCH;
	}

	public IStatement newEndCatch() {
		return ReservedWord.END_CATCH;
	}

	public IStatement newFinally() {
		return ReservedWord.FINALLY;
	}

	public IStatement newExpression() {
		return ReservedWord.EXPRESSION;
	}
	
	public IStatement newEndExpression() {
		return ReservedWord.END_EXPRESSION;
	}
}
