package jp.sourceforge.hhcp.mining;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import jp.sourceforge.hhcp.statement.IMethodDeclaration;
import jp.sourceforge.hhcp.statement.IStatement;
import jp.sourceforge.hhcp.statement.StatementFactory;
import jp.sourceforge.hhcp.statement.impl.ExpressionStatement;
import jp.sourceforge.hhcp.statement.impl.IfStatement;
import jp.sourceforge.hhcp.statement.impl.LoopStatement;
import jp.sourceforge.hhcp.statement.impl.MethodDeclaration;
import jp.sourceforge.hhcp.statement.impl.MethodStatement;
import jp.sourceforge.hhcp.statement.impl.TryStatement;

public class NullProjectedStatement extends AbstractProjectedStatement {
	StatementFactory _factory;
	Set<String> _keySet;
	List<IStatement> _prefixList;
	List<IStatement> _projectedList;
	IMethodDeclaration _prefixMethod;
	IMethodDeclaration _projectedMethod;

	public NullProjectedStatement(Set<String> keySet) {
		_factory = new StatementFactory();
		_keySet = keySet;
		_prefixList = Collections.synchronizedList(new ArrayList<IStatement>());
		_projectedList = Collections.synchronizedList(new ArrayList<IStatement>());
		_prefixMethod = null;
		_projectedMethod = null;
	}

	@Override
	public void visit(ExpressionStatement statement) {
	}

	@Override
	public void visit(IfStatement statement) {
		ExpressionStatement expression = statement.getExpressionStatement();
		if (_keySet.contains(expression.toString())) {
			addPrefix(_factory.newIfStatement(expression, null, null));
			addProjected(_factory.newIfStatement(expression, statement
					.getThenStatement(), statement.getElseStatement()));
			return;
		}
		if (statement.getThenStatement() != null) {
			statementIterator(statement.getThenStatement());
		}
		if (statement.getElseStatement() != null) {
			statementIterator(statement.getElseStatement());
		}
	}

	@Override
	public void visit(LoopStatement statement) {
		ExpressionStatement expression = statement.getExpressionStatement();
		if (_keySet.contains(expression.toString())) {
			addPrefix(_factory.newLoopStatement(expression, null));
			addProjected(_factory.newLoopStatement(expression, statement.getStatement()));
			return;
		}
		if (statement.getStatement() != null) {
			statementIterator(statement.getStatement());
		}
	}

	@Override
	public void visit(MethodDeclaration statement) {
		_prefixList.clear();
		_projectedList.clear();
		statementIterator(statement.getStatement());
		setPrefixMethod(_factory.newMethodDeclaration(_prefixList));
		setProjectedMethod(_factory.newMethodDeclaration(_projectedList));
	}

	@Override
	public void visit(MethodStatement statement) {
		if (_keySet.contains(statement.toString())) {
			addPrefix(_factory.newMethodStatement(statement.getBinding()));
			addProjected(_factory.newMethodStatement(statement.getBinding()));
		}
	}

	@Override
	public void visit(TryStatement statement) {
	}

	private void statementIterator(List<IStatement> iteratable) {
		Iterator<IStatement> it = iteratable.iterator();
		while (it.hasNext()) {
			((IAcceptable) it.next()).accept(this);
			
			if (_prefixList.size() != 0) {
				return;
			}
		}
	}

	private void addPrefix(IStatement statement) {
		_prefixList.add(statement);
	}

	private void addProjected(IStatement statement) {
		_projectedList.add(statement);
	}

	public IMethodDeclaration getPrefixMethod() {
		return _prefixMethod;
	}

	private void setPrefixMethod(IMethodDeclaration prefixMethod) {
		_prefixMethod = prefixMethod;
	}

	public IMethodDeclaration getProjectedMethod() {
		return _projectedMethod;
	}

	private void setProjectedMethod(IMethodDeclaration projectedMethod) {
		_projectedMethod = projectedMethod;
	}
}
