package jp.sourceforge.hhcp.mining;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import jp.sourceforge.hhcp.statement.IStatement;
import jp.sourceforge.hhcp.statement.impl.ExpressionStatement;
import jp.sourceforge.hhcp.statement.impl.IfStatement;
import jp.sourceforge.hhcp.statement.impl.LoopStatement;
import jp.sourceforge.hhcp.statement.impl.MethodDeclaration;
import jp.sourceforge.hhcp.statement.impl.MethodStatement;
import jp.sourceforge.hhcp.statement.impl.TryStatement;

public class FrequentSet implements IStatementVisitor {
	Set<String> _frequentSet;

	public FrequentSet() {
		_frequentSet =  Collections.synchronizedSet(new HashSet<String>());
	}

	@Override
	public void visit(ExpressionStatement statement) {
		_frequentSet.add(statement.toString());
	}

	@Override
	public void visit(IfStatement statement) {
		statement.getExpressionStatement().accept(this);
		if (statement.getThenStatement() != null) {
			statementIterator(statement.getThenStatement());
		}
		if (statement.getElseStatement() != null) {
			statementIterator(statement.getElseStatement());
		}
	}

	@Override
	public void visit(LoopStatement statement) {
		statement.getExpressionStatement().accept(this);
		if (statement.getStatement() != null) {
			statementIterator(statement.getStatement());
		}
	}

	@Override
	public void visit(MethodDeclaration statement) {
		statementIterator(statement.getStatement());
	}

	@Override
	public void visit(MethodStatement statement) {
		_frequentSet.add(statement.toString());
	}

	@Override
	public void visit(TryStatement statement) {
	}
	
	private void statementIterator(List<IStatement> iteratable) {
		Iterator<IStatement> it = iteratable.iterator();
		while (it.hasNext()) {
			((IAcceptable) it.next()).accept(this);
		}
	}
		
	public void clear() {
		_frequentSet.clear();
	}
	
	public Iterator<String> iterator() {
		return _frequentSet.iterator();
	}
}
