/**
 * The MIT License
 * 
 * Copyright (c) 2009 kyozi0x7c00@gmail.com
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package jp.sourceforge.hhcp.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import jp.sourceforge.hhcp.mining.PrefixSpan;
import jp.sourceforge.hhcp.statement.ASTVisitorList;
import jp.sourceforge.hhcp.statement.ASTVisitorStatementList;
import jp.sourceforge.hhcp.statement.IMethodDeclaration;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

/**
 * Our sample action implements workbench action delegate. The action proxy will
 * be created by the workbench and shown in the UI. When the user tries to use
 * the action, this delegate will be created and execution will be delegated to
 * it.
 * 
 * @see IWorkbenchWindowActionDelegate
 */
public class SampleAction implements IWorkbenchWindowActionDelegate {
	private IWorkbenchWindow _window;
	private List<IMethodDeclaration> _nodes;

	/**
	 * The constructor.
	 */
	public SampleAction() {
	}

	/**
	 * The action has been activated. The argument of the method represents the
	 * 'real' action sitting in the workbench UI.
	 * 
	 * @see IWorkbenchWindowActionDelegate#run
	 */
	public void run(IAction action) {
		_nodes = Collections.synchronizedList(new ArrayList<IMethodDeclaration>());
		IWorkspace iw = ResourcesPlugin.getWorkspace();
		IWorkspaceRoot root = iw.getRoot();
		IProject project = root.getProject("jEdit");
		//IProject project = root.getProject("jhotdraw7.2");

		if (!project.isOpen()) {
			try {
				project.open(new NullProgressMonitor());
			} catch (CoreException e) {
				e.printStackTrace();
			}
		}
		try {
//			fileRead(project);
			walkResources(project.members());
			PrefixSpan ps = new PrefixSpan(1, 4);
			ps.prefixSpan(_nodes);
			System.out.println("fin.");
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * Selection in the workbench has been changed. We can change the state of
	 * the 'real' action here if we want, but this can only happen after the
	 * delegate has been created.
	 * 
	 * @see IWorkbenchWindowActionDelegate#selectionChanged
	 */
	public void selectionChanged(IAction action, ISelection selection) {
	}

	/**
	 * We can use this method to dispose of any system resources we previously
	 * allocated.
	 * 
	 * @see IWorkbenchWindowActionDelegate#dispose
	 */
	public void dispose() {
	}

	/**
	 * We will cache window object in order to be able to provide parent shell
	 * for the message dialog.
	 * 
	 * @see IWorkbenchWindowActionDelegate#init
	 */
	public void init(IWorkbenchWindow window) {
		_window = window;
	}

	private void walkResources(IResource[] resources) throws CoreException {
		ASTParser parser;
		ASTNode ast;
		ASTVisitorStatementList visit;

		parser = ASTParser.newParser(AST.JLS3);
		parser.setResolveBindings(true);
		visit = new ASTVisitorStatementList();
//		ASTVisitorList visit = new ASTVisitorList();

		for (int i = 0; i < resources.length; i++) {
			int type = resources[i].getType();
			switch (type) {
			case IResource.FOLDER:
				IFolder folder = (IFolder) resources[i];
				walkResources(folder.members());
				break;
			case IResource.FILE:
				IFile file = (IFile) resources[i];
				if (file.getFileExtension() != null	&& file.getFileExtension().equals("java")) {
					ICompilationUnit cu = JavaCore.createCompilationUnitFrom(file);
					parser.setSource(cu);
					ast = parser.createAST(new NullProgressMonitor());
					// get methods
					ast.accept(visit);
				}
				break;
			default:
			}
		}
		_nodes.addAll(visit.getMethods());
	}

	private void fileRead(IProject project) {
//		IFile file = project.getFile("src/org/gjt/sp/jedit/ActionSet.java");
//		IFile file = project.getFile("src/bsh/BSHAllocationExpression.java");
		IFile file = project.getFile("src/org/gjt/sp/jedit/options/AbbrevsOptionPane.java");
//		IFile file = project.getFile("src/org/jhotdraw/application/AbstractMDIApplication.java");
//		IFile file = project.getFile("src/org/jhotdraw/app/action/AbstractSaveBeforeAction.java");
//		IFile file = project.getFile("src/org/jhotdraw/draw/ConnectionTool.java");
//		IFile file = project.getFile("src/org/apache/batik/ext/awt/MultipleGradientPaintContext.java");
//		IFile file = project.getFile("src/org/jhotdraw/draw/action/AlignAction.java");
		
		ICompilationUnit cu = JavaCore.createCompilationUnitFrom(file);
		ASTParser parser = ASTParser.newParser(AST.JLS3);
		parser.setResolveBindings(true);
		parser.setSource(cu);
		ASTNode ast = parser.createAST(new NullProgressMonitor());
		ASTVisitorStatementList visit = new ASTVisitorStatementList();
		ast.accept(visit);
		_nodes.addAll(visit.getMethods());
	}
}