package lib.xlsx.writer;

import java.io.File;
import java.util.List;

import lib.io.ExtendFile;
import lib.io.ZipCompresser;

import lib.xlsx.bookDefine.Row;
import lib.xlsx.bookDefine.WorkBook;
import lib.xlsx.bookDefine.Sheet;
import lib.xlsx.bookDefine.Cell;
import lib.xlsx.innerDataDefine.SharedString;
import lib.xml.XMLDocRoot;
import lib.xml.XMLParser;

public class XlsxWriter {
    private String templatePath = "./templates";
    private String filePath = null;
    private String parentPath = null;
    private int textCount = 0;

    /**
     * RXgN^
     * @param filePath o̓GNZt@CpX
     */
    public XlsxWriter(String filePath) {
        this.filePath = filePath;
        ExtendFile file = new ExtendFile(filePath);
        file = new ExtendFile(file.getDosAbsolutePath());
        parentPath = file.getParent();
        templatePath = ExtendFile.getDosAbsolutePath(templatePath);
    }

    /**
     * eXMLt@Co͂BŌZIPk
     * @param book
     */
    public void writeFile(WorkBook book) {
        File file = new File(parentPath);

        file.mkdir();
        // ev[gt@C̃Rs[
        ExtendFile.dirXCopy(templatePath, parentPath);
        textCount = 0;
        XMLDocRoot sharedString = makeSharedString();
        try {

            XMLDocRoot workBookXml = makeWorkBookXml(book);
            workBookXml.FileWrite(parentPath + "\\xl\\workbook.xml");
            workBookXml = null;

            XMLDocRoot workBookRelXml = makeWorkBook_RelXml(book);
            workBookRelXml.FileWrite(parentPath + "\\xl\\_rels\\workbook.xml.rels");
            workBookRelXml = null;

            XMLDocRoot[] sheets = analyzeSheetInfo(book);

        	// ubNŜ̐̕
            sharedString.getRoot().setAttribute("count", String.valueOf(textCount));
            // sharedString.xml̍쐬
            sharedString.FileWrite(parentPath + "\\xl\\sharedStrings.xml");

            // eV[g(sheet**.xml)̍쐬
            for(int i = 0;i < sheets.length;i++) {
                String filePath = parentPath + "\\xl\\worksheets\\sheet";
                filePath += (i + 1) + ".xml";
                sheets[i].FileWrite(filePath);
                sheets[i] = null;
            }

            // 쐬t@CׂZIPk
            ZipCompresser za = new ZipCompresser(new File(parentPath));
            za.archive();
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    /**
     * sharedString.xml̃f[^쐬
     * @return
     */
    private XMLDocRoot makeSharedString() {
        List<String> textList = SharedString.rebuildIndex();

        XMLDocRoot sharedString = new XMLDocRoot("sst");
        sharedString.getRoot().setAttribute("xmlns",
                "http://schemas.openxmlformats.org/spreadsheetml/2006/main");

        // count͌œ
        sharedString.getRoot().setAttribute("count", "");
        sharedString.getRoot().setAttribute("uniqueCount",
                String.valueOf(textList.size()));

        for(String text:textList) {

            XMLParser siTag = new XMLParser("si");
            XMLParser tTag = new XMLParser("t");
            XMLParser phoneticPrTag = new XMLParser("phoneticPr");

            text = text.replaceAll("\\&", "&amp;");

            tTag.appendChild(XMLParser.createTextNode(text));
            phoneticPrTag.setAttribute("fontId", "1");
            siTag.appendChild(tTag);
            siTag.appendChild(phoneticPrTag);
            sharedString.getRoot().appendChild(siTag);
        }
        return sharedString;
    }

    /**
     * V[g쐬XMLCX^X쐬
     * @param book Ώۂ̃[NubN
     * @return V[gƂ̏
     */
    private XMLDocRoot[] analyzeSheetInfo(WorkBook book) {
        int sheetLength = book.sheetLength();
        XMLDocRoot[] xmlSheets = new XMLDocRoot[sheetLength];

        for(int i = 0;i < sheetLength;i++) {
            Sheet sheet = book.getSheet(i);
            xmlSheets[i] = new XMLDocRoot("worksheet");
            XMLParser root = xmlSheets[i].getRoot();
            root.setAttribute("xmlns:r",
                    "http://schemas.openxmlformats.org/officeDocument/2006/relationships");
            root.setAttribute("xmlns",
                    "http://schemas.openxmlformats.org/spreadsheetml/2006/main");
            XMLParser dimensionTag = new XMLParser("dimension");
            dimensionTag.setAttribute("ref", "A1"); // "A1:C1"̗lɎgpZ͈̔͂Ƃ
            root.appendChild(dimensionTag);

            // V[g̑I
            XMLParser sheetViewsTag = new XMLParser("sheetViews");
            XMLParser sheetViewTag = new XMLParser("sheetView");
            sheetViewTag.setAttribute("workbookViewId", "0"); // 3.3.1.83QƁEEE
            XMLParser selectionTag = new XMLParser("selection");
            selectionTag.setAttribute("sqref", "A1"); //I͈
            selectionTag.setAttribute("activeCell", "A1"); // IꂽZ
            sheetViewTag.appendChild(selectionTag);
            sheetViewsTag.appendChild(sheetViewTag);
            root.appendChild(sheetViewsTag);

            XMLParser sheetFormatPrTag = new XMLParser("sheetFormatPr");
            sheetFormatPrTag.setAttribute("defaultRowHeight", "13.5");
            root.appendChild(sheetFormatPrTag);

            // V[g̑SeLXg𒊏osheetTag쐬
            XMLParser sheetDataTag = makeSheetTag(sheet);
            root.appendChild(sheetDataTag);

            // Ԃǂ݉^OEEE
            XMLParser phoneticPrTag = new XMLParser("phoneticPr");
            phoneticPrTag.setAttribute("fontId", "1");
            root.appendChild(phoneticPrTag);

            XMLParser pageMarginsTag = new XMLParser("pageMargins");
            pageMarginsTag.setAttribute("footer", "0.3");
            pageMarginsTag.setAttribute("bottom", "0.75");
            pageMarginsTag.setAttribute("left", "0.7");
            pageMarginsTag.setAttribute("right", "0.7");
            pageMarginsTag.setAttribute("header", "0.3");
            pageMarginsTag.setAttribute("top", "0.75");
            root.appendChild(pageMarginsTag);
        }
        return xmlSheets;
    }

    /**
     * eV[g̃f[^CX^X쐬
     * @param sheet
     * @return
     */
    private XMLParser makeSheetTag(Sheet sheet) {
        XMLParser sheetDataTag = new XMLParser("sheetData");

        // s̐vf쐬
        for(int i = 0;i < sheet.rowLength();i++) {
            Row row = sheet.getRow(i + 1);
            XMLParser rowTag = new XMLParser("row");
            rowTag.setAttribute("spans", "1:3");
            rowTag.setAttribute("r", String.valueOf(i + 1));

            sheetDataTag.appendChild(rowTag);
            int lastIndex = row.getLastIndex();
            char cellMark = 'A';
            // ̍EɌėvf쐬
            for(int j = 0;j < lastIndex;j++) {
                String text = row.getCellText(j);
                Cell cell = row.getCell(j);

                String cellR = "" + cellMark;
                cellR += (i + 1);
                cellMark++; // TODO 'Z'܂łȂ炱̕@ő₹邯ǁEEE
                if(cell == null || cell.getCellType() == Cell.TYPE_UNDEFINE) {
                    continue;
                }

                XMLParser cTag = new XMLParser("c");
                XMLParser vTag = new XMLParser("v");
                cTag.setAttribute("r", cellR);
                // ȂsharedStringǂݍރtOt t=s
                if(cell.getCellType() == Cell.TYPE_STRING) {
	                cTag.setAttribute("t", "s");
	                int ssIndex = SharedString.getIndex(text);
	                vTag.appendChild(XMLParser.createTextNode(String.valueOf(ssIndex)));
	                textCount++;
	            // lȂl𒼐ڏ
                } else if(cell.getCellType() == Cell.TYPE_INTEGER) {
	                vTag.appendChild(XMLParser.createTextNode(cell.getString()));
                }
                cTag.appendChild(vTag);
                rowTag.appendChild(cTag);
            }
        }
        return sheetDataTag;
    }

    /**
     * WorkBook.xmlp̃f[^쐬
     * @param book
     * @return
     */
    private XMLDocRoot makeWorkBookXml(WorkBook book) {
        int sheetLength = book.sheetLength();
        XMLDocRoot workBookXml = new XMLDocRoot("workbook");
        XMLParser root = workBookXml.getRoot();
        root.setAttribute("xmlns", "http://schemas.openxmlformats.org/spreadsheetml/2006/main");
        root.setAttribute("xmlns:r", "http://schemas.openxmlformats.org/officeDocument/2006/relationships");

        XMLParser fileVer = new XMLParser("fileVersion");
        fileVer.setAttribute("appName", "xl");
        fileVer.setAttribute("lastEdited", "4");
        fileVer.setAttribute("lowestEdited", "4");
        fileVer.setAttribute("rupBuild", "4505");
        root.appendChild(fileVer);

        XMLParser workBookPr = new XMLParser("workbookPr");
        workBookPr.setAttribute("defaultThemeVersion", "124226");
        root.appendChild(workBookPr);

        XMLParser bookViews = new XMLParser("bookViews");
        XMLParser bookVworkbookView = new XMLParser("workbookView");
        bookVworkbookView.setAttribute("xWindow", "480");
        bookVworkbookView.setAttribute("yWindow", "30");
        bookVworkbookView.setAttribute("windowWidth", "18255");
        bookVworkbookView.setAttribute("windowHeight", "12030");
        bookViews.appendChild(bookVworkbookView);
        root.appendChild(bookViews);

        XMLParser sheets = new XMLParser("sheets");
        for(int i = 0;i < sheetLength;i++) {
            XMLParser sheetXml = new XMLParser("sheet");
            Sheet sheet = book.getSheet(i);
            sheetXml.setAttribute("name", sheet.getSheetName());
            sheetXml.setAttribute("sheetId", String.valueOf(i + 1));
            sheetXml.setAttribute("r:id", "rId" + (i + 4));
            sheets.appendChild(sheetXml);
        }
        root.appendChild(sheets);

        XMLParser definedNames = new XMLParser("definedNames");
        root.appendChild(definedNames);

        XMLParser calcPr = new XMLParser("calcPr");
        calcPr.setAttribute("calcId", "124519");
        root.appendChild(calcPr);

        return workBookXml;
    }

    /**
     * workbook.xml.relsp̃f[^쐬
     * @param book
     * @return
     */
    private XMLDocRoot makeWorkBook_RelXml(WorkBook book) {
        int sheetLength = book.sheetLength();
        XMLDocRoot workBookRelXml = new XMLDocRoot("Relationships");
        XMLParser root = workBookRelXml.getRoot();
        root.setAttribute("xmlns", "http://schemas.openxmlformats.org/package/2006/relationships");

        // theme1.xml
        XMLParser relationship = new XMLParser("Relationship");
        relationship.setAttribute("Id", "rId1");
        relationship.setAttribute("Type", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/theme");
        relationship.setAttribute("Target", "theme/theme1.xml");
        root.appendChild(relationship);

        // styles.xml
        relationship = new XMLParser("Relationship");
        relationship.setAttribute("Id", "rId2");
        relationship.setAttribute("Type", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/styles");
        relationship.setAttribute("Target", "styles.xml");
        root.appendChild(relationship);

        // sharedStrings.xml
        relationship = new XMLParser("Relationship");
        relationship.setAttribute("Id", "rId3");
        relationship.setAttribute("Type", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/sharedStrings");
        relationship.setAttribute("Target", "sharedStrings.xml");
        root.appendChild(relationship);

        for(int i = 0;i < sheetLength;i++) {
            relationship = new XMLParser("Relationship");
            relationship.setAttribute("Id", "rId" + (i + 4));
            relationship.setAttribute("Type", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/worksheet");
            relationship.setAttribute("Target", "worksheets/sheet" + (i + 1) + ".xml");
            root.appendChild(relationship);
        }
    	return workBookRelXml;
    }

    private String incrementCellMark(String crtMark) {
    	return null;
    }
}
