package lib.xlsx.bookDefine;


public class Row {
	Cell[] cellList;
	/** lĂԉE[̃Z */
	private int lastCellIndex;
	/** lĂZ̐ */
	private int existCellLength;
	public Row() {
		cellList = new Cell[1024];
		for(int i = 0;i < cellList.length;i++) {
			cellList[i] = null;
		}
		lastCellIndex = -1;
		existCellLength = 0;
	}
	public int cellExistLength() {
		return existCellLength;
	}
	public int getLastIndex() {
		return lastCellIndex + 1;
	}
	
	public void setCellValue(int colNum, String value) {
		if(cellList[colNum] == null) {
			cellList[colNum] = new Cell();
		}
		if(cellList[colNum].getCellType() != Cell.TYPE_UNDEFINE) {
			existCellLength--;
		}
		cellList[colNum].setString(value);
		if(colNum > lastCellIndex) {
			lastCellIndex = colNum;
		}
		if(cellList[colNum].getCellType() != Cell.TYPE_UNDEFINE) {
			existCellLength++;
		}
	}

	public void setCellValue(int colNum, int value) {
		if(cellList[colNum] == null) {
			cellList[colNum] = new Cell();
		}
		if(cellList[colNum].getCellType() != Cell.TYPE_UNDEFINE) {
			existCellLength--;
		}
		cellList[colNum].setInteger(value);
		if(colNum > lastCellIndex) {
			lastCellIndex = colNum;
		}
		if(cellList[colNum].getCellType() != Cell.TYPE_UNDEFINE) {
			existCellLength++;
		}
	}

	public Cell getCell(int colNum) {
		return cellList[colNum];
	}
	public String getCellText(int colNum) {
		if(cellList[colNum] == null) {
			return null;
		}
		return cellList[colNum].getString();
	}
	public String toString() {
		String retStr = "";
		for(int i = 0;i < getLastIndex();i++) {
			if(cellList[i] == null) {
				retStr += "[" + i + "]:null, ";
			} else {
				retStr += "[" + i + "]:" + cellList[i].toString() + ", ";
			}
		}
		return retStr;
	}

}
