/*
 * Decompiled with CFR 0.152.
 */
package java.sql;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class DriverManager {
    private static PrintStream log_stream;
    private static PrintWriter log_writer;
    private static int login_timeout;
    private static Vector drivers;

    private DriverManager() {
    }

    public static PrintWriter getLogWriter() {
        return log_writer;
    }

    public static void setLogWriter(PrintWriter printWriter) {
        log_writer = printWriter;
    }

    public static Connection getConnection(String string, Properties properties) throws SQLException {
        Driver driver = DriverManager.getDriver(string);
        if (driver == null) {
            throw new SQLException("Driver not found for URL: " + string);
        }
        return driver.connect(string, properties);
    }

    public static Connection getConnection(String string, String string2, String string3) throws SQLException {
        Properties properties = new Properties();
        if (string2 != null) {
            properties.setProperty("user", string2);
        }
        if (string3 != null) {
            properties.setProperty("password", string3);
        }
        return DriverManager.getConnection(string, properties);
    }

    public static Connection getConnection(String string) throws SQLException {
        return DriverManager.getConnection(string, new Properties());
    }

    public static Driver getDriver(String string) throws SQLException {
        Enumeration enumeration = drivers.elements();
        while (enumeration.hasMoreElements()) {
            Driver driver = (Driver)enumeration.nextElement();
            if (!driver.acceptsURL(string)) continue;
            return driver;
        }
        throw new SQLException("No driver found for " + string);
    }

    public static void registerDriver(Driver driver) throws SQLException {
        if (!drivers.contains(driver)) {
            drivers.addElement(driver);
        }
    }

    public static void deregisterDriver(Driver driver) throws SQLException {
        if (drivers.contains(driver)) {
            drivers.removeElement(driver);
        }
    }

    public static Enumeration getDrivers() {
        Vector vector = new Vector();
        Enumeration enumeration = drivers.elements();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            ClassLoader classLoader2 = e.getClass().getClassLoader();
            if (classLoader2 == null) {
                classLoader2 = ClassLoader.getSystemClassLoader();
            }
            if (!classLoader2.equals(classLoader)) continue;
            vector.addElement(e);
        }
        return vector.elements();
    }

    public static void setLoginTimeout(int n) {
        login_timeout = n;
    }

    public static int getLoginTimeout() {
        return login_timeout;
    }

    public static void setLogStream(PrintStream printStream) {
        log_stream = printStream;
    }

    public static PrintStream getLogStream() {
        return log_stream;
    }

    public static void println(String string) {
        if (log_stream != null) {
            log_stream.println(string);
        }
    }

    static {
        drivers = new Vector();
        String string = System.getProperty("jdbc.drivers");
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                try {
                    Class.forName(string2);
                }
                catch (Exception exception) {}
            }
        }
    }
}

