/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite;

import java.io.File;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import org.sqlite.DB;
import org.sqlite.MetaData;
import org.sqlite.PrepStmt;
import org.sqlite.Stmt;

class Conn
implements Connection {
    private final String url;
    private DB db = null;
    private MetaData meta = null;
    private boolean autoCommit = true;
    private int transactionIsolation = 8;
    private int timeout = 0;

    public Conn(String url, String filename, boolean sharedCache) throws SQLException {
        this(url, filename);
        this.db.shared_cache(sharedCache);
    }

    public Conn(String url, String filename) throws SQLException {
        if (!":memory:".equals(filename)) {
            File file = new File(filename).getAbsoluteFile();
            File parent = file.getParentFile();
            if (parent != null && !parent.exists()) {
                File up = parent;
                while (up != null && !up.exists()) {
                    parent = up;
                    up = up.getParentFile();
                }
                throw new SQLException("path to '" + filename + "': '" + parent + "' does not exist");
            }
            try {
                if (!file.exists() && file.createNewFile()) {
                    file.delete();
                }
            }
            catch (Exception e) {
                throw new SQLException("opening db: '" + filename + "': " + e.getMessage());
            }
            filename = file.getAbsolutePath();
        }
        try {
            Class<?> nativedb = Class.forName("org.sqlite.NativeDB");
            if (((Boolean)nativedb.getDeclaredMethod("load", null).invoke(null, null)).booleanValue()) {
                this.db = (DB)nativedb.newInstance();
            }
        }
        catch (Exception nativedb) {
            // empty catch block
        }
        if (this.db == null) {
            try {
                this.db = (DB)Class.forName("org.sqlite.NestedDB").newInstance();
            }
            catch (Exception e) {
                throw new SQLException("no SQLite library found");
            }
        }
        this.url = url;
        this.db.open(this, filename);
        this.setTimeout(3000);
    }

    int getTimeout() {
        return this.timeout;
    }

    void setTimeout(int ms) throws SQLException {
        this.timeout = ms;
        this.db.busy_timeout(ms);
    }

    String url() {
        return this.url;
    }

    String libversion() throws SQLException {
        return this.db.libversion();
    }

    DB db() {
        return this.db;
    }

    private void checkOpen() throws SQLException {
        if (this.db == null) {
            throw new SQLException("database connection closed");
        }
    }

    private void checkCursor(int rst, int rsc, int rsh) throws SQLException {
        if (rst != 1003) {
            throw new SQLException("SQLite only supports TYPE_FORWARD_ONLY cursors");
        }
        if (rsc != 1007) {
            throw new SQLException("SQLite only supports CONCUR_READ_ONLY cursors");
        }
        if (rsh != 2) {
            throw new SQLException("SQLite only supports closing cursors at commit");
        }
    }

    public void finalize() throws SQLException {
        this.close();
    }

    public void close() throws SQLException {
        if (this.db == null) {
            return;
        }
        if (this.meta != null) {
            this.meta.close();
        }
        this.db.close();
        this.db = null;
    }

    public boolean isClosed() throws SQLException {
        return this.db == null;
    }

    public String getCatalog() throws SQLException {
        this.checkOpen();
        return null;
    }

    public void setCatalog(String catalog) throws SQLException {
        this.checkOpen();
    }

    public int getHoldability() throws SQLException {
        this.checkOpen();
        return 2;
    }

    public void setHoldability(int h) throws SQLException {
        this.checkOpen();
        if (h != 2) {
            throw new SQLException("SQLite only supports CLOSE_CURSORS_AT_COMMIT");
        }
    }

    public int getTransactionIsolation() {
        return this.transactionIsolation;
    }

    public void setTransactionIsolation(int level) throws SQLException {
        switch (level) {
            case 8: {
                this.db.exec("PRAGMA read_uncommitted = false;");
                break;
            }
            case 1: {
                this.db.exec("PRAGMA read_uncommitted = true;");
                break;
            }
            default: {
                throw new SQLException("SQLite supports only TRANSACTION_SERIALIZABLE and TRANSACTION_READ_UNCOMMITTED.");
            }
        }
        this.transactionIsolation = level;
    }

    public Map getTypeMap() throws SQLException {
        throw new SQLException("not yet implemented");
    }

    public void setTypeMap(Map map) throws SQLException {
        throw new SQLException("not yet implemented");
    }

    public boolean isReadOnly() throws SQLException {
        return false;
    }

    public void setReadOnly(boolean ro) throws SQLException {
    }

    public DatabaseMetaData getMetaData() {
        if (this.meta == null) {
            this.meta = new MetaData(this);
        }
        return this.meta;
    }

    public String nativeSQL(String sql) {
        return sql;
    }

    public void clearWarnings() throws SQLException {
    }

    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public boolean getAutoCommit() throws SQLException {
        this.checkOpen();
        return this.autoCommit;
    }

    public void setAutoCommit(boolean ac) throws SQLException {
        this.checkOpen();
        if (this.autoCommit == ac) {
            return;
        }
        this.autoCommit = ac;
        this.db.exec(this.autoCommit ? "commit;" : "begin;");
    }

    public void commit() throws SQLException {
        this.checkOpen();
        if (this.autoCommit) {
            throw new SQLException("database in auto-commit mode");
        }
        this.db.exec("commit;");
        this.db.exec("begin;");
    }

    public void rollback() throws SQLException {
        this.checkOpen();
        if (this.autoCommit) {
            throw new SQLException("database in auto-commit mode");
        }
        this.db.exec("rollback;");
        this.db.exec("begin;");
    }

    public Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007, 2);
    }

    public Statement createStatement(int rsType, int rsConcurr) throws SQLException {
        return this.createStatement(rsType, rsConcurr, 2);
    }

    public Statement createStatement(int rst, int rsc, int rsh) throws SQLException {
        this.checkCursor(rst, rsc, rsh);
        return new Stmt(this);
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        return this.prepareCall(sql, 1003, 1007, 2);
    }

    public CallableStatement prepareCall(String sql, int rst, int rsc) throws SQLException {
        return this.prepareCall(sql, rst, rsc, 2);
    }

    public CallableStatement prepareCall(String sql, int rst, int rsc, int rsh) throws SQLException {
        throw new SQLException("SQLite does not support Stored Procedures");
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, 1003, 1007);
    }

    public PreparedStatement prepareStatement(String sql, int autoC) throws SQLException {
        throw new SQLException("NYI");
    }

    public PreparedStatement prepareStatement(String sql, int[] colInds) throws SQLException {
        throw new SQLException("NYI");
    }

    public PreparedStatement prepareStatement(String sql, String[] colNames) throws SQLException {
        throw new SQLException("NYI");
    }

    public PreparedStatement prepareStatement(String sql, int rst, int rsc) throws SQLException {
        return this.prepareStatement(sql, rst, rsc, 2);
    }

    public PreparedStatement prepareStatement(String sql, int rst, int rsc, int rsh) throws SQLException {
        this.checkCursor(rst, rsc, rsh);
        return new PrepStmt(this, sql);
    }

    String getDriverVersion() {
        if (this.db != null) {
            String dbname = this.db.getClass().getName();
            if (dbname.indexOf("NestedDB") >= 0) {
                return "pure";
            }
            if (dbname.indexOf("NativeDB") >= 0) {
                return "native";
            }
        }
        return "unloaded";
    }

    public Savepoint setSavepoint() throws SQLException {
        throw new SQLException("unsupported by SQLite: savepoints");
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        throw new SQLException("unsupported by SQLite: savepoints");
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new SQLException("unsupported by SQLite: savepoints");
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        throw new SQLException("unsupported by SQLite: savepoints");
    }

    public Struct createStruct(String t, Object[] attr) throws SQLException {
        throw new SQLException("unsupported by SQLite");
    }
}

